/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip.fm;

import jef.sound.chip.fm.FMChan;
import jef.sound.chip.fm.FMConstants;
import jef.sound.chip.fm.FMIRQHandler;
import jef.sound.chip.fm.FMTimerHandler;

public class FMState
implements FMConstants {
    public static final int FM_TIMER_INTERVAL = 0;
    public int index;
    public int clock;
    public int rate;
    public double freqbase;
    public double TimerBase;
    public int address;
    public int irq;
    public int irqmask;
    public int status;
    public long mode;
    public int TA;
    public int TAC;
    public int TB;
    public int TBC;
    public int[][] DT_TABLE = new int[8][32];
    public int[] AR_TABLE = new int[94];
    public int[] DR_TABLE = new int[94];
    public FMTimerHandler Timer_Handler;
    public FMIRQHandler IRQ_Handler;
    public int timermodel;

    public FMState(FMIRQHandler ih) {
        this.IRQ_Handler = ih;
    }

    public void FMSetMode(int n, int v) {
        this.mode = v;
        if ((v & 0x20) != 0) {
            this.FM_STATUS_RESET(2);
        }
        if ((v & 0x10) != 0) {
            this.FM_STATUS_RESET(1);
        }
        if ((v & 2) != 0) {
            if (this.TBC == 0) {
                this.TBC = 256 - this.TB << 4;
                if (this.Timer_Handler != null) {
                    this.Timer_Handler.n = n;
                    this.Timer_Handler.c = 1;
                    this.Timer_Handler.cnt = this.TBC;
                    this.Timer_Handler.stepTime = this.TimerBase;
                }
            }
        } else if (this.timermodel == 0 && this.TBC != 0) {
            this.TBC = 0;
            if (this.Timer_Handler != null) {
                this.Timer_Handler.n = n;
                this.Timer_Handler.c = 1;
                this.Timer_Handler.cnt = 0.0;
                this.Timer_Handler.stepTime = this.TimerBase;
            }
        }
        if ((v & 1) != 0) {
            if (this.TAC == 0) {
                this.TAC = 1024 - this.TA;
                if (this.Timer_Handler != null) {
                    this.Timer_Handler.n = n;
                    this.Timer_Handler.c = 0;
                    this.Timer_Handler.cnt = this.TAC;
                    this.Timer_Handler.stepTime = this.TimerBase;
                }
            }
        } else if (this.timermodel == 0 && this.TAC != 0) {
            this.TAC = 0;
            if (this.Timer_Handler != null) {
                this.Timer_Handler.n = n;
                this.Timer_Handler.c = 0;
                this.Timer_Handler.cnt = 0.0;
                this.Timer_Handler.stepTime = this.TimerBase;
            }
        }
    }

    public void FM_STATUS_SET(int flag) {
        this.status |= flag;
        if (this.irq == 0 && (this.status & this.irqmask) != 0) {
            this.irq = 1;
            if (this.IRQ_Handler != null) {
                this.IRQ_Handler.irq(this.index, 1);
            }
        }
    }

    public void FM_STATUS_RESET(int flag) {
        this.status &= ~flag;
        if (this.irq != 0 && (this.status & this.irqmask) == 0) {
            this.irq = 0;
            if (this.IRQ_Handler != null) {
                this.IRQ_Handler.irq(this.index, 0);
            }
        }
    }

    public void FM_IRQMASK_SET(int flag) {
        this.irqmask = flag;
        System.out.println("FM_IRQMASK_SET, irqmask = " + this.irqmask);
        this.FM_STATUS_SET(0);
        this.FM_STATUS_RESET(0);
    }

    public void INTERNAL_TIMER_A(FMChan CSM_CH) {
        if (this.TAC != 0 && this.Timer_Handler == null && (this.TAC = (int)((double)this.TAC - this.freqbase * 4096.0)) <= 0) {
            this.TimerAOver();
            if ((this.mode & 0x80L) != 0L) {
                CSM_CH.CSMKeyControll();
            }
        }
    }

    public void INTERNAL_TIMER_B(int step) {
        if (this.TBC != 0 && this.Timer_Handler == null && (this.TBC = (int)((double)this.TBC - this.freqbase * 4096.0 * (double)step)) <= 0) {
            this.TimerBOver();
        }
    }

    public void TimerAOver() {
        if ((this.mode & 4L) != 0L) {
            this.FM_STATUS_SET(1);
        }
        this.TAC = this.timermodel == 0 ? 1024 - this.TA : 0;
    }

    public void TimerBOver() {
        if ((this.mode & 8L) != 0L) {
            this.FM_STATUS_SET(2);
        }
        this.TBC = this.timermodel == 0 ? 256 - this.TB << 4 : 0;
    }

    public void init_timetables(int[] DTTABLE, int ARRATE, int DRRATE) {
        double rate;
        int i;
        int d = 0;
        while (d <= 3) {
            i = 0;
            while (i <= 31) {
                rate = (double)DTTABLE[d * 32 + i] * this.freqbase * 8.0;
                this.DT_TABLE[d][i] = (int)rate;
                this.DT_TABLE[d + 4][i] = (int)(-rate);
                ++i;
            }
            ++d;
        }
        i = 0;
        while (i < 4) {
            this.DR_TABLE[i] = 0;
            this.AR_TABLE[i] = 0;
            ++i;
        }
        i = 4;
        while (i < 64) {
            rate = this.freqbase;
            if (i < 60) {
                rate *= 1.0 + (double)(i & 3) * 0.25;
            }
            rate *= (double)(1 << (i >> 2) - 1);
            this.AR_TABLE[i] = (int)((rate *= 2.68435456E8) / (double)ARRATE);
            this.DR_TABLE[i] = (int)(rate / (double)DRRATE);
            ++i;
        }
        this.AR_TABLE[62] = 0xFFFFFFF;
        this.AR_TABLE[63] = 0xFFFFFFF;
        i = 64;
        while (i < 94) {
            this.AR_TABLE[i] = this.AR_TABLE[63];
            this.DR_TABLE[i] = this.DR_TABLE[63];
            ++i;
        }
    }
}

