/*
 * Decompiled with CFR 0.152.
 */
package jef.video;

import jef.video.BitMap;

public final class BitMapImpl
implements BitMap {
    BitMapImpl scaled;
    int[] pixels;
    final int w;
    final int h;
    final int w1;
    final int h1;

    public BitMapImpl(int w, int h) {
        this.w = w;
        this.h = h;
        this.w1 = w - 1;
        this.h1 = h - 1;
        this.pixels = new int[w * h];
    }

    public BitMapImpl(int w, int h, boolean transparent) {
        this.w = w;
        this.h = h;
        this.w1 = w - 1;
        this.h1 = h - 1;
        this.pixels = new int[w * h];
        if (transparent) {
            int i = 0;
            while (i < this.pixels.length) {
                this.pixels[i] = -1;
                ++i;
            }
        }
    }

    public BitMapImpl(int w, int h, int[] pixels) {
        this.w = w;
        this.h = h;
        this.w1 = w - 1;
        this.h1 = h - 1;
        this.pixels = pixels;
    }

    public final void setPixels(int[] pixels) {
        this.pixels = pixels;
    }

    public final int[] getPixels() {
        return this.pixels;
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public final void setPixel(int x, int y, int c) {
        if (x >= 0 && x < this.w && y >= 0 && y < this.h) {
            this.pixels[x + y * this.w] = c;
        }
    }

    public final void setPixelFast(int x, int y, int c) {
        this.pixels[x + y * this.w] = c;
    }

    public final int getPixel(int x, int y) {
        if (x >= 0 && x < this.w && y >= 0 && y < this.h) {
            return this.pixels[x + y * this.w];
        }
        return -1;
    }

    public final void toPixels(int[] target) {
        System.arraycopy(this.pixels, 0, target, 0, target.length);
    }

    public final void toBitMap(BitMap bm, int x, int y) {
        int ofs = 0;
        int iy = 0;
        while (iy < this.h) {
            int ix = 0;
            while (ix < this.w) {
                int c;
                if ((c = this.pixels[ofs++]) >= 0) {
                    bm.setPixel(x + ix, y, c);
                }
                ++ix;
            }
            ++y;
            ++iy;
        }
    }

    public final void toBitMap(BitMap bm, int x, int y, boolean fx, boolean fy) {
        int iy = 0;
        while (iy < this.h) {
            int iiy = fy ? (this.h1 - iy) * this.w : iy * this.w;
            int ix = 0;
            while (ix < this.w) {
                int iix = fx ? this.w1 - ix : ix;
                int c = this.pixels[iiy + iix];
                if (c >= 0) {
                    bm.setPixel(x + ix, y, c);
                }
                ++ix;
            }
            ++y;
            ++iy;
        }
    }

    public final void toBitMap(BitMap bm, int x, int y, boolean fx, boolean fy, boolean overwriteTransparency) {
        int maxy;
        int maxx = this.w;
        if (maxx + x > bm.getWidth()) {
            maxx = bm.getWidth() - x;
        }
        if ((maxy = this.h) + y > bm.getHeight()) {
            maxy = bm.getHeight() - y;
        }
        int yd = y;
        if (overwriteTransparency) {
            int iy = 0;
            while (iy < maxy) {
                int iiy = fy ? (this.h1 - iy) * this.w : iy * this.w;
                int ix = 0;
                while (ix < maxx) {
                    int iix = fx ? this.w1 - ix : ix;
                    int c = this.pixels[iiy + iix];
                    bm.setPixel(x + ix, yd, c);
                    ++ix;
                }
                ++yd;
                ++iy;
            }
        } else {
            int iy = 0;
            while (iy < maxy) {
                int iiy = fy ? (this.h1 - iy) * this.w : iy * this.w;
                int ix = 0;
                while (ix < maxx) {
                    int iix = fx ? this.w1 - ix : ix;
                    int c = this.pixels[iiy + iix];
                    if (c >= 0) {
                        bm.setPixel(x + ix, yd, c);
                    }
                    ++ix;
                }
                ++yd;
                ++iy;
            }
        }
    }

    public final void toBitMap(BitMap bm, int x, int y, int sx, int sy, int sw, int sh) {
        int l = this.pixels.length;
        int i = sy * this.w + sx;
        int iy = 0;
        while (iy < sh) {
            int ii = i;
            int ix = 0;
            while (ix < sw) {
                int c;
                if (ii >= 0 && ii < l && (c = this.pixels[ii++]) >= 0) {
                    bm.setPixel(x + ix, y + iy, c);
                }
                ++ix;
            }
            i += this.w;
            ++iy;
        }
    }

    public final void toBitMap(BitMap bm, int x, int y, int sx, int sy, int sw, int sh, int transp) {
        int l = this.pixels.length;
        int i = sy * this.w + sx;
        if (transp == -1) {
            int iy = 0;
            while (iy < sh) {
                int ii = i;
                int ix = 0;
                while (ix < sw) {
                    int c;
                    if (ii >= 0 && ii < l && (c = this.pixels[ii++]) >= 0) {
                        bm.setPixel(x + ix, y + iy, c);
                    }
                    ++ix;
                }
                i += this.w;
                ++iy;
            }
        } else {
            int iy = 0;
            while (iy < sh) {
                int ii = i;
                int ix = 0;
                while (ix < sw) {
                    int c;
                    if (ii >= 0 && ii < l && (c = this.pixels[ii++]) != transp) {
                        bm.setPixel(x + ix, y + iy, c);
                    }
                    ++ix;
                }
                i += this.w;
                ++iy;
            }
        }
    }

    public final void toBitMapScrollXY(BitMap dest, int xScroll, int yScroll, int transparency, int transcolor) {
        int sw = this.w;
        int sh = this.h;
        int dw = dest.getWidth();
        int dh = dest.getHeight();
        if ((xScroll %= sw) + dw <= sw && (yScroll %= sh) + dh <= sh) {
            this.toBitMap(dest, 0, 0, xScroll, yScroll, dw, dh);
        } else if (xScroll + dw > sw && yScroll + dh <= sh) {
            this.toBitMap(dest, 0, 0, xScroll, yScroll, sw - xScroll, dh);
            this.toBitMap(dest, sw - xScroll, 0, xScroll + (sw - xScroll), yScroll, dw - (sw - xScroll), dh);
        } else if (xScroll + dw <= sw && yScroll + dh > sh) {
            this.toBitMap(dest, 0, 0, xScroll, yScroll, dw, dh - (yScroll + dh - sh));
            this.toBitMap(dest, 0, dh - (yScroll + dh - sh), xScroll, 0, dw, yScroll + dh - sh);
        } else {
            this.toBitMap(dest, sw - xScroll, sh - yScroll, 0, 0, xScroll + dw - sw, yScroll + dh - sh);
            this.toBitMap(dest, 0, sh - yScroll, xScroll, 0, sw - xScroll, yScroll + dh - sh);
            this.toBitMap(dest, sw - xScroll, 0, 0, yScroll, xScroll + this.w - sw, sh - yScroll);
            this.toBitMap(dest, 0, 0, xScroll, yScroll, sw - xScroll, sh - yScroll);
        }
    }

    public final void toBitMapScrollXRow(BitMap dest, int xScroll, int ySrc, int srcHeight, int yDst) {
    }

    public final void toBitMapScrollYCol(BitMap dest, int yScroll, int xSrc, int srcWidth, int xDst) {
    }

    public final BitMap getScaledBitMap(int scale, int renderMode) {
        if (this.scaled == null) {
            this.scaled = new BitMapImpl(this.w << 1, this.h << 1);
        }
        this.processScaledImage(scale, 1);
        return this.scaled;
    }

    protected void processScaledImage(int scale, int mode) {
        int dx = this.w;
        int dy = this.h;
        int srcofs = 0;
        int dstofs = 0;
        int[] dpixels = this.scaled.getPixels();
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                int y = 0;
                while (y < dy) {
                    int x = 0;
                    while (x < dx - 1) {
                        int p1 = this.pixels[srcofs];
                        int p2 = this.blendColors(p1, this.pixels[srcofs + 1]);
                        int i1 = dstofs + (x << 1);
                        int i2 = i1 + this.scaled.w;
                        dpixels[i1] = p1;
                        dpixels[i1 + 1] = p1;
                        dpixels[i2] = p1 >> 1 & 0x7F7F7F;
                        dpixels[i2 + 1] = p2 >> 1 & 0x7F7F7F;
                        ++srcofs;
                        ++x;
                    }
                    ++srcofs;
                    dstofs += this.scaled.w << 1;
                    ++y;
                }
                break;
            }
            case 2: {
                srcofs = dx + 1;
                dstofs = this.scaled.w << 1;
                int y = 1;
                while (y < dy - 1) {
                    int x = 1;
                    while (x < dx - 1) {
                        int A = this.pixels[srcofs - dx - 1];
                        int B = this.pixels[srcofs - dx];
                        int C = this.pixels[srcofs - dx + 1];
                        int D = this.pixels[srcofs - 1];
                        int E = this.pixels[srcofs];
                        int F = this.pixels[srcofs + 1];
                        int G = this.pixels[srcofs + dx - 1];
                        int H = this.pixels[srcofs + dx];
                        int I = this.pixels[srcofs + dx + 1];
                        int E0 = D == B && B != F && D != H ? D : E;
                        int E1 = B == F && B != D && F != H ? F : E;
                        int E2 = D == H && D != B && H != F ? D : E;
                        int E3 = H == F && D != H && B != F ? F : E;
                        int i1 = dstofs + (x << 1);
                        int i2 = i1 + this.scaled.w;
                        dpixels[i1] = E0;
                        dpixels[i1 + 1] = E1;
                        dpixels[i2] = E2;
                        dpixels[i2 + 1] = E3;
                        ++srcofs;
                        ++x;
                    }
                    srcofs += 2;
                    dstofs += this.scaled.w << 1;
                    ++y;
                }
                break;
            }
        }
    }

    protected final int blendColors(int col1, int col2) {
        int b1 = col1 & 0xFF;
        int g1 = col1 >> 8 & 0xFF;
        int r1 = col1 >> 16;
        int b2 = col2 & 0xFF;
        int g2 = col2 >> 8 & 0xFF;
        int r2 = col2 >> 16;
        return r1 + r2 >> 1 << 16 | g1 + g2 >> 1 << 8 | b1 + b2 >> 1;
    }

    protected final int dimColor(int col) {
        return col >> 1 & 0x7F7F7F;
    }
}

