/*
 * Decompiled with CFR 0.152.
 */
package cottage.machine;

import jef.machine.BasicMachine;
import jef.machine.Machine;
import jef.map.InterruptHandler;
import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.sound.SamplePlayer;

public class Bw8080
extends BasicMachine
implements Machine {
    static SamplePlayer samples = new SamplePlayer();
    static int shift_amount = 0;
    static int shift_data1 = 0;
    static int shift_data2 = 0;
    static int count = 0;

    static {
        try {
            samples.loadSound("/0.wav");
            samples.loadSound("/1.wav");
            samples.loadSound("/2.wav");
            samples.loadSound("/3.wav");
            samples.loadSound("/4.wav");
            samples.loadSound("/5.wav");
            samples.loadSound("/6.wav");
            samples.loadSound("/7.wav");
            samples.loadSound("/8.wav");
            samples.loadSound("/9.wav");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static int SHIFT() {
        return (shift_data1 << 8 | shift_data2) << (shift_amount & 7) >> 8 & 0xFF;
    }

    public int bw_interrupt() {
        if ((++count & 1) == 1) {
            return 0;
        }
        return 1;
    }

    public WriteHandler c8080bw_shift_amount_w(Bw8080 b) {
        return new Invaders_shift_amount_w(b);
    }

    public WriteHandler c8080bw_shift_data_w(Bw8080 b) {
        return new Invaders_shift_data_w(b);
    }

    public WriteHandler invaders_sh_port3_w(Bw8080 b) {
        return new Invaders_sh_port3_w(b);
    }

    public WriteHandler invaders_sh_port5_w(Bw8080 b) {
        return new Invaders_sh_port5_w(b);
    }

    public ReadHandler c8080bw_shift_data_r(Bw8080 b) {
        return new Invaders_shift_data_r(b);
    }

    public ReadHandler invaders_shift_data_rev_r(Bw8080 b) {
        return new Invaders_shift_data_rev_r(b);
    }

    public ReadHandler boothill_shift_data_r(Bw8080 b) {
        return new Boothill_shift_data_r(b);
    }

    public InterruptHandler invaders_interrupt(Bw8080 b) {
        return new Invaders_interrupt(b);
    }

    public class Invaders_interrupt
    implements InterruptHandler {
        Bw8080 b;

        public Invaders_interrupt(Bw8080 b) {
            this.b = b;
        }

        public int irq() {
            return this.b.bw_interrupt();
        }
    }

    public class Invaders_shift_amount_w
    implements WriteHandler {
        Bw8080 b;

        public Invaders_shift_amount_w(Bw8080 b) {
            this.b = b;
        }

        public void write(int port, int data) {
            shift_amount = data;
        }
    }

    public class Invaders_sh_port3_w
    implements WriteHandler {
        Bw8080 b;
        int Sound = 0;

        public Invaders_sh_port3_w(Bw8080 b) {
            this.b = b;
        }

        public void write(int port, int data) {
            try {
                if ((data & 1) != 0 && (~this.Sound & 1) != 0) {
                    samples.playSound("/0.wav");
                }
                if ((data & 2) != 0 && (~this.Sound & 2) != 0) {
                    samples.playSound("/1.wav");
                }
                if ((data & 4) != 0 && (~this.Sound & 4) != 0) {
                    samples.playSound("/2.wav");
                }
                if ((data & 8) != 0 && ~(this.Sound & 8) != 0) {
                    samples.playSound("/3.wav");
                }
                if ((data & 0x10) != 0 && ~(this.Sound & 0x10) != 0) {
                    samples.playSound("/9.wav");
                }
            }
            catch (Exception e) {
                System.setErr(System.out);
                e.printStackTrace();
            }
            this.Sound = data;
        }
    }

    public class Invaders_shift_data_w
    implements WriteHandler {
        Bw8080 b;

        public Invaders_shift_data_w(Bw8080 b) {
            this.b = b;
        }

        public void write(int port, int data) {
            shift_data2 = shift_data1;
            shift_data1 = data;
        }
    }

    public class Invaders_sh_port5_w
    implements WriteHandler {
        Bw8080 b;
        int Sound = 0;

        public Invaders_sh_port5_w(Bw8080 b) {
            this.b = b;
        }

        public void write(int port, int data) {
            try {
                if ((data & 1) != 0 && (~this.Sound & 1) != 0) {
                    samples.playSound("/4.wav");
                }
                if ((data & 2) != 0 && (~this.Sound & 2) != 0) {
                    samples.playSound("/5.wav");
                }
                if ((data & 4) != 0 && (~this.Sound & 4) != 0) {
                    samples.playSound("/6.wav");
                }
                if ((data & 8) != 0 && (~this.Sound & 8) != 0) {
                    samples.playSound("/7.wav");
                }
                if ((data & 0x10) != 0 && (~this.Sound & 0x10) != 0) {
                    samples.playSound("/8.wav");
                }
            }
            catch (Exception e) {
                System.setErr(System.out);
                e.printStackTrace();
            }
            this.Sound = data;
        }
    }

    public class Invaders_shift_data_r
    implements ReadHandler {
        Bw8080 b;

        public Invaders_shift_data_r(Bw8080 b) {
            this.b = b;
        }

        public int read(int port) {
            return Bw8080.SHIFT();
        }
    }

    public class Boothill_shift_data_r
    implements ReadHandler {
        Bw8080 b;

        public Boothill_shift_data_r(Bw8080 b) {
            this.b = b;
        }

        public int read(int port) {
            if (shift_amount < 16) {
                return Bw8080.SHIFT();
            }
            int ret = Bw8080.SHIFT();
            ret = (ret & 1) << 7 | (ret & 2) << 5 | (ret & 4) << 3 | (ret & 8) << 1 | (ret & 0x10) >> 1 | (ret & 0x20) >> 3 | (ret & 0x40) >> 5 | (ret & 0x80) >> 7;
            return ret;
        }
    }

    public class Invaders_shift_data_rev_r
    implements ReadHandler {
        Bw8080 b;

        public Invaders_shift_data_rev_r(Bw8080 b) {
            this.b = b;
        }

        public int read(int port) {
            int ret = Bw8080.SHIFT();
            ret = (ret & 1) << 7 | (ret & 2) << 5 | (ret & 4) << 3 | (ret & 8) << 1 | (ret & 0x10) >> 1 | (ret & 0x20) >> 3 | (ret & 0x40) >> 5 | (ret & 0x80) >> 7;
            return ret;
        }
    }
}

