/*
 * Decompiled with CFR 0.152.
 */
package cottage.machine;

import jef.machine.BasicMachine;
import jef.machine.Machine;
import jef.map.InterruptHandler;
import jef.map.WriteHandler;
import jef.video.BitMap;

public class Yiear
extends BasicMachine
implements Machine {
    public static boolean irqEnabled = false;
    public static boolean nmiEnabled = false;

    public InterruptHandler irq_interrupt() {
        return new IRQ_interrupt();
    }

    public InterruptHandler yiear_nmi_interrupt() {
        return new Yiear_nmi_interrupt();
    }

    public WriteHandler interrupt_enable_w() {
        return new Interrupt_enable_w();
    }

    public WriteHandler nmi_enable_w() {
        return new NMI_enable_w();
    }

    public BitMap refresh(boolean render) {
        if (render) {
            this.backBuffer = this.getDisplay();
        }
        int slice = 0;
        while (slice < 500) {
            this.currentSlice = slice++;
            this.cd[0].cpu.exec(this.cd[0].frq / 500 / 60);
        }
        this.se.update();
        this.updateInput();
        if (irqEnabled) {
            this.cb[0].interrupt(0, true);
        }
        return this.backBuffer;
    }

    public class IRQ_interrupt
    implements InterruptHandler {
        public int irq() {
            return 0;
        }
    }

    public class Interrupt_enable_w
    implements WriteHandler {
        public void write(int address, int value) {
            irqEnabled = value != 0;
        }
    }

    public class NMI_enable_w
    implements WriteHandler {
        public void write(int address, int value) {
            nmiEnabled = value != 0;
        }
    }

    public class Yiear_nmi_interrupt
    implements InterruptHandler {
        public int irq() {
            return nmiEnabled ? 1 : -1;
        }
    }
}

