/*
 * Decompiled with CFR 0.152.
 */
package cottage.mame;

import cottage.mame.Driver;
import cottage.mame.MAMEConstants;
import cottage.mame.MAMEVideo;
import java.net.URL;
import jef.cpu.Cpu;
import jef.cpu.I8080;
import jef.cpu.M6809;
import jef.cpu.Z80;
import jef.cpuboard.CpuDriver;
import jef.machine.Machine;
import jef.machine.MachineDriver;
import jef.map.IOReadPort;
import jef.map.IOWritePort;
import jef.map.InitHandler;
import jef.map.InputPort;
import jef.map.InterruptHandler;
import jef.map.MemoryReadAddress;
import jef.map.MemoryWriteAddress;
import jef.map.NoFunction;
import jef.map.ReadHandler;
import jef.map.VoidFunction;
import jef.map.WriteHandler;
import jef.sound.SoundChipEmulator;
import jef.util.RomLoader;
import jef.video.Eof_callback;
import jef.video.GfxDecodeInfo;
import jef.video.GfxLayout;
import jef.video.Vh_convert_color_proms;
import jef.video.Vh_refresh;
import jef.video.Vh_start;
import jef.video.VideoEmulator;

public abstract class MAMEDriver
implements Driver,
MAMEConstants {
    public MachineDriver md;
    public String driver_name;
    public String driver_prod;
    public String driver_date;
    public String driver_clone;
    public boolean driver_sound;
    public boolean bInfo = false;
    public URL base_URL;
    protected RomLoader romLoader = new RomLoader();
    public int[] properties = new int[16];
    private int[][] REGIONS = new int[21][];
    private int cur_region = 0;
    private InputPort[] inps = new InputPort[10];
    private int inp_count = 0;
    protected ReadHandler input_port_0_r;
    protected ReadHandler input_port_1_r;
    protected ReadHandler input_port_2_r;
    protected ReadHandler input_port_3_r;
    protected ReadHandler input_port_4_r;
    protected ReadHandler input_port_5_r;
    protected ReadHandler input_port_6_r;
    protected ReadHandler input_port_7_r;
    protected ReadHandler input_port_8_r;
    protected ReadHandler input_port_9_r;
    protected final ReadHandler soundlatch_r = new Soundlatch_r();
    protected final WriteHandler soundlatch_w = new Soundlatch_w();
    private int soundLatch = 0;
    private MemoryReadAddress[] mra = new MemoryReadAddress[8];
    private int mra_count = 0;
    private MemoryWriteAddress[] mwa = new MemoryWriteAddress[8];
    private int mwa_count = 0;
    private IOReadPort[] ior = new IOReadPort[8];
    private int ior_count = 0;
    private IOWritePort[] iow = new IOWritePort[8];
    private int iow_count = 0;
    private VideoEmulator videoEmulator;
    private GfxDecodeInfo[] gdis = new GfxDecodeInfo[8];
    private int gdi_count = 0;
    private CpuDriver[] cpus = new CpuDriver[8];
    private int cpu_count = 0;
    private SoundChipEmulator[] soundChips = new SoundChipEmulator[8];
    private int snd_count = 0;
    private String GAMEmanufacturer = "";
    private String GAMEname = "";
    private String DriverName = "";
    private int Fvideoram = -1;
    private int Fvideoram_size = -1;
    private int Fcolorram = -1;
    private int Fspriteram = -1;
    private int Fspriteram_size = -1;
    private int Fspriteram_2 = -1;
    private int Fspriteram_2_size = -1;
    private int Fspriteram_3 = -1;
    private int Fspriteram_3_size = -1;
    private int Fpaletteram = -1;
    private int Fpaletteram_2 = -1;
    protected static final VoidFunction NOP = new NoFunction();
    protected static final GfxDecodeInfo[] NO_GFX_DECODE_INFO = null;
    protected static final SoundChipEmulator[] noSound = null;
    protected boolean bModify = false;
    protected int cpu_num = -1;

    protected int RGN_FRAC(int num, int den) {
        return Integer.MIN_VALUE | (num & 0xF) << 27 | (den & 0xF) << 23;
    }

    protected void soundlatch_w(int offset, int data) {
        this.soundLatch = data;
    }

    protected int getSoundLatch() {
        return this.soundLatch;
    }

    protected void cpu_set_irq_line(int cpu, int irqType, int irqTriggerType) {
        this.cpus[cpu].cpu.interrupt(irqType, true);
    }

    protected void cpu_cause_interrupt(int cpu, int irqType) {
        this.cpus[cpu].cpu.interrupt(irqType, true);
    }

    public Machine getMachineInfo(String fname) {
        this.romLoader.noLoading();
        this.bInfo = true;
        return this.getMachine(null, fname);
    }

    public Machine getMachine(URL url, String fname) {
        this.base_URL = url;
        this.DriverName = fname;
        this.cur_region = 0;
        this.inp_count = 0;
        this.gdi_count = 0;
        this.cpu_count = 0;
        int i = 0;
        while (i < 10) {
            this.inps[i] = new InputPort();
            ++i;
        }
        this.input_port_0_r = this.inps[0];
        this.input_port_1_r = this.inps[1];
        this.input_port_2_r = this.inps[2];
        this.input_port_3_r = this.inps[3];
        this.input_port_4_r = this.inps[4];
        this.input_port_5_r = this.inps[5];
        this.input_port_6_r = this.inps[6];
        this.input_port_7_r = this.inps[7];
        this.input_port_8_r = this.inps[8];
        this.input_port_9_r = this.inps[9];
        return null;
    }

    public int getProperty(int property) {
        return this.properties[property];
    }

    public void setProperty(int property, int value) {
        this.properties[property] = value;
    }

    public String getDriverInfo() {
        return "AbstractDriver";
    }

    public String getGameInfo() {
        return "AbstractDriver supports nothing at all ;o)";
    }

    protected void cpu_setbank(int b, int address) {
        this.mra[b - 1].setBankAddress(b, address);
    }

    protected void Helpers(int name, int valname, int size, int valsize) {
        switch (name) {
            case 0: {
                this.Fvideoram = valname;
                break;
            }
            case 1: {
                this.Fcolorram = valname;
                break;
            }
            case 2: {
                this.Fspriteram = valname;
                break;
            }
            case 3: {
                this.Fspriteram_2 = valname;
                break;
            }
            case 4: {
                this.Fspriteram_3 = valname;
                break;
            }
            case 5: {
                this.Fpaletteram = valname;
                break;
            }
            case 6: {
                this.Fpaletteram_2 = valname;
            }
        }
        switch (size) {
            case 0: {
                this.Fvideoram_size = valsize;
                break;
            }
            case 1: {
                this.Fspriteram_size = valsize;
                break;
            }
            case 2: {
                this.Fspriteram_2_size = valsize;
                break;
            }
            case 3: {
                this.Fspriteram_3_size = valsize;
            }
        }
    }

    protected void install_mem_read_handler(int cpu, int from, int until, ReadHandler memRead) {
        this.mra[cpu].set(from, until, memRead);
    }

    protected void MR_START() {
        this.mra[this.mra_count++] = new MemoryReadAddress(this.REGIONS[this.cur_region - 1]);
    }

    protected void MR_ADD(int from, int until, ReadHandler memRead) {
        this.mra[this.mra_count - 1].set(from, until, memRead);
    }

    protected void MR_START(int from, int until, ReadHandler memRead) {
        this.MR_START();
        this.MR_ADD(from, until, memRead);
    }

    protected void MR_ADD(int from, int until, int type) {
        this.mra[this.mra_count - 1].setMR(from, until, type);
    }

    protected void MR_START(int from, int until, int type) {
        this.MR_START();
        this.MR_ADD(from, until, type);
    }

    protected void MW_START() {
        this.mwa[this.mwa_count++] = new MemoryWriteAddress(this.REGIONS[this.cur_region - 1]);
    }

    protected void MW_ADD(int from, int until, WriteHandler memWrite) {
        this.mwa[this.mwa_count - 1].set(from, until, memWrite);
    }

    protected void MW_START(int from, int until, WriteHandler memWrite) {
        this.MW_START();
        this.MW_ADD(from, until, memWrite);
    }

    protected void MW_ADD(int from, int until, WriteHandler memWrite, int helper, int helper_size) {
        this.mwa[this.mwa_count - 1].set(from, until, memWrite);
        this.Helpers(helper, from, helper_size, until + 1 - from);
    }

    protected void MW_START(int from, int until, WriteHandler memWrite, int helper, int helper_size) {
        this.MW_START();
        this.MW_ADD(from, until, memWrite, helper, helper_size);
    }

    protected void MW_ADD(int from, int until, WriteHandler memWrite, int helper) {
        this.mwa[this.mwa_count - 1].set(from, until, memWrite);
        this.Helpers(helper, from, -1, 0);
    }

    protected void MW_ADD(int from, int until, WriteHandler memWrite, int[] helper) {
        this.mwa[this.mwa_count - 1].set(from, until, memWrite);
        helper[0] = from;
    }

    protected void MW_ADD(int from, int until, int type, int[] helper, int[] helper_size) {
        this.mwa[this.mwa_count - 1].setMW(from, until, type);
        helper[0] = from;
        helper_size[0] = until + 1 - from;
    }

    protected void MW_ADD(int from, int until, WriteHandler memWrite, int[] helper, int[] helper_size) {
        this.mwa[this.mwa_count - 1].set(from, until, memWrite);
        helper[0] = from;
        helper_size[0] = until + 1 - from;
    }

    protected void MW_START(int from, int until, WriteHandler memWrite, int helper) {
        this.MW_START();
        this.MW_ADD(from, until, memWrite, helper);
    }

    protected void MW_ADD(int from, int until, int type) {
        this.mwa[this.mwa_count - 1].setMW(from, until, type);
    }

    protected void MW_START(int from, int until, int type) {
        this.MW_START();
        this.MW_ADD(from, until, type);
    }

    protected void MW_ADD(int from, int until, int type, int helper) {
        this.mwa[this.mwa_count - 1].setMW(from, until, type);
        this.Helpers(helper, from, -1, 0);
    }

    protected void MW_ADD(int from, int until, int type, int[] helper) {
        this.mwa[this.mwa_count - 1].setMW(from, until, type);
        helper[0] = from;
    }

    protected void MW_START(int from, int until, int type, int helper) {
        this.MW_START();
        this.MW_ADD(from, until, type, helper);
    }

    protected void MW_ADD(int from, int until, int type, int helper, int helper_size) {
        this.mwa[this.mwa_count - 1].setMW(from, until, type);
        this.Helpers(helper, from, helper_size, until + 1 - from);
    }

    protected void MW_START(int from, int until, int type, int helper, int helper_size) {
        this.MW_START();
        this.MW_ADD(from, until, type, helper, helper_size);
    }

    protected void PR_START() {
        this.ior[this.ior_count] = null;
        this.ior[this.ior_count++] = new IOReadPort();
    }

    protected void PR_ADD(int from, int until, ReadHandler memRead) {
        if (this.ior[this.ior_count - 1] != null) {
            this.ior[this.ior_count - 1].set(from, until, memRead);
        }
    }

    protected void PR_START(int from, int until, ReadHandler memRead) {
        this.PR_START();
        this.PR_ADD(from, until, memRead);
    }

    protected void PW_START() {
        this.iow[this.iow_count] = null;
        this.iow[this.iow_count++] = new IOWritePort();
    }

    protected void PW_ADD(int from, int until, WriteHandler memWrite) {
        if (this.iow[this.iow_count - 1] != null) {
            this.iow[this.iow_count - 1].set(from, until, memWrite);
        }
    }

    protected void PW_START(int from, int until, WriteHandler memWrite) {
        this.PW_START();
        this.PW_ADD(from, until, memWrite);
    }

    protected void GDI_ADD(int mem, int offset, GfxLayout gfx, int colorOffset, int numberOfColors) {
        this.gdis[this.gdi_count] = new GfxDecodeInfo(this.REGIONS[mem], offset, gfx, colorOffset, numberOfColors);
        ++this.gdi_count;
    }

    protected void GDI_ADD(int mem, int offset, int[][] gfx, int colorOffset, int numberOfColors) {
        this.gdis[this.gdi_count] = new GfxDecodeInfo(this.REGIONS[mem], offset, gfx, colorOffset, numberOfColors);
        ++this.gdi_count;
    }

    protected void GDI_ADD(int eofarray) {
    }

    protected void MDRV_CPU_ADD(Cpu cpu, int frq) {
        this.ior[this.cpu_count] = new IOReadPort();
        this.iow[this.cpu_count] = new IOWritePort();
        this.cpus[this.cpu_count] = new CpuDriver(cpu, frq, null, null, this.ior[this.cpu_count], this.iow[this.cpu_count], null, 0);
        ++this.cpu_count;
        ++this.cur_region;
    }

    protected void MDRV_VIDEO_EOF(Eof_callback eof_callback) {
        this.mdalloc();
        this.md.eof_callback = eof_callback;
    }

    protected void MDRV_CPU_ADD(int type, int frq) {
        Cpu cpu = null;
        switch (type) {
            case 0: {
                cpu = new Z80();
                break;
            }
            case 1: {
                cpu = new I8080();
                break;
            }
            case 2: {
                cpu = new M6809();
            }
        }
        this.MDRV_CPU_ADD(cpu, frq);
    }

    protected void MDRV_CPU_ADD_TAG(String tag, int type, int frq) {
        Cpu cpu = null;
        switch (type) {
            case 0: {
                cpu = new Z80();
                break;
            }
            case 1: {
                cpu = new I8080();
                break;
            }
            case 2: {
                cpu = new M6809();
            }
        }
        cpu.setTag(tag);
        this.MDRV_CPU_ADD(cpu, frq);
    }

    protected void MDRV_CPU_MODIFY(String tag) {
        this.bModify = false;
        this.cpu_num = -1;
        int i = 0;
        while (this.cpu_num == -1 && i < this.cpu_count) {
            if (this.cpus[i].cpu.getTag().compareTo(tag) != 0) continue;
            this.cpu_num = i;
        }
        if (this.cpu_num != -1) {
            this.bModify = true;
        }
    }

    protected void MDRV_CPU_FLAGS(int flags) {
        this.cpus[this.cpu_count - 1].isAudioCpu = (flags & 1) != 0;
    }

    protected void MDRV_SOUND_ADD(SoundChipEmulator soundChip) {
        this.soundChips[this.snd_count] = soundChip;
        ++this.snd_count;
    }

    protected void MDRV_CPU_MEMORY(boolean mread, boolean mwrite) {
        this.cpus[this.cpu_count - 1].mra = this.mra[this.cpu_count - 1];
        this.cpus[this.cpu_count - 1].mwa = this.mwa[this.cpu_count - 1];
    }

    protected void MDRV_CPU_PORTS(boolean ioread, boolean iowrite) {
        this.cpus[this.cpu_count - 1].ior = this.ior[this.ior_count - 1];
        this.cpus[this.cpu_count - 1].iow = this.iow[this.iow_count - 1];
    }

    protected void MDRV_CPU_PORTS(int ioread, boolean iowrite) {
        this.cpus[this.cpu_count - 1].iow = this.iow[this.iow_count - 1];
    }

    protected void MDRV_CPU_PORTS(boolean ioread, int iowrite) {
        this.cpus[this.cpu_count - 1].ior = this.ior[this.ior_count - 1];
    }

    protected void MDRV_CPU_VBLANK_INT(InterruptHandler irh, int ipf) {
        if (this.bModify) {
            this.cpus[this.cpu_num].irh = irh;
            this.cpus[this.cpu_num].ipf = ipf;
        } else {
            this.cpus[this.cpu_count - 1].irh = irh;
            this.cpus[this.cpu_count - 1].ipf = ipf;
        }
    }

    protected void setVideoEmulator(VideoEmulator ve) {
        this.videoEmulator = ve;
    }

    protected void mdalloc() {
        if (this.md == null) {
            CpuDriver[] cpuDriver = new CpuDriver[this.cpu_count];
            int i = 0;
            while (i < this.cpu_count) {
                cpuDriver[i] = this.cpus[i];
                ++i;
            }
            SoundChipEmulator[] sce = new SoundChipEmulator[this.snd_count];
            int i2 = 0;
            while (i2 < this.snd_count) {
                sce[i2] = this.soundChips[i2];
                ++i2;
            }
            if (!this.bInfo) {
                System.out.println("cpus :" + cpuDriver.length);
                System.out.println("sndchips :" + sce.length);
            }
            this.md = new MachineDriver(cpuDriver, 0, 0, 0, NOP, 0, 0, null, null, 0, 0, null, null, 0, null, null, null, null, sce);
            if (this.Fvideoram != -1) {
                MAMEVideo.videoram = this.Fvideoram;
            }
            if (this.Fcolorram != -1) {
                MAMEVideo.colorram = this.Fcolorram;
            }
            if (this.Fspriteram != -1) {
                MAMEVideo.spriteram = this.Fspriteram;
            }
            if (this.Fspriteram_2 != -1) {
                MAMEVideo.spriteram_2 = this.Fspriteram_2;
            }
            if (this.Fspriteram_3 != -1) {
                MAMEVideo.spriteram_3 = this.Fspriteram_3;
            }
            if (this.Fpaletteram != -1) {
                MAMEVideo.paletteram = this.Fpaletteram;
            }
            if (this.Fpaletteram_2 != -1) {
                MAMEVideo.paletteram_2 = this.Fpaletteram_2;
            }
            if (this.Fvideoram_size != -1) {
                MAMEVideo.videoram_size = this.Fvideoram_size;
            }
            if (this.Fspriteram_size != -1) {
                MAMEVideo.spriteram_size = this.Fspriteram_size;
            }
            if (this.Fspriteram_2_size != -1) {
                MAMEVideo.spriteram_2_size = this.Fspriteram_2_size;
            }
            if (this.Fspriteram_3_size != -1) {
                MAMEVideo.spriteram_3_size = this.Fspriteram_3_size;
            }
            this.md.REGIONS = this.REGIONS;
        }
    }

    protected void MDRV_IMPORT_FROM(boolean imp) {
    }

    protected void MDRV_INTERLEAVE(int spf) {
        this.mdalloc();
        this.md.spf = spf;
    }

    protected void MDRV_FRAMES_PER_SECOND(int fps) {
        this.mdalloc();
        this.md.fps = fps;
    }

    protected void MDRV_FRAMES_PER_SECOND(double fps) {
        this.mdalloc();
        this.md.fps = (int)fps;
    }

    protected void MDRV_VBLANK_DURATION(int vbd) {
        this.mdalloc();
        this.md.vbd = vbd;
    }

    protected void MDRV_VIDEO_ATTRIBUTES(int videoFlags) {
        this.mdalloc();
        this.md.videoFlags = videoFlags;
    }

    protected void MDRV_SCREEN_SIZE(int w, int h) {
        this.mdalloc();
        this.md.w = w;
        this.md.h = h;
    }

    protected void MDRV_VISIBLE_AREA(int x1, int y1, int x2, int y2) {
        this.mdalloc();
        int[] visible = new int[]{x1, y1, x2, y2};
        this.md.visible = visible;
    }

    protected void MDRV_GFXDECODE(boolean gfxdec) {
        this.mdalloc();
        GfxDecodeInfo[] gfx = new GfxDecodeInfo[this.gdi_count];
        int i = 0;
        while (i < this.gdi_count) {
            gfx[i] = this.gdis[i];
            ++i;
        }
        this.md.gfx = gfx;
    }

    protected void MDRV_PALETTE_LENGTH(int pal) {
        this.mdalloc();
        this.md.pal = pal;
        this.md.col = pal;
    }

    protected void MDRV_COLORTABLE_LENGTH(int col) {
        this.mdalloc();
        this.md.col = col;
    }

    protected void MDRV_PALETTE_INIT(Vh_convert_color_proms initProms) {
        this.mdalloc();
        this.md.initProms = initProms;
    }

    protected void MDRV_VIDEO_START(Vh_start vh_start) {
        this.mdalloc();
        this.md.vh_start = vh_start;
    }

    protected void MDRV_VIDEO_UPDATE(Vh_refresh vh_screenrefresh) {
        this.mdalloc();
        this.md.vh_screenrefresh = vh_screenrefresh;
    }

    protected String DEF_STR2(int number) {
        return MAMEConstants.DEF_STR[number];
    }

    protected void PORT_START() {
        ++this.inp_count;
    }

    protected void PORT_ANALOG(int bitMask, int center, int type, int a, int b, int c, int d) {
        this.inps[this.inp_count - 1].setAnalog(bitMask, center, type, a, b, c, d);
    }

    protected void PORT_BIT(int bitMask, int activityType, int inputType) {
        this.inps[this.inp_count - 1].setBit(bitMask, activityType, inputType);
    }

    protected void PORT_BITX(int bitMask, int defSetting, int c, String name, int d, int e) {
        this.inps[this.inp_count - 1].setDipName(bitMask, defSetting, name);
    }

    protected void PORT_BIT_IMPULSE(int bitMask, int activityType, int inputType, int frames) {
        this.inps[this.inp_count - 1].setBitImpulse(bitMask, activityType, inputType, frames);
    }

    protected void PORT_DIPNAME(int bitMask, int defSetting, String name) {
        this.inps[this.inp_count - 1].setDipName(bitMask, defSetting, name);
    }

    protected void PORT_DIPSETTING(int setting, String name) {
        this.inps[this.inp_count - 1].setDipSetting(setting, name);
    }

    protected void PORT_SERVICE(int bitMask, int activityType) {
        this.inps[this.inp_count - 1].setService(bitMask, activityType);
    }

    protected void ROM_LOAD(String name, int offset, int length, int crc) {
        this.romLoader.loadROM(name, offset, length, crc);
    }

    protected void ROM_LOAD16_BYTE(String name, int offset, int length, int crc) {
        this.romLoader.loadROM(name, offset, length, crc, 1);
    }

    protected void ROM_CONTINUE(int offset, int length) {
        this.romLoader.continueROM(offset, length);
    }

    protected void ROM_REGION(int size, int mem, int options) {
        if (this.REGIONS[mem] == null) {
            this.REGIONS[mem] = new int[size];
        }
        this.romLoader.setMemory(this.REGIONS[mem]);
        this.romLoader.setInvert((options & 2) != 0);
    }

    public int[] memory_region(int region) {
        return this.REGIONS[region];
    }

    public int memory_region_length(int region) {
        return this.REGIONS[region].length;
    }

    protected int BADCRC(int crc) {
        return crc;
    }

    protected void GAME(int year, boolean roms, InputPort[] inp, boolean ini, int rot, String man, String nam) {
        if (!this.bInfo) {
            System.out.println("Starting...");
            System.out.println(nam);
            System.out.println(String.valueOf(Integer.toString(year)) + " - " + man);
            this.md.ROT = rot;
            this.md.input = inp;
            this.md.ve = this.videoEmulator;
        } else {
            this.md.info = this.bInfo = true;
            this.driver_date = Integer.toString(year);
            this.driver_prod = man;
            this.driver_name = nam;
            this.driver_clone = null;
            this.driver_sound = this.md.soundChips != noSound;
            this.md.ROT = rot;
        }
    }

    protected void GAME(int year, boolean roms, String parent, InputPort[] inp, boolean ini, int rot, String man, String nam) {
        if (!this.bInfo) {
            System.out.println("Starting...");
            System.out.println(nam);
            System.out.println(String.valueOf(Integer.toString(year)) + " - " + man);
            this.md.ROT = rot;
            this.md.input = inp;
            this.md.ve = this.videoEmulator;
        } else {
            this.md.info = this.bInfo = true;
            this.driver_date = Integer.toString(year);
            this.driver_prod = man;
            this.driver_name = nam;
            this.driver_clone = parent;
            this.driver_sound = this.md.soundChips != noSound;
            this.md.ROT = rot;
        }
    }

    protected void GAME(int year, boolean roms, int parent, boolean mdrv, boolean inp, boolean ini, int rot, String man, String nam) {
        this.GAME(Integer.toString(year), roms, null, mdrv, inp, ini, rot, man, nam);
    }

    protected void GAME(int year, boolean roms, int parent, boolean mdrv, boolean inp, int ini, int rot, String man, String nam) {
        this.GAME(Integer.toString(year), roms, null, mdrv, inp, true, rot, man, nam);
    }

    protected void GAME(int year, boolean roms, int parent, boolean mdrv, boolean inp, InitHandler ini, int rot, String man, String nam) {
        this.GAME(Integer.toString(year), roms, null, mdrv, inp, ini, rot, man, nam);
    }

    protected void GAME(String year, boolean roms, int parent, boolean mdrv, boolean inp, boolean ini, int rot, String man, String nam) {
        this.GAME(year, roms, null, mdrv, inp, ini, rot, man, nam);
    }

    protected void GAME(String year, boolean roms, int parent, boolean mdrv, boolean inp, int ini, int rot, String man, String nam) {
        this.GAME(year, roms, null, mdrv, inp, true, rot, man, nam);
    }

    protected void GAME(int year, boolean roms, String parent, boolean mdrv, boolean inp, boolean ini, int rot, String man, String nam) {
        this.GAME(Integer.toString(year), roms, parent, mdrv, inp, ini, rot, man, nam);
    }

    protected void GAME(int year, boolean roms, String parent, boolean mdrv, boolean inp, int ini, int rot, String man, String nam) {
        this.GAME(Integer.toString(year), roms, parent, mdrv, inp, true, rot, man, nam);
    }

    protected void GAME(int year, boolean roms, String parent, boolean mdrv, boolean inp, InitHandler ini, int rot, String man, String nam) {
        this.GAME(Integer.toString(year), roms, parent, mdrv, inp, ini, rot, man, nam);
    }

    protected void GAME(String year, boolean roms, String parent, boolean mdrv, boolean inp, int ini, int rot, String man, String nam) {
        this.GAME(year, roms, parent, mdrv, inp, true, rot, man, nam);
    }

    protected void GAME(String year, boolean roms, String parent, boolean mdrv, boolean inp, InitHandler ini, int rot, String man, String nam) {
        this.GAME(year, roms, parent, mdrv, inp, true, rot, man, nam);
        ini.init();
    }

    protected void GAME(String year, boolean roms, String parent, boolean mdrv, boolean inp, boolean ini, int rot, String man, String nam) {
        if (!this.bInfo) {
            this.romLoader.setZip(this.DriverName);
            this.romLoader.setParentZip(parent);
            this.romLoader.loadZip(this.base_URL);
            System.out.println("Starting...");
            System.out.println(nam);
            System.out.println(String.valueOf(year) + " - " + man);
            this.md.ROT = rot;
            InputPort[] in = new InputPort[this.inp_count];
            int i = 0;
            while (i < this.inp_count) {
                in[i] = this.inps[i];
                ++i;
            }
            i = this.inp_count;
            while (i < 10) {
                this.inps[i] = null;
                ++i;
            }
            this.md.input = in;
            this.md.ve = this.videoEmulator;
        } else {
            this.md.info = this.bInfo = true;
            this.driver_date = year;
            this.driver_prod = man;
            this.driver_name = nam;
            this.driver_clone = parent;
            this.driver_sound = this.snd_count > 0;
            this.md.ROT = rot;
        }
    }

    protected class Soundlatch_r
    implements ReadHandler {
        protected Soundlatch_r() {
        }

        public int read(int offset) {
            return MAMEDriver.this.soundLatch;
        }
    }

    private class Soundlatch_w
    implements WriteHandler {
        Soundlatch_w() {
        }

        public void write(int address, int data) {
            MAMEDriver.this.soundLatch = data;
        }
    }
}

