/*
 * Decompiled with CFR 0.152.
 */
package jef.cpu;

import jef.cpu.Cpu;
import jef.cpu.M6809Const;
import jef.cpuboard.CpuBoard;

public class M6809
implements M6809Const,
Cpu {
    int traceinstructions = 0;
    public boolean flagE;
    public boolean flagF;
    public boolean flagH;
    public boolean flagI;
    public boolean flagN;
    public boolean flagZ;
    public boolean flagV;
    public boolean flagC;
    public int a = 0;
    public int b = 0;
    public int dp = 0;
    public int s = 0;
    public int u = 0;
    public int x = 0;
    public int y = 0;
    public int pc = 0;
    public int ir = 0;
    public int ea = 0;
    public int waitState = 0;
    public int lastPc;
    public int opPc;
    public int breakpoint = 65535;
    private int curInstr = 0;
    public int page;
    public int addrMode;
    private boolean useEa = false;
    private int tCycle;
    private CpuBoard cb;
    public int interruptState;
    private String tag;

    public final void reset() {
        this.ea = 0;
        this.ir = 0;
        this.dp = 0;
        this.flagI = true;
        this.flagF = true;
        this.pc = this.readByte(65534) << 8 | this.readByte(65535);
        this.page = 1;
        this.useEa = false;
        this.addrMode = 4;
        this.interruptState = 0;
        this.tCycle = 0;
    }

    public final boolean init(CpuBoard cb, int debug) {
        this.cb = cb;
        return true;
    }

    public final void interrupt(int type, boolean irq) {
        switch (type) {
            case 0: {
                this.irq();
                break;
            }
            case 1: {
                this.nmi();
                break;
            }
            case 2: {
                this.firq();
            }
        }
    }

    public final long getInstruction() {
        if (this.page == 2) {
            this.curInstr |= 0x1000;
        } else if (this.page == 3) {
            this.curInstr |= 0x1100;
        }
        return this.curInstr;
    }

    public final void setProperty(int p, int v) {
    }

    public final void setDebug(int d) {
    }

    public final int getDebug() {
        return 0;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void irq() {
        this.interruptState |= 2;
        if (this.waitState == 8 && !this.flagI) {
            this.waitState = 0;
        }
        if (this.waitState == 16) {
            this.waitState = 0;
        }
    }

    public void nmi() {
        this.interruptState |= 1;
        if (this.waitState == 8) {
            this.waitState = 0;
        }
        if (this.waitState == 16) {
            this.waitState = 0;
        }
    }

    public void firq() {
        this.interruptState |= 4;
        if (this.waitState == 8 && !this.flagF) {
            this.waitState = 0;
        }
        if (this.waitState == 16) {
            this.waitState = 0;
        }
    }

    public void exec(int cycles) {
        this.tCycle = cycles;
        if ((this.interruptState & 1) != 0) {
            this.runNmi();
        }
        if ((this.interruptState & 2) != 0 && !this.flagI) {
            this.runIrq();
        }
        if ((this.interruptState & 4) != 0 && !this.flagF) {
            this.runFirq();
        }
        this.interruptState = 0;
        while (this.tCycle > 0 && this.pc <= this.breakpoint) {
            this.execInstr();
        }
    }

    public void execInstr() {
        this.lastPc = this.pc;
        this.ir = this.cb.read8opc(this.pc++);
        this.tCycle -= this.decode();
        this.execSingleInstr(this.ir & 0xFF);
    }

    public final int readByte(int _ea) {
        return this.cb.read8(_ea & 0xFFFF);
    }

    public final int read2Bytes(int _ea) {
        int temp = this.cb.read8(_ea & 0xFFFF) << 8;
        return temp |= this.cb.read8((_ea & 0xFFFF) + 1);
    }

    public final void writeByte(int _ea, int _b) {
        this.cb.write8(_ea & 0xFFFF, _b & 0xFF);
    }

    public final void write2Bytes(int _ea, int _b) {
        this.cb.write8(_ea & 0xFFFF, _b >>> 8 & 0xFF);
        this.cb.write8((_ea & 0xFFFF) + 1, _b & 0xFF);
    }

    private final int fetch() {
        return this.cb.read8(this.pc++);
    }

    private final int fetch2() {
        int temp = this.cb.read8(this.pc++) << 8;
        return temp |= this.cb.read8(this.pc++);
    }

    private int to2C5Bit(int _unsigned) {
        if (_unsigned > 15) {
            return _unsigned | 0xFFFFFFE0;
        }
        return _unsigned;
    }

    private int to2C8Bit(int _unsigned) {
        if (_unsigned > 127) {
            return _unsigned | 0xFFFFFF00;
        }
        return _unsigned;
    }

    private int to2C16Bit(int _unsigned) {
        if (_unsigned > Short.MAX_VALUE) {
            return _unsigned | 0xFFFF0000;
        }
        return _unsigned;
    }

    public void runIrq() {
        this.flagE = true;
        if ((this.interruptState & 8) == 0) {
            this.pull_push8BitBase(false, true, 255);
        } else {
            this.interruptState &= 0xFFFFFFF7;
        }
        this.flagF = true;
        this.flagI = true;
        this.pc = this.readByte(65528) << 8 | this.readByte(65529);
    }

    public void runFirq() {
        if (this.waitState == 0) {
            this.flagE = false;
        } else {
            this.pull_push8BitBase(false, true, 129);
        }
        this.flagF = true;
        this.flagI = true;
        this.pc = this.readByte(65526) << 8 | this.readByte(65527);
    }

    public void runNmi() {
        this.waitState = 0;
        this.flagE = true;
        if (this.waitState != 8) {
            this.pull_push8BitBase(false, true, 255);
        }
        this.flagF = true;
        this.flagI = true;
        this.pc = this.readByte(65532) << 8 | this.readByte(65533);
    }

    private final void setCC(int _val) {
        this.flagC = (_val & M6809Const.C_MASK) != 0;
        this.flagV = (_val & M6809Const.V_MASK) != 0;
        this.flagZ = (_val & M6809Const.Z_MASK) != 0;
        this.flagN = (_val & M6809Const.N_MASK) != 0;
        this.flagI = (_val & M6809Const.I_MASK) != 0;
        this.flagH = (_val & M6809Const.H_MASK) != 0;
        this.flagF = (_val & M6809Const.F_MASK) != 0;
        this.flagE = (_val & M6809Const.E_MASK) != 0;
    }

    final int cc() {
        int cc = 0;
        if (this.flagC) {
            cc |= M6809Const.C_MASK;
        }
        if (this.flagV) {
            cc |= M6809Const.V_MASK;
        }
        if (this.flagZ) {
            cc |= M6809Const.Z_MASK;
        }
        if (this.flagN) {
            cc |= M6809Const.N_MASK;
        }
        if (this.flagI) {
            cc |= M6809Const.I_MASK;
        }
        if (this.flagH) {
            cc |= M6809Const.H_MASK;
        }
        if (this.flagF) {
            cc |= M6809Const.F_MASK;
        }
        if (this.flagE) {
            cc |= M6809Const.E_MASK;
        }
        return cc;
    }

    private final int d() {
        return this.a << 8 | this.b;
    }

    private final void setD(int _r) {
        this.a = _r >>> 8;
        this.b = _r & 0xFF;
    }

    public int decode() {
        if (this.ir == 16) {
            this.page = 2;
            this.ir = this.cb.read8opc(this.pc++);
        } else if (this.ir == 17) {
            this.page = 3;
            this.ir = this.cb.read8opc(this.pc++);
        } else {
            this.page = 1;
        }
        int instrCycle = M6809Const.baseCycles[this.page - 1][this.ir & 0xFF];
        this.addrMode = M6809Const.addrModeArray[this.ir & 0xFF];
        this.opPc = this.pc;
        if (this.addrMode == 4 || this.addrMode == 5 || this.addrMode == 0) {
            this.useEa = false;
        } else {
            instrCycle += this.calcEA();
        }
        return instrCycle;
    }

    private final int calcEA() {
        this.useEa = true;
        boolean isIndirect = false;
        int extraCycle = 0;
        switch (this.addrMode) {
            case 3: {
                this.ea = this.fetch2();
                break;
            }
            case 1: {
                this.ea = this.dp << 8 | this.fetch();
                break;
            }
            case 2: {
                int postbyte = this.fetch();
                int rr = (postbyte & 0x60) >>> 5;
                int reg = rr == 0 ? this.x : (rr == 1 ? this.y : (rr == 2 ? this.u : this.s));
                if (this.getBit(postbyte, 7) == 0) {
                    this.ea = reg + this.to2C5Bit(postbyte & 0x1F);
                    break;
                }
                int lsn = postbyte & 0xF;
                isIndirect = (postbyte & 0x10) != 0;
                switch (lsn) {
                    case 0: {
                        this.ea = reg++;
                        this.tCycle -= 2;
                        break;
                    }
                    case 1: {
                        this.ea = reg;
                        reg += 2;
                        this.tCycle -= 3;
                        break;
                    }
                    case 2: {
                        this.ea = --reg;
                        this.tCycle -= 2;
                        break;
                    }
                    case 3: {
                        this.ea = reg -= 2;
                        this.tCycle -= 3;
                        break;
                    }
                    case 4: {
                        this.ea = reg;
                        break;
                    }
                    case 5: {
                        this.ea = reg + this.to2C8Bit(this.b);
                        --this.tCycle;
                        break;
                    }
                    case 6: {
                        this.ea = reg + this.to2C8Bit(this.a);
                        --this.tCycle;
                        break;
                    }
                    case 8: {
                        this.ea = reg + this.to2C8Bit(this.fetch());
                        --this.tCycle;
                        break;
                    }
                    case 9: {
                        this.ea = reg + this.to2C16Bit(this.fetch2());
                        this.tCycle -= 4;
                        break;
                    }
                    case 11: {
                        this.ea = reg + this.to2C16Bit(this.d());
                        this.tCycle -= 4;
                        break;
                    }
                    case 12: {
                        this.ea = this.to2C8Bit(this.fetch()) + this.pc;
                        --this.tCycle;
                        break;
                    }
                    case 13: {
                        this.ea = this.to2C16Bit(this.fetch2()) + this.pc;
                        this.tCycle -= 5;
                        break;
                    }
                    case 15: {
                        this.ea = this.fetch2();
                        this.tCycle -= 5;
                    }
                }
                if (lsn <= 3) {
                    if (rr == 0) {
                        this.x = reg;
                    } else if (rr == 1) {
                        this.y = reg;
                    } else if (rr == 2) {
                        this.u = reg;
                    } else {
                        this.s = reg;
                    }
                }
                if (!isIndirect) break;
                this.ea = this.read2Bytes(this.ea);
                this.tCycle -= 3;
            }
        }
        return extraCycle;
    }

    private boolean isNeg8Bit(int _r) {
        return (_r & 0x80) != 0;
    }

    private boolean isNeg16Bit(int _r) {
        return (_r & 0x8000) != 0;
    }

    private int getBit(int _r, int _bit) {
        if ((_r & M6809Const.BIT_MASK[_bit]) == 0) {
            return 0;
        }
        return 1;
    }

    public int adc8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        int cVal = this.flagC ? 1 : 0;
        int t = (_r & 0xF) + (operand & 0xF) + cVal;
        this.flagH = (t & 0x10) != 0;
        t = (_r & 0x7F) + (operand & 0x7F) + cVal;
        this.flagV = (t & 0x80) != 0;
        t = (_r & 0xFF) + (operand & 0xFF) + cVal;
        this.flagC = (t & 0x100) != 0;
        _r = t & 0xFF;
        this.flagV ^= this.flagC;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int add8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        int t = (_r & 0xF) + (operand & 0xF);
        this.flagH = (t & 0x10) != 0;
        t = (_r & 0x7F) + (operand & 0x7F);
        this.flagV = (t & 0x80) != 0;
        t = (_r & 0xFF) + (operand & 0xFF);
        this.flagC = (t & 0x100) != 0;
        _r = t & 0xFF;
        this.flagV ^= this.flagC;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int and8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        this.flagV = false;
        this.flagN = this.isNeg8Bit(_r &= operand);
        this.flagZ = _r == 0;
        return _r;
    }

    public int asl8BitBase(int _r) {
        this.flagC = this.getBit(_r, 7) != 0;
        this.flagV = this.getBit(_r, 7) != this.getBit(_r, 6);
        _r = _r << 1 & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int asr8BitBase(int _r) {
        boolean bl = this.flagC = this.getBit(_r, 0) != 0;
        if (this.getBit(_r >>= 1, 6) != 0) {
            _r |= 0x80;
        }
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public void branchBase() {
        if (this.page == 1) {
            int offset = this.to2C8Bit(this.fetch());
            this.pc += offset;
        } else {
            int offset = this.to2C16Bit(this.fetch2());
            this.pc += offset;
            --this.tCycle;
        }
    }

    public int clr8BitBase() {
        this.flagN = false;
        this.flagZ = true;
        this.flagV = false;
        this.flagC = false;
        return 0;
    }

    public void cmp8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        int t = _r - operand;
        this.flagV = ((_r ^ operand ^ t ^ t >> 1) & 0x80) != 0;
        this.flagC = (t & 0x100) != 0;
        _r = t & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
    }

    public void cmp16BitBase(int _r) {
        int operand2 = !this.useEa ? this.fetch2() : this.read2Bytes(this.ea);
        int t = _r - operand2;
        this.flagV = ((_r ^ operand2 ^ t ^ t >> 1) & 0x8000) != 0;
        this.flagC = (t & 0x10000) != 0;
        _r = t & 0xFFFF;
        this.flagN = this.isNeg16Bit(_r);
        this.flagZ = _r == 0;
    }

    public int com8BitBase(int _r) {
        this.flagV = false;
        this.flagC = true;
        _r = ~_r & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int dec8BitBase(int _r) {
        this.flagV = _r == 128;
        _r = _r - 1 & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int eor8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        _r = (_r ^ operand) & 0xFF;
        this.flagV = false;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public void exg_tfr8BitBase(boolean _isExg, int _r) {
        int b1 = (_r & 0x70) >>> 4;
        int b2 = _r & 7;
        int r1 = 0;
        int r2 = 0;
        r1 = b1 == 0 ? this.a : (b1 == 1 ? this.b : (b1 == 2 ? this.cc() : this.dp));
        r2 = b2 == 0 ? this.a : (b2 == 1 ? this.b : (b2 == 2 ? this.cc() : this.dp));
        if (_isExg) {
            int temp = r1;
            r1 = r2;
            r2 = temp;
            if (b1 == 0) {
                this.a = r1;
            } else if (b1 == 1) {
                this.b = r1;
            } else if (b1 == 2) {
                this.setCC(r1);
            } else {
                this.dp = r1;
            }
        } else {
            r2 = r1;
        }
        if (b2 == 0) {
            this.a = r2;
        } else if (b2 == 1) {
            this.b = r2;
        } else if (b2 == 2) {
            this.setCC(r2);
        } else {
            this.dp = r2;
        }
    }

    public void exg_tfr16BitBase(boolean _isExg, int _r) {
        int b1 = (_r & 0x70) >>> 4;
        int b2 = _r & 7;
        int r1 = b1 == 0 ? this.d() : (b1 == 1 ? this.x : (b1 == 2 ? this.y : (b1 == 3 ? this.u : (b1 == 4 ? this.s : this.pc))));
        int r2 = b2 == 0 ? this.d() : (b2 == 1 ? this.x : (b2 == 2 ? this.y : (b2 == 3 ? this.u : (b2 == 4 ? this.s : this.pc))));
        if (_isExg) {
            int temp = r1;
            r1 = r2;
            r2 = temp;
        } else {
            r2 = r1;
        }
        if (b1 == 0) {
            this.setD(r1);
        } else if (b1 == 1) {
            this.x = r1;
        } else if (b1 == 2) {
            this.y = r1;
        } else if (b1 == 3) {
            this.u = r1;
        } else if (b1 == 4) {
            this.s = r1;
        } else {
            this.pc = r1;
        }
        if (b2 == 0) {
            this.setD(r2);
        } else if (b2 == 1) {
            this.x = r2;
        } else if (b2 == 2) {
            this.y = r2;
        } else if (b2 == 3) {
            this.u = r2;
        } else if (b2 == 4) {
            this.s = r2;
        } else {
            this.pc = r2;
        }
    }

    public int inc8BitBase(int _r) {
        this.flagV = _r == 127;
        _r = _r + 1 & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int ld8BitBase() {
        this.flagV = false;
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        this.flagN = this.isNeg8Bit(operand);
        this.flagZ = operand == 0;
        return operand;
    }

    public int ld16BitBase() {
        this.flagV = false;
        int operand2 = !this.useEa ? this.fetch2() : this.read2Bytes(this.ea);
        this.flagN = this.isNeg16Bit(operand2);
        this.flagZ = operand2 == 0;
        return operand2;
    }

    public int lea16BitBase(int _r) {
        return this.ea & 0xFFFF;
    }

    public int lsr8BitBase(int _r) {
        this.flagC = this.getBit(_r, 0) != 0;
        this.flagN = false;
        this.flagZ = (_r >>>= 1) == 0;
        return _r;
    }

    public int neg8BitBase(int _r) {
        this.flagV = _r == 128;
        this.flagC = _r != 0;
        _r = -_r & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int or8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        this.flagV = false;
        this.flagN = this.isNeg8Bit(_r |= operand);
        this.flagZ = _r == 0;
        return _r;
    }

    public void pull_push8BitBase(boolean _isPull, boolean _isS, int _b) {
        int stack;
        int stack2;
        int postByte = _b;
        if (_isS) {
            stack2 = this.u;
            stack = this.s;
        } else {
            stack2 = this.s;
            stack = this.u;
        }
        if (_isPull) {
            if (this.getBit(postByte, 0) != 0) {
                this.setCC(this.readByte(stack++));
                --this.tCycle;
            }
            if (this.getBit(postByte, 1) != 0) {
                this.a = this.readByte(stack++);
                --this.tCycle;
            }
            if (this.getBit(postByte, 2) != 0) {
                this.b = this.readByte(stack++);
                --this.tCycle;
            }
            if (this.getBit(postByte, 3) != 0) {
                this.dp = this.readByte(stack++);
                --this.tCycle;
            }
            if (this.getBit(postByte, 4) != 0) {
                this.x = this.readByte(stack & 0xFFFF) << 8;
                this.x |= this.readByte((stack & 0xFFFF) + 1);
                stack += 2;
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 5) != 0) {
                this.y = this.read2Bytes(stack);
                stack += 2;
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 6) != 0) {
                stack2 = this.read2Bytes(stack);
                stack += 2;
                if (_isS) {
                    this.u = stack2;
                } else {
                    this.s = stack2;
                }
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 7) != 0) {
                this.pc = this.read2Bytes(stack);
                stack += 2;
                this.tCycle -= 2;
            }
        } else {
            if (this.getBit(postByte, 7) != 0) {
                this.write2Bytes(stack -= 2, this.pc);
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 6) != 0) {
                this.write2Bytes(stack -= 2, stack2);
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 5) != 0) {
                this.write2Bytes(stack -= 2, this.y);
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 4) != 0) {
                this.write2Bytes(stack -= 2, this.x);
                this.tCycle -= 2;
            }
            if (this.getBit(postByte, 3) != 0) {
                this.writeByte(--stack, this.dp);
                --this.tCycle;
            }
            if (this.getBit(postByte, 2) != 0) {
                this.writeByte(--stack, this.b);
                --this.tCycle;
            }
            if (this.getBit(postByte, 1) != 0) {
                this.writeByte(--stack, this.a);
                --this.tCycle;
            }
            if (this.getBit(postByte, 0) != 0) {
                this.writeByte(--stack, this.cc());
                --this.tCycle;
            }
        }
        if (_isS) {
            this.s = stack & 0xFFFF;
        } else {
            this.u = stack & 0xFFFF;
        }
    }

    public int rol8BitBase(int _r) {
        this.flagV = this.getBit(_r, 6) != this.getBit(_r, 7);
        boolean lastC = this.flagC;
        this.flagC = this.getBit(_r, 7) != 0;
        _r = _r << 1 & 0xFF;
        _r = lastC ? (_r |= 1) : (_r &= 0xFE);
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int ror8BitBase(int _r) {
        boolean lastC = this.flagC;
        this.flagC = this.getBit(_r, 0) != 0;
        _r = _r >>> 1 & 0xFF;
        _r = lastC ? (_r |= 0x80) : (_r &= 0x7F);
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int sub8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        int t = _r - operand;
        this.flagV = ((_r ^ operand ^ t ^ t >> 1) & 0x80) != 0;
        this.flagC = (t & 0x100) != 0;
        _r = t & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public int sbc8BitBase(int _r) {
        int operand = !this.useEa ? this.fetch() : this.readByte(this.ea);
        int t = this.flagC ? _r - operand - 1 : _r - operand;
        this.flagV = ((_r ^ operand ^ t ^ t >> 1) & 0x80) != 0;
        this.flagC = (t & 0x100) != 0;
        _r = t & 0xFF;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
        return _r;
    }

    public void st8BitBase(int _r) {
        if (this.useEa) {
            this.writeByte(this.ea, _r);
        } else {
            this.writeByte(this.pc++, _r);
        }
        this.flagV = false;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
    }

    public void st16BitBase(int _r) {
        if (this.useEa) {
            this.write2Bytes(this.ea, _r);
        } else {
            this.write2Bytes(this.pc, _r);
            this.pc += 2;
        }
        this.flagV = false;
        this.flagN = this.isNeg16Bit(_r);
        this.flagZ = _r == 0;
    }

    public void tst8BitBase(int _r) {
        this.flagV = false;
        this.flagN = this.isNeg8Bit(_r);
        this.flagZ = _r == 0;
    }

    private void execSingleInstr(int _opcode) {
        switch (_opcode) {
            case 0: {
                this.neg();
                break;
            }
            case 3: {
                this.com();
                break;
            }
            case 4: {
                this.lsr();
                break;
            }
            case 6: {
                this.ror();
                break;
            }
            case 7: {
                this.asr();
                break;
            }
            case 8: {
                this.asl();
                break;
            }
            case 9: {
                this.rol();
                break;
            }
            case 10: {
                this.dec();
                break;
            }
            case 12: {
                this.inc();
                break;
            }
            case 13: {
                this.tst();
                break;
            }
            case 14: {
                this.jmp();
                break;
            }
            case 15: {
                this.clr();
                break;
            }
            case 18: {
                this.nop();
                break;
            }
            case 19: {
                this.sync();
                break;
            }
            case 22: {
                this.lbra();
                break;
            }
            case 23: {
                this.lbsr();
                break;
            }
            case 25: {
                this.daa();
                break;
            }
            case 26: {
                this.orcc();
                break;
            }
            case 28: {
                this.andcc();
                break;
            }
            case 29: {
                this.sex();
                break;
            }
            case 30: {
                this.exg();
                break;
            }
            case 31: {
                this.tfr();
                break;
            }
            case 32: {
                this.bra();
                break;
            }
            case 33: {
                this.xbrn();
                break;
            }
            case 34: {
                this.xbhi();
                break;
            }
            case 35: {
                this.xbls();
                break;
            }
            case 36: {
                this.xbcc();
                break;
            }
            case 37: {
                this.xbcs();
                break;
            }
            case 38: {
                this.xbne();
                break;
            }
            case 39: {
                this.xbeq();
                break;
            }
            case 40: {
                this.xbvc();
                break;
            }
            case 41: {
                this.xbvs();
                break;
            }
            case 42: {
                this.xbpl();
                break;
            }
            case 43: {
                this.xbmi();
                break;
            }
            case 44: {
                this.xbge();
                break;
            }
            case 45: {
                this.xblt();
                break;
            }
            case 46: {
                this.xbgt();
                break;
            }
            case 47: {
                this.xble();
                break;
            }
            case 48: {
                this.leax();
                break;
            }
            case 49: {
                this.leay();
                break;
            }
            case 50: {
                this.leas();
                break;
            }
            case 51: {
                this.leau();
                break;
            }
            case 52: {
                this.pshs();
                break;
            }
            case 53: {
                this.puls();
                break;
            }
            case 54: {
                this.pshu();
                break;
            }
            case 55: {
                this.pulu();
                break;
            }
            case 57: {
                this.rts();
                break;
            }
            case 58: {
                this.abx();
                break;
            }
            case 59: {
                this.rti();
                break;
            }
            case 60: {
                this.cwai();
                break;
            }
            case 61: {
                this.mul();
                break;
            }
            case 63: {
                this.swi();
                break;
            }
            case 64: {
                this.nega();
                break;
            }
            case 67: {
                this.coma();
                break;
            }
            case 68: {
                this.lsra();
                break;
            }
            case 70: {
                this.rora();
                break;
            }
            case 71: {
                this.asra();
                break;
            }
            case 72: {
                this.asla();
                break;
            }
            case 73: {
                this.rola();
                break;
            }
            case 74: {
                this.deca();
                break;
            }
            case 76: {
                this.inca();
                break;
            }
            case 77: {
                this.tsta();
                break;
            }
            case 79: {
                this.clra();
                break;
            }
            case 80: {
                this.negb();
                break;
            }
            case 83: {
                this.comb();
                break;
            }
            case 84: {
                this.lsrb();
                break;
            }
            case 86: {
                this.rorb();
                break;
            }
            case 87: {
                this.asrb();
                break;
            }
            case 88: {
                this.aslb();
                break;
            }
            case 89: {
                this.rolb();
                break;
            }
            case 90: {
                this.decb();
                break;
            }
            case 92: {
                this.incb();
                break;
            }
            case 93: {
                this.tstb();
                break;
            }
            case 95: {
                this.clrb();
                break;
            }
            case 96: {
                this.neg();
                break;
            }
            case 99: {
                this.com();
                break;
            }
            case 100: {
                this.lsr();
                break;
            }
            case 102: {
                this.ror();
                break;
            }
            case 103: {
                this.asr();
                break;
            }
            case 104: {
                this.asl();
                break;
            }
            case 105: {
                this.rol();
                break;
            }
            case 106: {
                this.dec();
                break;
            }
            case 108: {
                this.inc();
                break;
            }
            case 109: {
                this.tst();
                break;
            }
            case 110: {
                this.jmp();
                break;
            }
            case 111: {
                this.clr();
                break;
            }
            case 112: {
                this.neg();
                break;
            }
            case 115: {
                this.com();
                break;
            }
            case 116: {
                this.lsr();
                break;
            }
            case 118: {
                this.ror();
                break;
            }
            case 119: {
                this.asr();
                break;
            }
            case 120: {
                this.asl();
                break;
            }
            case 121: {
                this.rol();
                break;
            }
            case 122: {
                this.dec();
                break;
            }
            case 124: {
                this.inc();
                break;
            }
            case 125: {
                this.tst();
                break;
            }
            case 126: {
                this.jmp();
                break;
            }
            case 127: {
                this.clr();
                break;
            }
            case 128: {
                this.suba();
                break;
            }
            case 129: {
                this.cmpa();
                break;
            }
            case 130: {
                this.sbca();
                break;
            }
            case 131: {
                this.subd_cmpd_cmpu();
                break;
            }
            case 132: {
                this.anda();
                break;
            }
            case 133: {
                this.bita();
                break;
            }
            case 134: {
                this.lda();
                break;
            }
            case 136: {
                this.eora();
                break;
            }
            case 137: {
                this.adca();
                break;
            }
            case 138: {
                this.ora();
                break;
            }
            case 139: {
                this.adda();
                break;
            }
            case 140: {
                this.cmpx_y_s();
                break;
            }
            case 141: {
                this.bsr();
                break;
            }
            case 142: {
                this.ldx_y();
                break;
            }
            case 144: {
                this.suba();
                break;
            }
            case 145: {
                this.cmpa();
                break;
            }
            case 146: {
                this.sbca();
                break;
            }
            case 147: {
                this.subd_cmpd_cmpu();
                break;
            }
            case 148: {
                this.anda();
                break;
            }
            case 149: {
                this.bita();
                break;
            }
            case 150: {
                this.lda();
                break;
            }
            case 151: {
                this.sta();
                break;
            }
            case 152: {
                this.eora();
                break;
            }
            case 153: {
                this.adca();
                break;
            }
            case 154: {
                this.ora();
                break;
            }
            case 155: {
                this.adda();
                break;
            }
            case 156: {
                this.cmpx_y_s();
                break;
            }
            case 157: {
                this.jsr();
                break;
            }
            case 158: {
                this.ldx_y();
                break;
            }
            case 159: {
                this.stx_y();
                break;
            }
            case 160: {
                this.suba();
                break;
            }
            case 161: {
                this.cmpa();
                break;
            }
            case 162: {
                this.sbca();
                break;
            }
            case 163: {
                this.subd_cmpd_cmpu();
                break;
            }
            case 164: {
                this.anda();
                break;
            }
            case 165: {
                this.bita();
                break;
            }
            case 166: {
                this.lda();
                break;
            }
            case 167: {
                this.sta();
                break;
            }
            case 168: {
                this.eora();
                break;
            }
            case 169: {
                this.adca();
                break;
            }
            case 170: {
                this.ora();
                break;
            }
            case 171: {
                this.adda();
                break;
            }
            case 172: {
                this.cmpx_y_s();
                break;
            }
            case 173: {
                this.jsr();
                break;
            }
            case 174: {
                this.ldx_y();
                break;
            }
            case 175: {
                this.stx_y();
                break;
            }
            case 176: {
                this.suba();
                break;
            }
            case 177: {
                this.cmpa();
                break;
            }
            case 178: {
                this.sbca();
                break;
            }
            case 179: {
                this.subd_cmpd_cmpu();
                break;
            }
            case 180: {
                this.anda();
                break;
            }
            case 181: {
                this.bita();
                break;
            }
            case 182: {
                this.lda();
                break;
            }
            case 183: {
                this.sta();
                break;
            }
            case 184: {
                this.eora();
                break;
            }
            case 185: {
                this.adca();
                break;
            }
            case 186: {
                this.ora();
                break;
            }
            case 187: {
                this.adda();
                break;
            }
            case 188: {
                this.cmpx_y_s();
                break;
            }
            case 189: {
                this.jsr();
                break;
            }
            case 190: {
                this.ldx_y();
                break;
            }
            case 191: {
                this.stx_y();
                break;
            }
            case 192: {
                this.subb();
                break;
            }
            case 193: {
                this.cmpb();
                break;
            }
            case 194: {
                this.sbcb();
                break;
            }
            case 195: {
                this.addd();
                break;
            }
            case 196: {
                this.andb();
                break;
            }
            case 197: {
                this.bitb();
                break;
            }
            case 198: {
                this.ldb();
                break;
            }
            case 200: {
                this.eorb();
                break;
            }
            case 201: {
                this.adcb();
                break;
            }
            case 202: {
                this.orb();
                break;
            }
            case 203: {
                this.addb();
                break;
            }
            case 204: {
                this.ldd();
                break;
            }
            case 206: {
                this.ldu_s();
                break;
            }
            case 208: {
                this.subb();
                break;
            }
            case 209: {
                this.cmpb();
                break;
            }
            case 210: {
                this.sbcb();
                break;
            }
            case 211: {
                this.addd();
                break;
            }
            case 212: {
                this.andb();
                break;
            }
            case 213: {
                this.bitb();
                break;
            }
            case 214: {
                this.ldb();
                break;
            }
            case 215: {
                this.stb();
                break;
            }
            case 216: {
                this.eorb();
                break;
            }
            case 217: {
                this.adcb();
                break;
            }
            case 218: {
                this.orb();
                break;
            }
            case 219: {
                this.addb();
                break;
            }
            case 220: {
                this.ldd();
                break;
            }
            case 221: {
                this.std();
                break;
            }
            case 222: {
                this.ldu_s();
                break;
            }
            case 223: {
                this.stu_s();
                break;
            }
            case 224: {
                this.subb();
                break;
            }
            case 225: {
                this.cmpb();
                break;
            }
            case 226: {
                this.sbcb();
                break;
            }
            case 227: {
                this.addd();
                break;
            }
            case 228: {
                this.andb();
                break;
            }
            case 229: {
                this.bitb();
                break;
            }
            case 230: {
                this.ldb();
                break;
            }
            case 231: {
                this.stb();
                break;
            }
            case 232: {
                this.eorb();
                break;
            }
            case 233: {
                this.adcb();
                break;
            }
            case 234: {
                this.orb();
                break;
            }
            case 235: {
                this.addb();
                break;
            }
            case 236: {
                this.ldd();
                break;
            }
            case 237: {
                this.std();
                break;
            }
            case 238: {
                this.ldu_s();
                break;
            }
            case 239: {
                this.stu_s();
                break;
            }
            case 240: {
                this.subb();
                break;
            }
            case 241: {
                this.cmpb();
                break;
            }
            case 242: {
                this.sbcb();
                break;
            }
            case 243: {
                this.addd();
                break;
            }
            case 244: {
                this.andb();
                break;
            }
            case 245: {
                this.bitb();
                break;
            }
            case 246: {
                this.ldb();
                break;
            }
            case 247: {
                this.stb();
                break;
            }
            case 248: {
                this.eorb();
                break;
            }
            case 249: {
                this.adcb();
                break;
            }
            case 250: {
                this.orb();
                break;
            }
            case 251: {
                this.addb();
                break;
            }
            case 252: {
                this.ldd();
                break;
            }
            case 253: {
                this.std();
                break;
            }
            case 254: {
                this.ldu_s();
                break;
            }
            case 255: {
                this.stu_s();
            }
        }
    }

    private void abx() {
        this.x = this.x + this.b & 0xFFFF;
    }

    private void adca() {
        this.a = this.adc8BitBase(this.a);
    }

    private void adcb() {
        this.b = this.adc8BitBase(this.b);
    }

    private void adda() {
        this.a = this.add8BitBase(this.a);
    }

    private void addb() {
        this.b = this.add8BitBase(this.b);
    }

    private void addd() {
        int operand2 = this.useEa ? this.read2Bytes(this.ea) : this.fetch2();
        int d = this.d();
        int t = (d & Short.MAX_VALUE) + (operand2 & Short.MAX_VALUE);
        this.flagV = this.getBit(t, 15) != 0;
        t = (d & 0xFFFF) + (operand2 & 0xFFFF);
        this.flagC = this.getBit(t, 16) != 0;
        this.flagV ^= this.flagC;
        d = t & 0xFFFF;
        this.flagN = this.isNeg16Bit(d);
        this.flagZ = d == 0;
        this.setD(d);
    }

    private void anda() {
        this.a = this.and8BitBase(this.a);
    }

    private void andb() {
        this.b = this.and8BitBase(this.b);
    }

    private void andcc() {
        this.setCC(this.cc() & this.fetch());
    }

    private void asla() {
        this.a = this.asl8BitBase(this.a);
    }

    private void aslb() {
        this.b = this.asl8BitBase(this.b);
    }

    private void asl() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.asl8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.asl8BitBase(operand));
        }
    }

    private void asra() {
        this.a = this.asr8BitBase(this.a);
    }

    private void asrb() {
        this.b = this.asr8BitBase(this.b);
    }

    private void asr() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.asr8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.asr8BitBase(operand));
        }
    }

    private void xbcc() {
        if (!this.flagC) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbcs() {
        if (this.flagC) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbeq() {
        if (this.flagZ) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbge() {
        if (this.flagN ^ this.flagV) {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        } else {
            this.branchBase();
        }
    }

    private void xbgt() {
        if (this.flagZ || this.flagN ^ this.flagV) {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        } else {
            this.branchBase();
        }
    }

    private void xbhi() {
        if (this.flagC | this.flagZ) {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        } else {
            this.branchBase();
        }
    }

    private void bita() {
        this.and8BitBase(this.a);
    }

    private void bitb() {
        this.and8BitBase(this.b);
    }

    private void xble() {
        if (this.flagZ || this.flagN ^ this.flagV) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbls() {
        if (this.flagC || this.flagZ) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xblt() {
        if (this.flagN ^ this.flagV) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbmi() {
        if (this.flagN) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbne() {
        if (!this.flagZ) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbpl() {
        if (!this.flagN) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void bra() {
        this.branchBase();
    }

    private void lbra() {
        this.page = 2;
        this.branchBase();
        ++this.tCycle;
    }

    private void xbrn() {
        this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
    }

    private void bsr() {
        int operand = this.fetch();
        this.pull_push8BitBase(false, true, 128);
        this.tCycle += 2;
        this.pc += this.to2C8Bit(operand);
    }

    private void lbsr() {
        this.page = 2;
        int operand2 = this.fetch2();
        this.pull_push8BitBase(false, true, 128);
        this.tCycle += 2;
        this.pc += this.to2C16Bit(operand2);
    }

    private void xbvc() {
        if (!this.flagV) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void xbvs() {
        if (this.flagV) {
            this.branchBase();
        } else {
            this.pc = this.page == 1 ? ++this.pc : (this.pc += 2);
        }
    }

    private void clra() {
        this.a = this.clr8BitBase();
    }

    private void clrb() {
        this.b = this.clr8BitBase();
    }

    private void clr() {
        if (!this.useEa) {
            this.writeByte(this.pc++, this.clr8BitBase());
        } else {
            this.writeByte(this.ea, this.clr8BitBase());
        }
    }

    private void cmpa() {
        this.cmp8BitBase(this.a);
    }

    private void cmpb() {
        this.cmp8BitBase(this.b);
    }

    private void cmpx_y_s() {
        if (this.page == 1) {
            this.cmp16BitBase(this.x);
        } else if (this.page == 2) {
            this.cmp16BitBase(this.y);
        } else {
            this.cmp16BitBase(this.s);
        }
    }

    private void coma() {
        this.a = this.com8BitBase(this.a);
    }

    private void comb() {
        this.b = this.com8BitBase(this.b);
    }

    private void com() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.com8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.com8BitBase(operand));
        }
    }

    private void cwai() {
        int tempCC = this.cc() & this.fetch();
        this.setCC(tempCC |= M6809Const.E_MASK);
        this.pull_push8BitBase(false, true, 255);
        this.waitState = 8;
        this.interruptState |= 8;
        this.tCycle = 0;
    }

    private void daa() {
        int lsn = this.a & 0xF;
        int msn = this.a & 0xF0;
        int temp = 0;
        int cf = 0;
        if (lsn > 9 || this.flagH) {
            cf |= 6;
        }
        if (msn > 128 && lsn > 9 || this.flagC || msn > 144) {
            cf |= 0x60;
        }
        this.flagC = ((temp = cf + this.a) & 0x100) != 0 || this.flagC;
        this.a = temp & 0xFF;
        this.flagZ = this.a == 0;
        this.flagN = this.isNeg8Bit(this.a);
    }

    private void deca() {
        this.a = this.dec8BitBase(this.a);
    }

    private void decb() {
        this.b = this.dec8BitBase(this.b);
    }

    private void dec() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.dec8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.dec8BitBase(operand));
        }
    }

    private void eora() {
        this.a = this.eor8BitBase(this.a);
    }

    private void eorb() {
        this.b = this.eor8BitBase(this.b);
    }

    private void exg() {
        int operand = this.fetch();
        if (this.getBit(operand, 7) == 0) {
            this.exg_tfr16BitBase(true, operand);
        } else {
            this.exg_tfr8BitBase(true, operand);
        }
    }

    private void inca() {
        this.a = this.inc8BitBase(this.a);
    }

    private void incb() {
        this.b = this.inc8BitBase(this.b);
    }

    private void inc() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.inc8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.inc8BitBase(operand));
        }
    }

    private void jmp() {
        this.pc = this.ea;
    }

    private void jsr() {
        this.pull_push8BitBase(false, true, 128);
        this.tCycle += 2;
        this.pc = this.ea;
    }

    private void lda() {
        this.a = this.ld8BitBase();
    }

    private void ldb() {
        this.b = this.ld8BitBase();
    }

    private void ldd() {
        this.setD(this.ld16BitBase());
    }

    private void ldx_y() {
        if (this.page == 1) {
            this.x = this.ld16BitBase();
        } else {
            this.y = this.ld16BitBase();
        }
    }

    private void ldu_s() {
        if (this.page == 1) {
            this.u = this.ld16BitBase();
        } else {
            this.s = this.ld16BitBase();
        }
    }

    private void leax() {
        this.x = this.lea16BitBase(this.x);
        this.flagZ = this.x == 0;
    }

    private void leay() {
        this.y = this.lea16BitBase(this.y);
        this.flagZ = this.y == 0;
    }

    private void leas() {
        this.s = this.lea16BitBase(this.s);
    }

    private void leau() {
        this.u = this.lea16BitBase(this.u);
    }

    private void lsra() {
        this.a = this.lsr8BitBase(this.a);
    }

    private void lsrb() {
        this.b = this.lsr8BitBase(this.b);
    }

    private void lsr() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.lsr8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.lsr8BitBase(operand));
        }
    }

    private void mul() {
        this.flagZ = this.a == 0 || this.b == 0;
        this.flagC = ((this.a & 0xFF) * (this.b & 0xFF) & 0x80) != 0;
        this.setD((this.a & 0xFF) * (this.b & 0xFF) & 0xFFFF);
    }

    private void nega() {
        this.a = this.neg8BitBase(this.a);
    }

    private void negb() {
        this.b = this.neg8BitBase(this.b);
    }

    private void neg() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.neg8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.neg8BitBase(operand));
        }
    }

    private void nop() {
    }

    private void ora() {
        this.a = this.or8BitBase(this.a);
    }

    private void orb() {
        this.b = this.or8BitBase(this.b);
    }

    private void orcc() {
        this.setCC(this.cc() | this.fetch());
    }

    private void pshs() {
        this.pull_push8BitBase(false, true, this.fetch());
    }

    private void pshu() {
        this.pull_push8BitBase(false, false, this.fetch());
    }

    private void puls() {
        this.pull_push8BitBase(true, true, this.fetch());
    }

    private void pulu() {
        this.pull_push8BitBase(true, false, this.fetch());
    }

    private void rora() {
        this.a = this.ror8BitBase(this.a);
    }

    private void rorb() {
        this.b = this.ror8BitBase(this.b);
    }

    private void ror() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.ror8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.ror8BitBase(operand));
        }
    }

    private void rola() {
        this.a = this.rol8BitBase(this.a);
    }

    private void rolb() {
        this.b = this.rol8BitBase(this.b);
    }

    private void rol() {
        if (!this.useEa) {
            int operand = this.readByte(this.pc);
            this.writeByte(this.pc++, this.rol8BitBase(operand));
        } else {
            int operand = this.readByte(this.ea);
            this.writeByte(this.ea, this.rol8BitBase(operand));
        }
    }

    private void rti() {
        this.pull_push8BitBase(true, true, 1);
        ++this.tCycle;
        if (this.flagE) {
            this.pull_push8BitBase(true, true, 254);
            this.tCycle -= 4;
        } else {
            this.pull_push8BitBase(true, true, 128);
            this.tCycle += 3;
        }
    }

    private void rts() {
        this.pull_push8BitBase(true, true, 128);
        this.tCycle += 2;
    }

    private void sbca() {
        this.a = this.sbc8BitBase(this.a);
    }

    private void sbcb() {
        this.b = this.sbc8BitBase(this.b);
    }

    private void sex() {
        this.a = this.isNeg8Bit(this.b) ? 255 : 0;
        this.flagV = false;
        this.flagN = this.isNeg8Bit(this.b);
        this.flagZ = this.b == 0;
    }

    private void sta() {
        this.st8BitBase(this.a);
    }

    private void stb() {
        this.st8BitBase(this.b);
    }

    private void std() {
        this.st16BitBase(this.d());
    }

    private void stx_y() {
        if (this.page == 1) {
            this.st16BitBase(this.x);
        } else {
            this.st16BitBase(this.y);
        }
    }

    private void stu_s() {
        if (this.page == 1) {
            this.st16BitBase(this.u);
        } else {
            this.st16BitBase(this.s);
        }
    }

    private void suba() {
        this.a = this.sub8BitBase(this.a);
    }

    private void subb() {
        this.b = this.sub8BitBase(this.b);
    }

    private void subd_cmpd_cmpu() {
        if (this.page == 1) {
            int d = this.d();
            int operand2 = !this.useEa ? this.fetch2() : this.read2Bytes(this.ea);
            int t = d - operand2;
            this.flagV = ((d ^ operand2 ^ t ^ t >> 1) & 0x8000) != 0;
            this.flagC = (t & 0x10000) != 0;
            d = t & 0xFFFF;
            this.flagN = this.isNeg16Bit(d);
            this.flagZ = d == 0;
            this.setD(d);
        } else if (this.page == 2) {
            this.cmp16BitBase(this.d());
        } else {
            this.cmp16BitBase(this.u);
        }
    }

    private void swi() {
        this.flagE = true;
        this.pull_push8BitBase(false, true, 255);
        this.tCycle += 12;
        this.flagI = true;
        this.flagF = true;
        this.pc = this.readByte(65530) << 8 | this.readByte(65531);
    }

    private void swi2() {
        this.flagE = true;
        this.pull_push8BitBase(false, true, 255);
        this.tCycle += 12;
        this.pc = this.readByte(65524) << 8 | this.readByte(65525);
    }

    private void swi3() {
        this.flagE = true;
        this.pull_push8BitBase(false, true, 255);
        this.tCycle += 12;
        this.pc = this.readByte(65522) << 8 | this.readByte(65523);
    }

    private void sync() {
        this.waitState = 16;
        this.tCycle = 0;
    }

    private void tfr() {
        int operand = this.fetch();
        if (this.getBit(operand, 7) == 0) {
            this.exg_tfr16BitBase(false, operand);
        } else {
            this.exg_tfr8BitBase(false, operand);
        }
    }

    private void tsta() {
        this.tst8BitBase(this.a);
    }

    private void tstb() {
        this.tst8BitBase(this.b);
    }

    private void tst() {
        if (!this.useEa) {
            int operand = this.fetch();
            this.tst8BitBase(operand);
        } else {
            int operand = this.readByte(this.ea);
            this.tst8BitBase(operand);
        }
    }

    public int getCyclesLeft() {
        return this.tCycle;
    }
}

