/*
 * Decompiled with CFR 0.152.
 */
package jef.cpuboard;

import jef.cpu.Cpu;
import jef.cpuboard.CpuBoard;
import jef.cpuboard.CpuDriver;
import jef.map.InterruptHandler;
import jef.map.ReadHandler;
import jef.map.ReadMap;
import jef.map.WriteHandler;
import jef.map.WriteMap;

public class BasicCpuBoard
implements CpuBoard {
    public Cpu cpu;
    public int frq;
    private ReadMap mra;
    private WriteMap mwa;
    private ReadHandler ior;
    private WriteHandler iow;
    public InterruptHandler irqHandler;
    public int ipf;
    public int[] mem;

    public boolean init(CpuDriver cpuDriver) {
        this.cpu = cpuDriver.cpu;
        this.frq = cpuDriver.frq;
        this.mra = cpuDriver.mra;
        this.mwa = cpuDriver.mwa;
        this.ior = cpuDriver.ior;
        this.iow = cpuDriver.iow;
        this.mem = cpuDriver.mra.getMemory();
        this.irqHandler = cpuDriver.irh;
        this.ipf = cpuDriver.ipf;
        this.cpu.init(this, 0);
        return true;
    }

    public int[] getMem() {
        return this.mem;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public void reset(boolean hard) {
        this.cpu.reset();
        if (hard) {
            int i = 0;
            while (i < this.mwa.getSize()) {
                this.mwa.write(i, 0);
                ++i;
            }
        }
    }

    public void exec(int cycles) {
        this.cpu.exec(cycles);
    }

    public void interrupt(int type, boolean irq) {
        this.cpu.interrupt(type, irq);
    }

    public void write8(int address, int data) {
        this.mwa.write(address, data);
    }

    public void write8fast(int address, int data) {
        this.mwa.write(address, data);
    }

    public int read8(int address) {
        return this.mra.read(address);
    }

    public int read8opc(int address) {
        return this.mra.read(address);
    }

    public int read8arg(int address) {
        return this.mra.read(address);
    }

    public void write16(int address, int data) {
        this.mwa.write(address++, data & 0xFF);
        this.mwa.write(address, data >> 8);
    }

    public void write16fast(int address, int data) {
        this.mwa.write(address++, data & 0xFF);
        this.mwa.write(address, data >> 8);
    }

    public int read16(int address) {
        return this.mra.read(address++) | this.mra.read(address) << 8;
    }

    public int read16arg(int address) {
        return this.mra.read(address++) | this.mra.read(address) << 8;
    }

    public void out(int port, int value) {
        this.iow.write(port, value);
    }

    public int in(int port) {
        return this.ior.read(port);
    }
}

