/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import jef.machine.Machine;
import jef.map.WriteHandler;

public class HighScoreHandler
implements WriteHandler {
    WriteHandler writeHandler;
    Machine m;
    int[] memory;
    int blank_char;
    int zero_char;
    int initial_high_score;
    int start_addr;
    int offset;
    int last_addr;
    public static final int CHAR_NIBBLES = 0xFFFFFF;
    boolean save_highscore = false;
    int delay;

    public HighScoreHandler(WriteHandler passThrough, Machine m, int[] memory, int blank_char, int zero_char, int initial_high_score, int start_addr, int offset, int last_addr, int delay) {
        this.writeHandler = passThrough;
        this.m = m;
        this.memory = memory;
        this.blank_char = blank_char;
        this.zero_char = zero_char;
        this.initial_high_score = initial_high_score;
        this.start_addr = start_addr;
        this.offset = offset;
        this.last_addr = last_addr;
        m.setHighScoreSupported(true);
        m.setHighScore(0L);
    }

    public void write(int address, int data) {
        if (this.memory[address] != data) {
            this.writeHandler.write(address, data);
            if (this.save_highscore) {
                this.m.setHighScore(this.calcScore());
            } else if (this.delay > 0) {
                --this.delay;
            } else if (this.calcScore() == (long)this.initial_high_score) {
                System.out.println("Triggered highscore saving.");
                this.save_highscore = true;
            }
        }
    }

    private long calcScore() {
        long score = 0L;
        int pow = 0;
        if (this.blank_char == 0xFFFFFF) {
            int i = this.last_addr;
            while (i >= this.start_addr) {
                int c = this.memory[i];
                score = (long)((double)score + (double)(c & 0xF) * Math.pow(10.0, pow++));
                score = (long)((double)score + (double)(c >> 4) * Math.pow(10.0, pow++));
                i -= this.offset;
            }
        } else {
            int i = this.last_addr;
            while (i >= this.start_addr) {
                int c = this.memory[i];
                if (c == 0 || c == this.blank_char) {
                    c = this.zero_char;
                }
                score = (long)((double)score + (double)(c -= this.zero_char) * Math.pow(10.0, pow++));
                i -= this.offset;
            }
        }
        if ((double)score >= Math.pow(10.0, pow) || score == (long)this.initial_high_score) {
            score = 0L;
        }
        return score;
    }
}

