/*
 * Decompiled with CFR 0.152.
 */
package jef.sound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SamplePlayer {
    private Line.Info lineInfo;
    private Vector afs = new Vector();
    private Vector sizes = new Vector();
    private Vector infos = new Vector();
    private Vector audios = new Vector();
    private Vector urls = new Vector();
    private Vector clips = new Vector();
    private int num = 0;
    static /* synthetic */ Class class$0;

    public void loadSound(String s) throws IOException, UnsupportedAudioFileException, LineUnavailableException, FileNotFoundException {
        System.out.println("loadSound(" + s + ")");
        if (this.getIndex(s) >= 0) {
            return;
        }
        URL url = this.getClass().getResource(s);
        if (url == null) {
            throw new FileNotFoundException();
        }
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.loadStream(url.openStream()));
        AudioFormat af = audioInputStream.getFormat();
        int size = (int)((long)af.getFrameSize() * audioInputStream.getFrameLength());
        byte[] audio = new byte[size];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.Clip");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataLine.Info info = new DataLine.Info(clazz, af, size);
        audioInputStream.read(audio, 0, size);
        this.urls.add(s);
        this.afs.add(af);
        this.sizes.add(new Integer(size));
        this.infos.add(info);
        this.audios.add(audio);
        Clip clip = (Clip)AudioSystem.getLine(info);
        clip.open(af, audio, 0, size);
        this.clips.add(clip);
        ++this.num;
    }

    private ByteArrayInputStream loadStream(InputStream inputstream) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int i = inputstream.read(data);
        while (i != -1) {
            bytearrayoutputstream.write(data, 0, i);
            i = inputstream.read(data);
        }
        inputstream.close();
        bytearrayoutputstream.close();
        data = bytearrayoutputstream.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private void playSound(int x) throws UnsupportedAudioFileException, LineUnavailableException {
        if (x > this.num || x < 0) {
            System.out.println("playSound: sample nr[" + x + "] is not available");
        } else {
            Clip clip = (Clip)this.clips.elementAt(x);
            if (!clip.isActive()) {
                clip.setFramePosition(0);
            }
            clip.start();
        }
    }

    private int getIndex(String s) {
        int i = 0;
        while (i < this.urls.size()) {
            String u = (String)this.urls.get(i);
            if (u.equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void playSound(String s) throws Exception {
        int i = this.getIndex(s);
        if (i < 0) {
            this.loadSound(s);
        }
        this.playSound(i);
    }
}

