/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip.fm;

import jef.sound.chip.YM2203;
import jef.sound.chip.fm.FMConstants;
import jef.sound.chip.fm.FMSlot;
import jef.util.INT32;

public class FMChan
implements FMConstants {
    public FMSlot[] SLOT = new FMSlot[4];
    public int PAN;
    public int ALGO;
    public int FB;
    public int[] op1_out = new int[2];
    public INT32 connect1;
    public INT32 connect2;
    public INT32 connect3;
    public INT32 connect4;
    public int pms;
    public long ams;
    public int fc;
    public int fn_h;
    public int kcode;

    public FMChan() {
        int i = 0;
        while (i < 4) {
            this.SLOT[i] = new FMSlot();
            ++i;
        }
    }

    public void FM_CALC_CH() {
        YM2203.pg_in1.value = (int)(this.SLOT[0].Cnt += this.SLOT[0].Incr);
        YM2203.pg_in2.value = (int)(this.SLOT[2].Cnt += this.SLOT[2].Incr);
        YM2203.pg_in3.value = (int)(this.SLOT[1].Cnt += this.SLOT[1].Incr);
        YM2203.pg_in4.value = (int)(this.SLOT[3].Cnt += this.SLOT[3].Incr);
        int eg_out1 = this.SLOT[0].FM_CALC_EG();
        int eg_out2 = this.SLOT[2].FM_CALC_EG();
        int eg_out3 = this.SLOT[2].FM_CALC_EG();
        int eg_out4 = this.SLOT[3].FM_CALC_EG();
        if (eg_out1 < 2901) {
            if (this.FB != 0) {
                YM2203.pg_in1.value += this.op1_out[0] + this.op1_out[1] >> this.FB;
                this.op1_out[1] = this.op1_out[0];
            }
            this.op1_out[0] = this.OP_OUT(YM2203.pg_in1.value, eg_out1);
            if (this.connect1 == null) {
                YM2203.pg_in2.value += this.op1_out[0];
                YM2203.pg_in3.value += this.op1_out[0];
                YM2203.pg_in4.value += this.op1_out[0];
            } else {
                this.connect1.value += this.op1_out[0];
            }
        }
        if (eg_out2 < 2901) {
            this.connect2.value += this.OP_OUT(YM2203.pg_in2.value, eg_out2);
        }
        if (eg_out3 < 2901) {
            this.connect3.value += this.OP_OUT(YM2203.pg_in3.value, eg_out3);
        }
        if (eg_out4 < 2901) {
            this.connect4.value += this.OP_OUT(YM2203.pg_in4.value, eg_out4);
        }
    }

    private int OP_OUT(int PG, int EG) {
        return YM2203.SIN_TABLE(PG / 8192 & 0x7FF, EG);
    }

    public void CALC_FCOUNT() {
        if (this.SLOT[0].Incr == -1L) {
            int fc = this.fc;
            int kc = this.kcode;
            this.SLOT[0].CALC_FCSLOT(fc, kc);
            this.SLOT[2].CALC_FCSLOT(fc, kc);
            this.SLOT[1].CALC_FCSLOT(fc, kc);
            this.SLOT[3].CALC_FCSLOT(fc, kc);
        }
    }

    private boolean FM_KEY_IS(FMSlot SLOT) {
        return SLOT.eg_next != 0;
    }

    public void FM_KEYON(int s) {
        FMSlot slot = this.SLOT[s];
        if (!this.FM_KEY_IS(slot)) {
            slot.Cnt = 0L;
            slot.eg_next = (slot.SEG & 8) != 0 ? 6 : 3;
            slot.evs = slot.evsa;
            slot.evc = 0;
            slot.eve = 0x10000000;
        }
    }

    public void FM_KEYOFF(int s) {
        FMSlot slot = this.SLOT[s];
        if (this.FM_KEY_IS(slot)) {
            if (slot.evc < 0x10000000) {
                slot.evc = (YM2203.ENV_CURVE[slot.evc >> 16] << 16) + 0x10000000;
            }
            slot.eg_next = 0;
            slot.eve = 0x1FFF0000;
            slot.evs = slot.evsr;
        }
    }

    public void CSMKeyControll() {
        this.FM_KEYOFF(0);
        this.FM_KEYOFF(2);
        this.FM_KEYOFF(1);
        this.FM_KEYOFF(3);
        this.SLOT[0].TLL = this.SLOT[0].TL;
        this.SLOT[2].TLL = this.SLOT[2].TL;
        this.SLOT[1].TLL = this.SLOT[1].TL;
        this.SLOT[3].TLL = this.SLOT[3].TL;
        this.FM_KEYON(0);
        this.FM_KEYON(2);
        this.FM_KEYON(1);
        this.FM_KEYON(3);
    }
}

