/*
 * Decompiled with CFR 0.152.
 */
package jef.demo;

import java.net.URL;
import jef.cpu.I8080;
import jef.cpuboard.CpuDriver;
import jef.machine.BasicMachine;
import jef.machine.Machine;
import jef.machine.MachineDriver;
import jef.map.IOReadPort;
import jef.map.IOWritePort;
import jef.map.InputPort;
import jef.map.InterruptHandler;
import jef.map.MemoryReadAddress;
import jef.map.MemoryWriteAddress;
import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.util.RomLoader;
import jef.video.BitMap;
import jef.video.BitMapImpl;
import jef.video.Vh_refresh;

public class InvEmulator
implements InterruptHandler,
Vh_refresh,
WriteHandler {
    URL base_URL;
    Machine m = new BasicMachine();
    static final int SCREEN_WIDTH = 224;
    static final int SCREEN_HEIGHT = 256;
    static final int SCREEN_FPS = 60;
    static final int CPU_CLOCK_SPEED = 2000000;
    static final int CPU_IRQ_PER_FRAME = 2;
    InputPort[] input;
    int[][] memory = new int[1][65536];
    int count = 0;
    int shift_amount = 0;
    int shift_data1 = 0;
    int shift_data2 = 0;
    int[] pixels;
    BitMapImpl bitmap;
    int[] pal;
    int[][] gfx;

    public InvEmulator() {
        int[] nArray = new int[2];
        nArray[1] = 0xFFFFFF;
        this.pal = nArray;
        this.gfx = new int[256][8];
    }

    public Machine getMachine(URL base_URL, int w, int h) {
        this.base_URL = base_URL;
        this.bitmap = new BitMapImpl(w, h);
        this.pixels = this.bitmap.getPixels();
        int i = 0;
        while (i < 256) {
            this.gfx[i][7] = this.pal[i >> 7];
            this.gfx[i][6] = this.pal[(i & 0x40) >> 6];
            this.gfx[i][5] = this.pal[(i & 0x20) >> 5];
            this.gfx[i][4] = this.pal[(i & 0x10) >> 4];
            this.gfx[i][3] = this.pal[(i & 8) >> 3];
            this.gfx[i][2] = this.pal[(i & 4) >> 2];
            this.gfx[i][1] = this.pal[(i & 2) >> 1];
            this.gfx[i][0] = this.pal[i & 1];
            ++i;
        }
        this.loadROMs();
        this.input = this.createInputPorts();
        MachineDriver md = new MachineDriver(this.createCpuDriver(), 224, 256, this);
        md.setFPS(60);
        md.setInputPorts(this.input);
        this.m.init(md);
        return this.m;
    }

    public CpuDriver[] createCpuDriver() {
        CpuDriver[] cpuDriver = new CpuDriver[]{new CpuDriver(new I8080(), 2000000, this.createMemoryReadAddress(), this.createMemoryWriteAddress(), this.createIOReadPort(), this.createIOWritePort(), this, 2)};
        return cpuDriver;
    }

    public int irq() {
        ++this.count;
        if ((this.count & 1) == 1) {
            return 0;
        }
        return 1;
    }

    private MemoryReadAddress createMemoryReadAddress() {
        MemoryReadAddress mra = new MemoryReadAddress(this.memory[0]);
        mra.setMR(0, 8191, 1);
        mra.setMR(8192, 16383, 0);
        mra.setMR(16384, 25599, 1);
        return mra;
    }

    private MemoryWriteAddress createMemoryWriteAddress() {
        MemoryWriteAddress mwa = new MemoryWriteAddress(this.memory[0]);
        mwa.setMW(0, 8191, 1);
        mwa.setMW(8192, 9215, 0);
        mwa.set(9216, 16383, this);
        mwa.setMW(16384, 25599, 1);
        return mwa;
    }

    private IOReadPort createIOReadPort() {
        IOReadPort ior = new IOReadPort();
        ior.set(1, 1, this.input[0]);
        ior.set(2, 2, this.input[1]);
        ior.set(3, 3, new ShiftDataR());
        return ior;
    }

    private IOWritePort createIOWritePort() {
        IOWritePort iow = new IOWritePort();
        iow.set(2, 2, new ShiftAmountW());
        iow.set(4, 4, new ShiftDataW());
        return iow;
    }

    private InputPort[] createInputPorts() {
        InputPort[] port = new InputPort[]{new InputPort(), new InputPort()};
        port[0].setBit(1, 255, 1);
        port[0].setBit(2, 0, 4);
        port[0].setBit(4, 0, 3);
        port[0].setBit(16, 0, 9);
        port[0].setBit(32, 0, 5);
        port[0].setBit(64, 0, 6);
        port[0].setBit(128, 255, 0);
        port[1].setDipName(3, 0, "Lives");
        port[1].setDipSetting(0, "3");
        port[1].setDipSetting(1, "4");
        port[1].setDipSetting(2, "5");
        port[1].setDipSetting(3, "6");
        port[1].setBit(4, 0, 15);
        port[1].setDipName(8, 0, "Bonus Live");
        port[1].setDipSetting(8, "1000");
        port[1].setDipSetting(0, "1500");
        port[1].setBit(16, 0, 137);
        port[1].setBit(32, 0, 133);
        port[1].setBit(64, 0, 134);
        port[1].setDipName(128, 0, "Coport Info");
        port[1].setDipSetting(128, "Off");
        port[1].setDipSetting(0, "on");
        return port;
    }

    private void loadROMs() {
        RomLoader romLoader = new RomLoader();
        romLoader.setZip("invaders");
        romLoader.setMemory(this.memory[0]);
        romLoader.loadROM("invaders.h", 0, 2048, 1934580440);
        romLoader.loadROM("invaders.g", 2048, 2048, 1811597898);
        romLoader.loadROM("invaders.f", 4096, 2048, 214871446);
        romLoader.loadROM("invaders.e", 6144, 2048, 350566576);
        romLoader.loadZip(this.base_URL);
    }

    public void write(int address, int data) {
        this.memory[0][address] = data;
        int i = 7167 - (address - 9216);
        int x = (i & 0x1F) * 8;
        int y = 223 - (i >> 5);
        int n = 0;
        while (n < 8) {
            i = (x + n) * 224 + y;
            this.pixels[i] = this.pal[this.gfx[data][7 - n] & 1];
            ++n;
        }
    }

    public BitMap video_update() {
        return this.bitmap;
    }

    public void video_post_update() {
    }

    public class ShiftDataR
    implements ReadHandler {
        public int read(int port) {
            return (InvEmulator.this.shift_data1 << 8 | InvEmulator.this.shift_data2) << (InvEmulator.this.shift_amount & 7) >> 8 & 0xFF;
        }
    }

    public class ShiftDataW
    implements WriteHandler {
        public void write(int port, int data) {
            InvEmulator.this.shift_data2 = InvEmulator.this.shift_data1;
            InvEmulator.this.shift_data1 = data;
        }
    }

    public class ShiftAmountW
    implements WriteHandler {
        public void write(int port, int data) {
            InvEmulator.this.shift_amount = data;
        }
    }
}

