/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip;

import jef.map.WriteHandler;
import jef.sound.SoundChip;
import jef.sound.SoundChipEmulator;

public class Namco
extends SoundChip
implements SoundChipEmulator {
    static final int WAV_LENGTH = 32;
    float freqDivider;
    int clockFreq;
    int numChannels;
    int[] mem;
    SoundChannel[] channel;
    float[] pwavPointer;
    int[] prom;

    public Namco(int[] mem, int numChannels, int clockFreq, int[] prom) {
        this.prom = prom;
        this.mem = mem;
        this.numChannels = numChannels;
        this.channel = new SoundChannel[numChannels];
        this.clockFreq = clockFreq;
        this.pwavPointer = new float[numChannels];
        int c = 0;
        while (c < numChannels) {
            this.channel[c] = new SoundChannel();
            ++c;
        }
    }

    public void init(boolean useJavaxSound, int sampRate, int buflen, int fps) {
        this.freqDivider = this.clockFreq / sampRate;
        this.freqDivider *= (float)sampRate / 8000.0f;
        super.init(useJavaxSound, sampRate, buflen, fps);
    }

    public void writeBuffer() {
        this.clearBuffer();
        int curChannel = 0;
        while (curChannel < this.numChannels) {
            int frq = this.channel[curChannel].frequency;
            int amp = this.channel[curChannel].volume << 8;
            int wav = this.channel[curChannel].wav;
            if ((frq = (int)((float)frq / this.freqDivider)) > 0 && amp > 0) {
                float step = (float)frq * 32.0f / (float)super.getSampFreq();
                int i = 0;
                while (i < super.getBufferLength()) {
                    int pwav = (this.prom[32 * wav + (int)this.pwavPointer[curChannel]] & 0xF) - 8;
                    this.writeLinBuffer(i, this.readLinBuffer(i) + pwav * amp);
                    this.pwavPointer[curChannel] = (this.pwavPointer[curChannel] + step) % 32.0f;
                    ++i;
                }
            }
            ++curChannel;
        }
        int j = 0;
        while (j < super.getBufferLength()) {
            this.writeLinBuffer(j, this.readLinBuffer(j) / this.numChannels);
            ++j;
        }
    }

    public WriteHandler pengo_sound_w(int base) {
        return new Pengo_sound_w(base);
    }

    class SoundChannel {
        int frequency;
        int volume;
        int wav;

        SoundChannel() {
        }
    }

    public class Pengo_sound_w
    implements WriteHandler {
        int base;

        public Pengo_sound_w(int base) {
            this.base = base;
        }

        public void write(int address, int value) {
            if (Namco.this.mem[address] != (value & 0xF)) {
                Namco.this.mem[address] = value & 0xF;
                int c = 0;
                while (c < Namco.this.numChannels) {
                    int addr = c * 5 + this.base;
                    int freq = Namco.this.mem[20 + addr];
                    freq = freq << 4 | Namco.this.mem[19 + addr];
                    freq = freq << 4 | Namco.this.mem[18 + addr];
                    freq = freq << 4 | Namco.this.mem[17 + addr];
                    freq = c == 0 ? freq << 4 | Namco.this.mem[16 + addr] : (freq <<= 4);
                    Namco.this.channel[c].frequency = freq;
                    Namco.this.channel[c].volume = Namco.this.mem[21 + addr] & 0xF;
                    Namco.this.channel[c].wav = Namco.this.mem[5 + addr] & 7;
                    ++c;
                }
            }
        }
    }
}

