/*
 * Decompiled with CFR 0.152.
 */
package cottage.machine;

import jef.machine.BasicMachine;
import jef.machine.Machine;
import jef.map.InterruptHandler;
import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.video.BitMap;

public class Galaga
extends BasicMachine
implements Machine {
    static boolean interrupt_enable_1 = false;
    static boolean interrupt_enable_2 = false;
    static boolean interrupt_enable_3 = false;
    static int customio_command = 0;
    static int mode = 0;
    static int credits = 0;
    static int coinpercred = 0;
    static int credpercoin = 0;
    static int[] customio = new int[16];
    static int coininserted = 0;
    static boolean nmi_timer = false;
    static boolean halt23 = false;
    public int[] galaga_sharedram;
    cottage.vidhrdw.Galaga video;
    cottage.drivers.Galaga driver;

    public ReadHandler galaga_sharedram_r() {
        return new Galaga_sharedram_r();
    }

    public ReadHandler galaga_dsw_r() {
        return new Galaga_dsw_r();
    }

    public ReadHandler galaga_customio_data_r() {
        return new Galaga_customio_data_r();
    }

    public ReadHandler galaga_customio_r() {
        return new Galaga_customio_r();
    }

    public WriteHandler galaga_customio_data_w() {
        return new Galaga_customio_data_w();
    }

    public WriteHandler galaga_sharedram_w() {
        return new Galaga_sharedram_w();
    }

    public WriteHandler galaga_customio_w() {
        return new Galaga_customio_w();
    }

    public WriteHandler galaga_halt_w() {
        return new Galaga_halt_w();
    }

    public WriteHandler galaga_interrupt_enable_1_w() {
        return new Galaga_interrupt_enable_1_w();
    }

    public WriteHandler galaga_interrupt_enable_2_w() {
        return new Galaga_interrupt_enable_2_w();
    }

    public WriteHandler galaga_interrupt_enable_3_w() {
        return new Galaga_interrupt_enable_3_w();
    }

    public WriteHandler hiscore(WriteHandler wh) {
        return new HiScore(wh);
    }

    public InterruptHandler galaga_interrupt_1() {
        return new Galaga_interrupt_1();
    }

    public InterruptHandler galaga_interrupt_2() {
        return new Galaga_interrupt_2();
    }

    public InterruptHandler galaga_interrupt_3() {
        return new Galaga_interrupt_3();
    }

    public void setRefs(int[] sharedram, cottage.drivers.Galaga driver, cottage.vidhrdw.Galaga video) {
        this.galaga_sharedram = sharedram;
        this.driver = driver;
        this.video = video;
    }

    public BitMap refresh(boolean render) {
        if (render) {
            this.backBuffer = this.getDisplay();
        }
        int s = 0;
        while (s < 99) {
            this.cd[0].cpu.exec(526);
            if (!halt23) {
                this.cd[1].cpu.exec(526);
                this.cd[2].cpu.exec(526);
            }
            if (s == 50 || s == 0) {
                if (nmi_timer) {
                    this.cd[0].cpu.interrupt(1, true);
                }
                if (interrupt_enable_3 && s == 50) {
                    this.cd[2].cpu.interrupt(1, true);
                }
            }
            ++s;
        }
        if (interrupt_enable_1) {
            this.cd[0].cpu.interrupt(0, true);
        }
        if (interrupt_enable_2) {
            this.cd[1].cpu.interrupt(0, true);
        }
        if (interrupt_enable_3) {
            this.cd[2].cpu.interrupt(1, true);
        }
        this.updateInput();
        this.se.update();
        this.video.galaga_vh_interrupt();
        return this.backBuffer;
    }

    public final int readinputport(int port) {
        switch (port) {
            case 0: {
                return 255;
            }
            case 1: {
                return 255;
            }
            case 2: {
                int retval = this.driver.input_port_2_r.read(0);
                this.md.input[2].write(this.md.input[2].read(0) | 0x10);
                return retval;
            }
            case 3: {
                int retval = this.driver.input_port_2_r.read(0);
                this.md.input[2].write(this.md.input[2].read(0) | 0x10);
                return retval;
            }
            case 4: {
                int retval = this.driver.input_port_4_r.read(0);
                this.md.input[4].write(255);
                return retval;
            }
        }
        return 255;
    }

    public class Galaga_sharedram_r
    implements ReadHandler {
        public int read(int address) {
            return Galaga.this.galaga_sharedram[address];
        }
    }

    public class Galaga_sharedram_w
    implements WriteHandler {
        public void write(int address, int data) {
            if (address < 34816) {
                Galaga.this.video.dirtybuffer[address & 0x3FF] = true;
            }
            Galaga.this.galaga_sharedram[address] = data;
        }
    }

    public class Galaga_dsw_r
    implements ReadHandler {
        public int read(int offset) {
            int bit0 = Galaga.this.driver.input_port_0_r.read(0) >> (offset -= 26624) & 1;
            int bit1 = Galaga.this.driver.input_port_1_r.read(0) >> offset & 1;
            int r = bit0 | bit1 << 1;
            return r;
        }
    }

    public class Galaga_customio_data_w
    implements WriteHandler {
        public void write(int offset, int data) {
            Galaga.customio[offset -= 28672] = data;
            switch (customio_command) {
                case 168: {
                    break;
                }
                case 225: {
                    if (offset != 7) break;
                    coinpercred = customio[1];
                    credpercoin = customio[2];
                }
            }
        }
    }

    public class Galaga_customio_data_r
    implements ReadHandler {
        public int read(int offset) {
            offset -= 28672;
            switch (customio_command) {
                case 113: 
                case 177: {
                    if (offset == 0) {
                        if (mode != 0) {
                            return Galaga.this.readinputport(4);
                        }
                        int in = Galaga.this.readinputport(4);
                        if (coinpercred > 0) {
                            if ((in & 0x70) != 112 && credits < 99) {
                                Galaga.this.md.input[4].write(Galaga.this.md.input[4].read(0) | 0x70);
                                if (++coininserted >= coinpercred) {
                                    credits += credpercoin;
                                    coininserted = 0;
                                }
                            }
                        } else {
                            credits = 100;
                        }
                        if ((in & 4) == 0 && credits >= 1) {
                            --credits;
                        }
                        if ((in & 8) == 0 && credits >= 2) {
                            credits -= 2;
                        }
                        return credits / 10 * 16 + credits % 10;
                    }
                    if (offset == 1) {
                        return Galaga.this.readinputport(2);
                    }
                    if (offset != 2) break;
                    return Galaga.this.readinputport(3);
                }
            }
            return 255;
        }
    }

    public class Galaga_customio_r
    implements ReadHandler {
        public int read(int address) {
            return customio_command;
        }
    }

    public class Galaga_customio_w
    implements WriteHandler {
        public void write(int address, int data) {
            customio_command = data;
            switch (data) {
                case 16: {
                    nmi_timer = false;
                    return;
                }
                case 161: {
                    mode = 1;
                    break;
                }
                case 225: {
                    credits = 0;
                    mode = 0;
                }
            }
            nmi_timer = true;
        }
    }

    public class Galaga_halt_w
    implements WriteHandler {
        public void write(int address, int data) {
            if ((data & 1) != 0) {
                halt23 = false;
                Galaga.this.driver.cpu2.state_HALT = false;
                Galaga.this.driver.cpu3.state_HALT = false;
            } else if (data == 0) {
                halt23 = true;
                Galaga.this.driver.cpu2.reset();
                Galaga.this.driver.cpu3.reset();
                Galaga.this.driver.cpu2.state_HALT = true;
                Galaga.this.driver.cpu3.state_HALT = true;
            }
        }
    }

    public class Galaga_interrupt_1
    implements InterruptHandler {
        public int irq() {
            Galaga.this.video.galaga_vh_interrupt();
            if (interrupt_enable_1) {
                return 0;
            }
            return -1;
        }
    }

    public class Galaga_interrupt_enable_1_w
    implements WriteHandler {
        public void write(int address, int data) {
            interrupt_enable_1 = (data & 1) != 0;
        }
    }

    public class Galaga_interrupt_2
    implements InterruptHandler {
        public int irq() {
            if (interrupt_enable_2) {
                return 0;
            }
            return -1;
        }
    }

    public class Galaga_interrupt_enable_2_w
    implements WriteHandler {
        public void write(int address, int data) {
            interrupt_enable_2 = (data & 1) != 0;
        }
    }

    public class Galaga_interrupt_3
    implements InterruptHandler {
        public int irq() {
            if (interrupt_enable_3) {
                return 1;
            }
            return -1;
        }
    }

    public class Galaga_interrupt_enable_3_w
    implements WriteHandler {
        public void write(int address, int data) {
            interrupt_enable_3 = (data & 1) == 0;
        }
    }

    public class HiScore
    implements WriteHandler {
        private static final int OFFSET_SCORE = 17399;
        private static final int OFFSET_HIGH_SCORE = 33773;
        long counter = 0L;
        WriteHandler vupdate;

        public HiScore(WriteHandler wh) {
            this.vupdate = wh;
        }

        public void write(int address, int value) {
            if (Galaga.this.galaga_sharedram[address] != value) {
                Galaga.this.galaga_sharedram[address] = value;
                if (this.counter >= 446L) {
                    Galaga.this.setHighScore(this.getScore(33773));
                } else {
                    ++this.counter;
                }
                this.vupdate.write(address, value);
            }
        }

        private long getScore(int offset) {
            boolean ZERO_CHAR = false;
            int BLANK_CHAR = 36;
            long score = 0L;
            int i = 0;
            while (i < 7) {
                int c = Galaga.this.galaga_sharedram[offset + i];
                if (c == 0 || c == 36) {
                    c = 0;
                }
                score = (long)((double)score + (double)(c += 0) * Math.pow(10.0, i));
                ++i;
            }
            if (score == 20000L || score > 9999999L) {
                score = 0L;
            }
            return score;
        }
    }
}

