/*
 * Decompiled with CFR 0.152.
 */
package cottage.vidhrdw;

import cottage.mame.MAMEVideo;
import jef.machine.MachineDriver;
import jef.map.InterruptHandler;
import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.video.BitMap;
import jef.video.BitMapImpl;
import jef.video.Vh_convert_color_proms;
import jef.video.Vh_refresh;
import jef.video.Vh_start;
import jef.video.Vh_stop;
import jef.video.VideoEmulator;

public class Galaxian
extends MAMEVideo
implements VideoEmulator,
Vh_refresh,
Vh_start,
Vh_stop,
Vh_convert_color_proms {
    BitMap charLayer;
    int[] REGION_PROMS;
    int[] REGION_CPU;
    boolean[] dirtybuffer = new boolean[1024];
    boolean irqEnabled = false;
    int color_mask;
    int base_video;
    int base_attributes;
    int base_bullets;
    int base_sprites;
    int pisces_gfxbank = 0;
    boolean stars_on = false;
    int stars_scroll = 0;
    int stars_type = 0;
    int total_stars = 0;
    int generator = 0;
    int blink_count = 0;
    int stars_blink = 0;
    int[] star_x = new int[250];
    int[] star_y = new int[250];
    int[] star_code = new int[250];
    static final int MAX_STARS = 250;
    static final int[] map;
    Draw draw_bullets;
    boolean do_draw_bullets = true;

    static {
        int[] nArray = new int[4];
        nArray[1] = 136;
        nArray[2] = 204;
        nArray[3] = 255;
        map = nArray;
    }

    public WriteHandler videoram_w() {
        return new Videoram_w();
    }

    public WriteHandler galaxian_attributes_w() {
        return new Galaxian_attributes_w();
    }

    public WriteHandler galaxian_stars_w() {
        return new Galaxian_stars_w();
    }

    public WriteHandler interrupt_enable_w() {
        return new Interrupt_enable_w();
    }

    public WriteHandler pisces_gfxbank_w() {
        return new Pisces_gfxbank_w();
    }

    public ReadHandler videoram_r() {
        return new Videoram_r();
    }

    public InterruptHandler galaxian_vh_interrupt() {
        return new Galaxian_vh_interrupt();
    }

    public InterruptHandler scramble_vh_interrupt() {
        return new Scramble_vh_interrupt();
    }

    public void init(MachineDriver md) {
        super.init(md);
        this.charLayer = new BitMapImpl(this.backBuffer.getWidth(), this.backBuffer.getHeight());
    }

    public void setRegions(int[] proms, int[] mem) {
        this.REGION_PROMS = proms;
        this.REGION_CPU = mem;
    }

    public boolean galaxian() {
        this.stars_type = 0;
        this.base_video = 20480;
        this.base_attributes = 22528;
        this.base_bullets = 22624;
        this.base_sprites = 22592;
        this.draw_bullets = new galaxian_draw_bullets();
        return true;
    }

    public boolean scramble() {
        this.stars_type = 1;
        this.base_video = 18432;
        this.base_attributes = 20480;
        this.base_bullets = 20576;
        this.base_sprites = 20544;
        this.draw_bullets = new scramble_draw_bullets();
        return true;
    }

    public BitMap video_update() {
        int sy;
        int offs;
        int code;
        int sx;
        int x = 0;
        while (x < 32) {
            int scroll = this.REGION_CPU[this.base_attributes + (x << 1)];
            int color = this.REGION_CPU[this.base_attributes + (x << 1) | 1] & this.color_mask;
            sx = 8 * x;
            int y = 0;
            while (y < 32) {
                int sy2 = 8 * y - scroll & 0xFF;
                code = this.REGION_CPU[this.base_video + (y << 5) | x];
                this.drawgfx(this.backBuffer, 0, code, color, false, false, sx, sy2, -1, 0);
                ++y;
            }
            ++x;
        }
        if (this.do_draw_bullets) {
            offs = 0;
            while (offs < 32) {
                sy = 255 - this.REGION_CPU[this.base_bullets + offs + 1];
                sx = 255 - this.REGION_CPU[this.base_bullets + offs + 3];
                this.draw_bullets.draw(offs, sx, sy);
                offs += 4;
            }
        }
        offs = 28;
        while (offs >= 0) {
            sx = this.REGION_CPU[this.base_sprites + offs + 3] + 1;
            sy = this.REGION_CPU[this.base_sprites + offs];
            int flipx = this.REGION_CPU[this.base_sprites + offs + 1] & 0x40;
            int flipy = this.REGION_CPU[this.base_sprites + offs + 1] & 0x80;
            code = this.REGION_CPU[this.base_sprites + offs + 1] & 0x3F;
            int color = this.REGION_CPU[this.base_sprites + offs + 2] & this.color_mask;
            sy = 240 - sy;
            if (offs < 12) {
                ++sy;
            }
            this.drawgfx(this.backBuffer, 1, code, color, flipx != 0, flipy != 0, sx, sy, 1, 0);
            offs -= 4;
        }
        this.drawStars();
        return this.bitmap;
    }

    public void palette_init() {
        this.color_mask = super.color_granularity(0) == 4 ? 7 : 3;
        int pointer = 0;
        int i = 0;
        while (i < 32) {
            int bit0 = this.REGION_PROMS[pointer] >> 0 & 1;
            int bit1 = this.REGION_PROMS[pointer] >> 1 & 1;
            int bit2 = this.REGION_PROMS[pointer] >> 2 & 1;
            int red = 33 * bit0 + 71 * bit1 + 151 * bit2;
            bit0 = this.REGION_PROMS[pointer] >> 3 & 1;
            bit1 = this.REGION_PROMS[pointer] >> 4 & 1;
            bit2 = this.REGION_PROMS[pointer] >> 5 & 1;
            int green = 33 * bit0 + 71 * bit1 + 151 * bit2;
            bit0 = this.REGION_PROMS[pointer] >> 6 & 1;
            bit1 = this.REGION_PROMS[pointer] >> 7 & 1;
            int blue = 79 * bit0 + 168 * bit1;
            this.palette_set_color(pointer++, red, green, blue);
            ++i;
        }
        i = 0;
        while (i < super.TOTAL_COLORS(0)) {
            if ((i & super.color_granularity(0) - 1) == 0) {
                this.COLOR(0, i, 0);
            }
            ++i;
        }
        i = 0;
        while (i < 64) {
            int bits = i >> 0 & 3;
            this.palette_set_color(pointer, map[bits] << 16);
            bits = i >> 2 & 3;
            this.palette_set_color(pointer, map[bits] << 8);
            bits = i >> 4 & 3;
            this.palette_set_color(pointer, map[bits]);
            ++i;
        }
        this.total_stars = 0;
        this.generator = 0;
        int y = 255;
        while (y >= 0) {
            int x = 511;
            while (x >= 0) {
                int color;
                this.generator <<= 1;
                int bit1 = ~this.generator >> 17 & 1;
                int bit2 = this.generator >> 5 & 1;
                if ((bit1 ^ bit2) != 0) {
                    this.generator |= 1;
                }
                if ((~this.generator >> 16 & 1) != 0 && (this.generator & 0xFF) == 255 && (color = ~(this.generator >> 8) & 0x3F) != 0 && this.total_stars < 250) {
                    this.star_x[this.total_stars] = x;
                    this.star_y[this.total_stars] = y;
                    this.star_code[this.total_stars] = color;
                    ++this.total_stars;
                }
                --x;
            }
            --y;
        }
    }

    private void plot_star(int y, int x, int code) {
        if ((this.backBuffer.getPixel(x, y) & 0xFFFFFF) == 0) {
            this.backBuffer.setPixel(x, y, this.palette_get_color(code));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void drawStars() {
        block15: {
            if (!this.stars_on) break block15;
            switch (this.stars_type) {
                case -1: {
                    break;
                }
                case 0: 
                case 3: {
                    offs = 0;
                    while (offs < this.total_stars) {
                        x = (this.star_x[offs] + this.stars_scroll) % 512 / 2;
                        y = (this.star_y[offs] + (this.stars_scroll + this.star_x[offs]) / 512) % 256;
                        if (!(y < 16 || y > 239 || this.stars_type == 3 && (x < 64 || x >= 176 && x < 216 || x >= 224 && x < 248) || (y & 1 ^ x >> 4 & 1) == 0)) {
                            this.plot_star(x, y, this.star_code[offs]);
                        }
                        ++offs;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    offs = 0;
                    while (offs < this.total_stars) {
                        x = this.star_x[offs] / 2;
                        y = this.star_y[offs];
                        if (y < 16 || y > 239 || this.stars_type == 2 && x >= 128 || (y & 1 ^ x >> 4 & 1) == 0) ** GOTO lbl34
                        switch (this.stars_blink) {
                            case 0: {
                                if ((this.star_code[offs] & 1) == 0) {
                                    break;
                                }
                                ** GOTO lbl32
                            }
                            case 1: {
                                if ((this.star_code[offs] & 4) == 0) {
                                    break;
                                }
                                ** GOTO lbl32
                            }
                            case 2: {
                                if ((this.star_x[offs] & 4) == 0) break;
                            }
lbl32:
                            // 4 sources

                            default: {
                                this.plot_star(x, y, this.star_code[offs]);
                            }
                        }
lbl34:
                        // 5 sources

                        ++offs;
                    }
                    break;
                }
            }
        }
    }

    interface Draw {
        public void draw(int var1, int var2, int var3);
    }

    interface Modifier {
        public int modify(int var1);
    }

    class galaxian_draw_bullets
    implements Draw {
        galaxian_draw_bullets() {
        }

        public void draw(int offs, int x, int y) {
            int i = 0;
            while (i < 4) {
                if (--x >= 0 && x <= 255) {
                    int color = offs == 28 ? 0xFFFF00 : 0xFFFFFF;
                    Galaxian.this.backBuffer.setPixel(239 - y, x, color);
                }
                ++i;
            }
        }
    }

    class scramble_draw_bullets
    implements Draw {
        scramble_draw_bullets() {
        }

        public void draw(int offs, int x, int y) {
            if ((x -= 6) >= 0 && x <= 255) {
                Galaxian.this.backBuffer.setPixel(239 - y, x, 0xFFFF00);
            }
        }
    }

    public class Videoram_w
    implements WriteHandler {
        public void write(int address, int value) {
            Galaxian.this.REGION_CPU[address] = value;
            Galaxian.this.dirtybuffer[address & 0x3FF] = true;
        }
    }

    public class Galaxian_attributes_w
    implements WriteHandler {
        public void write(int address, int data) {
            int offset = address - Galaxian.this.base_attributes;
            if ((address & 1) != 0 && Galaxian.this.REGION_CPU[address] != data) {
                int i = offset / 2;
                while (i < 1024) {
                    Galaxian.this.dirtybuffer[i] = true;
                    i += 32;
                }
            }
            Galaxian.this.REGION_CPU[address] = data;
        }
    }

    public class Galaxian_stars_w
    implements WriteHandler {
        public void write(int address, int data) {
            Galaxian.this.stars_on = data != 0;
            Galaxian.this.stars_scroll = 0;
        }
    }

    public class Interrupt_enable_w
    implements WriteHandler {
        public void write(int address, int value) {
            Galaxian.this.irqEnabled = value != 0;
        }
    }

    public class Pisces_gfxbank_w
    implements WriteHandler {
        public void write(int address, int value) {
            Galaxian.this.pisces_gfxbank = value & 1;
        }
    }

    public class Videoram_r
    implements ReadHandler {
        public int read(int address) {
            return Galaxian.this.REGION_CPU[address - 1024];
        }
    }

    public class Galaxian_vh_interrupt
    implements InterruptHandler {
        public int irq() {
            ++Galaxian.this.stars_scroll;
            return Galaxian.this.irqEnabled ? 1 : -1;
        }
    }

    public class Scramble_vh_interrupt
    implements InterruptHandler {
        public int irq() {
            ++Galaxian.this.blink_count;
            if (Galaxian.this.blink_count >= 45) {
                Galaxian.this.blink_count = 0;
                Galaxian.this.stars_blink = Galaxian.this.stars_blink + 1 & 3;
            }
            return Galaxian.this.irqEnabled ? 1 : -1;
        }
    }
}

