/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import jef.map.ReadHandler;
import jef.map.ReadMap;
import jef.map.ReadRegion;
import jef.map.WriteHandler;
import jef.map.WriteMap;
import jef.map.WriteRegion;

public class MemoryMap
implements ReadMap,
WriteMap {
    int[] rom;
    ReadRegion[] readRegions = new ReadRegion[30];
    WriteRegion[] writeRegions = new WriteRegion[30];
    int nrOfReadRegions;
    int nrOfWriteRegions;
    int banks = 4;

    public MemoryMap(int[] rom) {
        this.rom = rom;
        this.nrOfReadRegions = 0;
    }

    public void setBankAddress(int b, int address) {
    }

    public int getSize() {
        return 0;
    }

    public int[] getMemory() {
        return this.rom;
    }

    public int read(int address) {
        int i = 0;
        while (i < this.nrOfReadRegions) {
            ReadRegion r = this.readRegions[i];
            if (address >= r.from && address <= r.until) {
                return r.handler.read(address - r.from);
            }
            ++i;
        }
        return 0;
    }

    public void write(int address, int data) {
        int i = 0;
        while (i < this.nrOfWriteRegions) {
            WriteRegion w = this.writeRegions[i];
            if (address >= w.from && address <= w.until) {
                w.handler.write(address - w.from, data);
                return;
            }
            ++i;
        }
    }

    public void set(int from, int until, ReadHandler handler) {
        this.readRegions[this.nrOfReadRegions++] = new ReadRegion(from, until, handler);
    }

    public void set(int from, int until, WriteHandler handler) {
        this.writeRegions[this.nrOfWriteRegions++] = new WriteRegion(from, until, handler);
    }

    public void setMR(int from, int until, int readerType) {
        switch (readerType) {
            case 0: 
            case 2: {
                int[] memory = new int[1 + until - from];
                MEMRead rh = new MEMRead(memory);
                this.set(from, until, rh);
                this.readRegions[this.nrOfReadRegions - 1].memory = memory;
                break;
            }
            case 1: {
                MEMRead rh = new MEMRead(this.rom);
                this.set(from, until, rh);
                this.readRegions[this.nrOfReadRegions - 1].memory = this.rom;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                int[] memory = new int[(1 + until - from) * this.banks];
                MEMReadBanked rh = new MEMReadBanked(memory);
                this.set(from, until, rh);
                this.readRegions[this.nrOfReadRegions - 1].memory = memory;
                break;
            }
            default: {
                throw new RuntimeException("MemoryMap: Unknown Reader Type " + readerType);
            }
        }
    }

    public void setMW(int from, int until, int type) {
        switch (type) {
            case 0: {
                int[] mem = this.findMemory(from, until);
                MEMWrite wh = new MEMWrite(mem);
                this.set(from, until, wh);
                break;
            }
            case 1: 
            case 2: {
                this.set(from, until, new ROMwrite());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                int[] mem = this.findMemory(from, until);
                MEMWriteBanked wh = new MEMWriteBanked(mem);
                this.set(from, until, wh);
                break;
            }
            default: {
                throw new RuntimeException("MemoryMap: Unknown Writer Type " + type);
            }
        }
    }

    public int[] findMemory(int from, int until) {
        int i = 0;
        while (i < this.nrOfReadRegions) {
            ReadRegion rr = this.readRegions[i];
            if (rr.from == from && rr.until == until) {
                if (rr.memory == null) {
                    throw new RuntimeException("Memory for write region 0x" + Integer.toHexString(from) + "-0x" + Integer.toHexString(until) + " is null");
                }
                return rr.memory;
            }
            ++i;
        }
        throw new RuntimeException("Could not find memory for write region 0x" + Integer.toHexString(from) + "-0x" + Integer.toHexString(until));
    }

    public class MEMRead
    implements ReadHandler {
        public int[] memory;

        public MEMRead(int[] memory) {
            this.memory = memory;
        }

        public int read(int offset) {
            return this.memory[offset];
        }
    }

    public class MEMWrite
    implements WriteHandler {
        public int[] memory;

        public MEMWrite(int[] memory) {
            this.memory = memory;
        }

        public void write(int offset, int data) {
            this.memory[offset] = data;
        }
    }

    public class ROMwrite
    implements WriteHandler {
        public void write(int address, int value) {
        }
    }

    public class MEMWriteBanked
    implements WriteHandler {
        public int bank_address;
        public int[] memory;

        public MEMWriteBanked(int[] memory) {
            this.memory = memory;
        }

        public void setBankAdr(int adr) {
            this.bank_address = adr;
        }

        public void write(int offset, int value) {
            this.memory[offset + this.bank_address] = value;
        }
    }

    public class MEMReadBanked
    implements ReadHandler {
        public int bank_address;
        public int[] memory;

        public MEMReadBanked(int[] memory) {
            this.memory = memory;
        }

        public void setBankAdr(int adr) {
            this.bank_address = adr;
        }

        public int read(int offset) {
            return this.memory[offset + this.bank_address];
        }
    }
}

