/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import jef.map.ReadHandler;
import jef.map.ReadMap;

public class MemoryReadAddress
implements ReadMap {
    private int size;
    private ReadHandler[] readMap;
    private UndefinedRead defread = new UndefinedRead();
    public ReadHandler RAM;
    public MEMreadBanked[] BANKS = new MEMreadBanked[8];
    public int[] mem;
    static final boolean debug = false;
    private int opcodeOffset = 0;

    public MemoryReadAddress(int[] mem) {
        this.mem = mem;
        this.readMap = new ReadHandler[mem.length];
        this.RAM = new MEMread();
        this.set(0, mem.length - 1, this.defread);
    }

    public void setBankAddress(int bank, int address) {
        this.BANKS[bank - 1].setBankAdr(address);
    }

    public void set(int from, int until, ReadHandler memRead) {
        int i = from;
        while (i <= until) {
            this.readMap[i] = memRead;
            ++i;
        }
    }

    public void setMR(int from, int until, int readerType) {
        ReadHandler rh = null;
        switch (readerType) {
            case 0: 
            case 1: 
            case 2: {
                rh = this.RAM;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                MEMreadBanked mEMreadBanked = new MEMreadBanked(from);
                this.BANKS[readerType - 3] = mEMreadBanked;
                rh = mEMreadBanked;
            }
        }
        int i = from;
        while (i <= until) {
            this.readMap[i] = rh;
            ++i;
        }
    }

    public int getSize() {
        return this.mem.length;
    }

    public int read(int address) {
        return this.readMap[address].read(address);
    }

    public int[] getMemory() {
        return this.mem;
    }

    public class UndefinedRead
    implements ReadHandler {
        public int read(int address) {
            return 0;
        }
    }

    public class MEMread
    implements ReadHandler {
        public int read(int address) {
            return MemoryReadAddress.this.mem[address];
        }
    }

    public class MEMreadBanked
    implements ReadHandler {
        int startArea;
        int bank_address;

        public MEMreadBanked(int startArea) {
            this.startArea = startArea;
        }

        public int read(int address) {
            return MemoryReadAddress.this.mem[address + this.bank_address];
        }

        public void setBankAdr(int adr) {
            this.bank_address = adr - this.startArea;
        }
    }
}

