/*
 * Decompiled with CFR 0.152.
 */
package jef.sound;

import jef.sound.SoundChipEmulator;

public class SoundEmulation {
    SoundChipEmulator[] sc;
    boolean useJavaxSound;
    int samplingRate;
    int bufferLength;

    public void init(SoundChipEmulator[] sc, int samplingRate, int bufferLength, int fps) {
        this.sc = sc;
        this.samplingRate = samplingRate;
        this.bufferLength = bufferLength;
        boolean bl = this.useJavaxSound = !System.getProperty("java.version").startsWith("1.0") && !System.getProperty("java.version").startsWith("1.1") && !System.getProperty("java.version").startsWith("1.2");
        if (this.useJavaxSound) {
            System.out.println("javax.sound support detected.");
        } else {
            System.out.println("sun.audio sound implementation selected.");
            System.out.println("Upgrade your JRE for better sound quality.");
        }
        System.out.println("SoundChip emulators found:" + this.sc.length);
        int i = 0;
        while (i < this.sc.length) {
            this.sc[i].init(this.useJavaxSound, samplingRate, bufferLength, fps);
            ++i;
        }
    }

    public void update() {
        if (this.sc == null) {
            return;
        }
        int i = 0;
        while (i < this.sc.length) {
            this.sc[i].update();
            ++i;
        }
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }
}

