/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip;

import jef.map.ReadHandler;
import jef.map.WriteHandler;
import jef.sound.SoundChip;
import jef.sound.SoundChipEmulator;
import jef.sound.chip.AY8910;
import jef.sound.chip.fm.FMChan;
import jef.sound.chip.fm.FMConstants;
import jef.sound.chip.fm.FMIRQHandler;
import jef.sound.chip.fm.FMOpn;
import jef.sound.chip.fm.FMState;
import jef.sound.chip.fm.FMTimerHandler;
import jef.util.INT32;

public class YM2203
extends SoundChip
implements SoundChipEmulator,
FMConstants {
    private int YM2203NumChips;
    private int baseClock;
    private YM2203_f[] FM2203;
    public static AY8910 SSG;
    private FMTimerHandler timeHandler;
    private FMIRQHandler irqHandler;
    private static int[] TL_TABLE;
    public static INT32[] out_ch;
    public static INT32 pg_in1;
    public static INT32 pg_in2;
    public static INT32 pg_in3;
    public static INT32 pg_in4;
    private static int[] SIN_TABLE;
    public static int[] ENV_CURVE;
    public static int[] DRAR_TABLE;
    private static YM2203_f cur_chip;
    private static FMState State;
    private static FMChan[] cch;
    public static long lfo_amd;

    static {
        out_ch = new INT32[4];
        pg_in1 = new INT32();
        pg_in2 = new INT32();
        pg_in3 = new INT32();
        pg_in4 = new INT32();
        SIN_TABLE = new int[2048];
        ENV_CURVE = new int[12289];
        DRAR_TABLE = new int[4096];
        cch = new FMChan[8];
    }

    public static int SIN_TABLE(int i, int j) {
        return TL_TABLE[SIN_TABLE[i] + j];
    }

    public YM2203(int numChips, int clock, FMTimerHandler th, FMIRQHandler ih) {
        this.YM2203NumChips = numChips;
        this.baseClock = clock;
        this.timeHandler = th;
        this.irqHandler = ih;
        SSG = new AY8910(numChips, clock);
        int i = 0;
        while (i < 4) {
            YM2203.out_ch[i] = new INT32();
            ++i;
        }
    }

    public void init(boolean useJavaxSound, int sampRate, int buflen, int fps) {
        super.init(useJavaxSound, sampRate, buflen, fps);
        SSG.init(useJavaxSound, sampRate, buflen, fps);
        this.YM2203Init(this.YM2203NumChips, this.baseClock, sampRate, this.timeHandler, this.irqHandler);
    }

    private void YM2203Init(int num, int clock, int rate, FMTimerHandler TimerHandler, FMIRQHandler IRQHandler) {
        this.YM2203NumChips = num;
        this.FMInitTable();
        this.FM2203 = new YM2203_f[this.YM2203NumChips];
        int i = 0;
        while (i < this.YM2203NumChips) {
            this.FM2203[i] = new YM2203_f();
            this.FM2203[i].OPN.ST.index = i;
            this.FM2203[i].OPN.type = 0;
            this.FM2203[i].OPN.P_CH = this.FM2203[i].CH;
            this.FM2203[i].OPN.ST.clock = clock;
            this.FM2203[i].OPN.ST.rate = rate;
            this.FM2203[i].OPN.ST.timermodel = 0;
            this.FM2203[i].OPN.ST.Timer_Handler = TimerHandler;
            this.FM2203[i].OPN.ST.IRQ_Handler = IRQHandler;
            SSG.AY8910_init("AY-3-8910", i, this.baseClock, 50, super.getSampFreq(), 0, 0, 0, 0);
            SSG.build_mixer_table(i);
            this.YM2203ResetChip(i);
            ++i;
        }
    }

    private void YM2203ResetChip(int num) {
        FMOpn OPN = this.FM2203[num].OPN;
        OPN.setPris(72, 72, 4);
        SSG.AY8910_reset(OPN.ST.index);
        OPN.ST.FM_IRQMASK_SET(3);
        OPN.OPNWriteMode(39, 48);
        this.reset_channel(OPN.ST, this.FM2203[num].CH, 3);
        int i = 182;
        while (i >= 180) {
            OPN.OPNWriteReg(i, 192);
            --i;
        }
        i = 178;
        while (i >= 48) {
            OPN.OPNWriteReg(i, 0);
            --i;
        }
        i = 38;
        while (i >= 32) {
            OPN.OPNWriteReg(i, 0);
            --i;
        }
    }

    private void reset_channel(FMState ST, FMChan[] CH, int chan) {
        ST.mode = 0L;
        ST.FM_STATUS_RESET(255);
        ST.TA = 0;
        ST.TAC = 0;
        ST.TB = 0;
        ST.TBC = 0;
        int c = 0;
        while (c < chan) {
            CH[c].fc = 0;
            CH[c].PAN = 3;
            int s = 0;
            while (s < 4) {
                CH[c].SLOT[s].SEG = 0;
                CH[c].SLOT[s].eg_next = 0;
                CH[c].SLOT[s].evc = 0x1FFF0000;
                CH[c].SLOT[s].eve = 0x1FFF0001;
                CH[c].SLOT[s].evs = 0;
                ++s;
            }
            ++c;
        }
    }

    public static void setup_connection(FMChan CH) {
        INT32 carrier = out_ch[CH.PAN];
        switch (CH.ALGO) {
            case 0: {
                CH.connect1 = pg_in2;
                CH.connect2 = pg_in3;
                CH.connect3 = pg_in4;
                break;
            }
            case 1: {
                CH.connect1 = pg_in3;
                CH.connect2 = pg_in3;
                CH.connect3 = pg_in4;
                break;
            }
            case 2: {
                CH.connect1 = pg_in4;
                CH.connect2 = pg_in3;
                CH.connect3 = pg_in4;
                break;
            }
            case 3: {
                CH.connect1 = pg_in2;
                CH.connect2 = pg_in4;
                CH.connect3 = pg_in4;
                break;
            }
            case 4: {
                CH.connect1 = pg_in2;
                CH.connect2 = carrier;
                CH.connect3 = pg_in4;
                break;
            }
            case 5: {
                CH.connect1 = null;
                CH.connect2 = carrier;
                CH.connect3 = carrier;
                break;
            }
            case 6: {
                CH.connect1 = pg_in2;
                CH.connect2 = carrier;
                CH.connect3 = carrier;
                break;
            }
            case 7: {
                CH.connect1 = carrier;
                CH.connect2 = carrier;
                CH.connect3 = carrier;
            }
        }
        CH.connect4 = carrier;
    }

    /*
     * Unable to fully structure code
     */
    private void FMInitTable() {
        YM2203.TL_TABLE = new int[12460];
        t = 0;
        while (t < 6230) {
            rate = t >= 3328 ? 0.0 : 6.7108863E7 / Math.pow(10.0, 0.0234375 * (double)t / 20.0);
            YM2203.TL_TABLE[t] = (int)rate;
            YM2203.TL_TABLE[6230 + t] = -YM2203.TL_TABLE[t];
            ++t;
        }
        s = 1;
        while (s <= 512) {
            pom = Math.sin(6.283185307179586 * (double)s / 2048.0);
            j = (int)((pom = 20.0 * this.log10(1.0 / pom)) / 0.0234375);
            if (j > 3328) {
                j = 3328;
            }
            v0 = j;
            YM2203.SIN_TABLE[1024 - s] = v0;
            YM2203.SIN_TABLE[s] = v0;
            v1 = 6230 + j;
            YM2203.SIN_TABLE[2048 - s] = v1;
            YM2203.SIN_TABLE[1024 + s] = v1;
            ++s;
        }
        YM2203.SIN_TABLE[1024] = 3328;
        YM2203.SIN_TABLE[0] = 3328;
        i = 0;
        while (i < 4096) {
            pom = Math.pow((double)(4095 - i) / 4096.0, 8.0) * 4096.0;
            YM2203.ENV_CURVE[i] = (int)pom;
            YM2203.ENV_CURVE[4096 + i] = i;
            YM2203.ENV_CURVE[8192 + i] = 4095 - i;
            ++i;
        }
        YM2203.ENV_CURVE[8191] = 4095;
        j = 4095;
        i = 0;
        ** GOTO lbl42
        {
            --j;
            do {
                if (j != 0 && YM2203.ENV_CURVE[j] < i) continue block3;
                YM2203.DRAR_TABLE[i] = j << 16;
                ++i;
lbl42:
                // 2 sources

            } while (i < 4096);
        }
    }

    private void YM2203UpdateOne(int num, int length) {
        YM2203_f F2203 = this.FM2203[num];
        FMOpn OPN = this.FM2203[num].OPN;
        cur_chip = F2203;
        State = F2203.OPN.ST;
        YM2203.cch[0] = F2203.CH[0];
        YM2203.cch[1] = F2203.CH[1];
        YM2203.cch[2] = F2203.CH[2];
        cch[0].CALC_FCOUNT();
        cch[1].CALC_FCOUNT();
        if ((YM2203.State.mode & 0xC0L) != 0L) {
            if (YM2203.cch[2].SLOT[0].Incr == -1L) {
                YM2203.cch[2].SLOT[0].CALC_FCSLOT(OPN.SL3.fc[1], OPN.SL3.kcode[1]);
                YM2203.cch[2].SLOT[2].CALC_FCSLOT(OPN.SL3.fc[2], OPN.SL3.kcode[2]);
                YM2203.cch[2].SLOT[1].CALC_FCSLOT(OPN.SL3.fc[0], OPN.SL3.kcode[0]);
                YM2203.cch[2].SLOT[3].CALC_FCSLOT(YM2203.cch[2].fc, YM2203.cch[2].kcode);
            }
        } else {
            cch[2].CALC_FCOUNT();
        }
        int i = 0;
        while (i < length) {
            YM2203.out_ch[3].value = 0;
            int _ch = 0;
            while (_ch <= 2) {
                cch[_ch].FM_CALC_CH();
                ++_ch;
            }
            out_ch[3].limit(-268435456, 0xFFFFFFF);
            this.writeLinBuffer(i, this.readLinBuffer(i) + (YM2203.out_ch[3].value >> 13) / this.YM2203NumChips / 2);
            State.INTERNAL_TIMER_A(cch[2]);
            ++i;
        }
        State.INTERNAL_TIMER_B(length);
    }

    int YM2203Write(int n, int a, int v) {
        FMOpn OPN = this.FM2203[n].OPN;
        if ((a & 1) == 0) {
            OPN.ST.address = v & 0xFF;
            if (v < 16) {
                SSG.AY8910Write(n, 0, v);
            }
            switch (OPN.ST.address) {
                case 45: {
                    OPN.setPris(72, 72, 4);
                    break;
                }
                case 46: {
                    OPN.setPris(36, 36, 2);
                    break;
                }
                case 47: {
                    OPN.setPris(24, 24, 1);
                }
            }
        } else {
            int addr = OPN.ST.address;
            switch (addr & 0xF0) {
                case 0: {
                    SSG.AY8910Write(n, a, v);
                    break;
                }
                case 32: {
                    this.YM2203UpdateReq(n);
                    OPN.OPNWriteMode(addr, v);
                    break;
                }
                default: {
                    this.YM2203UpdateReq(n);
                    OPN.OPNWriteReg(addr, v);
                }
            }
        }
        return OPN.ST.irq;
    }

    int YM2203Read(int n, int a) {
        YM2203_f F2203 = this.FM2203[n];
        int addr = F2203.OPN.ST.address;
        int ret = 0;
        if ((a & 1) == 0) {
            ret = F2203.OPN.ST.status;
        } else if (addr < 16) {
            ret = SSG.AY8910Read(n);
        }
        return ret;
    }

    private void YM2203UpdateReq(int n) {
    }

    private double log10(double n) {
        return Math.log(n) / Math.log(10.0);
    }

    public void writeBuffer() {
        SSG.writeBuffer();
        SSG.update();
        this.clearBuffer();
        int length = super.getBufferLength();
        int i = 0;
        while (i < this.YM2203NumChips) {
            this.YM2203UpdateOne(i, length);
            ++i;
        }
    }

    public ReadHandler ym2203_status_port_0_r() {
        return new YM2203_status_port_r(0);
    }

    public ReadHandler ym2203_status_port_1_r() {
        return new YM2203_status_port_r(1);
    }

    public ReadHandler ym2203_status_port_2_r() {
        return new YM2203_status_port_r(2);
    }

    public ReadHandler ym2203_status_port_3_r() {
        return new YM2203_status_port_r(3);
    }

    public ReadHandler ym2203_status_port_4_r() {
        return new YM2203_status_port_r(4);
    }

    public ReadHandler ym2203_read_port_0_r() {
        return new YM2203_read_port_r(0);
    }

    public ReadHandler ym2203_read_port_1_r() {
        return new YM2203_read_port_r(1);
    }

    public ReadHandler ym2203_read_port_2_r() {
        return new YM2203_read_port_r(2);
    }

    public ReadHandler ym2203_read_port_3_r() {
        return new YM2203_read_port_r(3);
    }

    public ReadHandler ym2203_read_port_4_r() {
        return new YM2203_read_port_r(4);
    }

    public WriteHandler ym2203_control_port_0_w() {
        return new YM2203_control_port_w(0);
    }

    public WriteHandler ym2203_control_port_1_w() {
        return new YM2203_control_port_w(1);
    }

    public WriteHandler ym2203_control_port_2_w() {
        return new YM2203_control_port_w(2);
    }

    public WriteHandler ym2203_control_port_3_w() {
        return new YM2203_control_port_w(3);
    }

    public WriteHandler ym2203_control_port_4_w() {
        return new YM2203_control_port_w(4);
    }

    public WriteHandler ym2203_write_port_0_w() {
        return new YM2203_write_port_w(0);
    }

    public WriteHandler ym2203_write_port_1_w() {
        return new YM2203_write_port_w(1);
    }

    public WriteHandler ym2203_write_port_2_w() {
        return new YM2203_write_port_w(2);
    }

    public WriteHandler ym2203_write_port_3_w() {
        return new YM2203_write_port_w(3);
    }

    public WriteHandler ym2203_write_port_4_w() {
        return new YM2203_write_port_w(4);
    }

    private final class YM2203_f {
        FMOpn OPN;
        FMChan[] CH;

        public YM2203_f() {
            this.OPN = new FMOpn(YM2203.this.irqHandler);
            this.CH = new FMChan[3];
            int i = 0;
            while (i < 3) {
                this.CH[i] = new FMChan();
                ++i;
            }
        }
    }

    public class YM2203_status_port_r
    implements ReadHandler {
        int c;

        public YM2203_status_port_r(int context) {
            this.c = context;
        }

        public int read(int address) {
            int i = YM2203.this.YM2203Read(this.c, 0);
            return i;
        }
    }

    public class YM2203_read_port_r
    implements ReadHandler {
        int c;

        public YM2203_read_port_r(int context) {
            this.c = context;
        }

        public int read(int address) {
            int i = YM2203.this.YM2203Read(this.c, 1);
            return i;
        }
    }

    public class YM2203_control_port_w
    implements WriteHandler {
        int c;

        public YM2203_control_port_w(int context) {
            this.c = context;
        }

        public void write(int address, int data) {
            YM2203.this.YM2203Write(this.c, 0, data);
        }
    }

    public class YM2203_write_port_w
    implements WriteHandler {
        int c;

        public YM2203_write_port_w(int context) {
            this.c = context;
        }

        public void write(int address, int data) {
            YM2203.this.YM2203Write(this.c, 1, data);
        }
    }
}

