/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip.fm;

import jef.sound.chip.YM2203;
import jef.sound.chip.fm.FM3Slot;
import jef.sound.chip.fm.FMChan;
import jef.sound.chip.fm.FMConstants;
import jef.sound.chip.fm.FMIRQHandler;
import jef.sound.chip.fm.FMSlot;
import jef.sound.chip.fm.FMState;

public class FMOpn
implements FMConstants {
    public static final int TYPE_YM2203 = 0;
    private static final double[] freq_table = new double[]{3.98, 5.56, 6.02, 6.37, 6.88, 9.63, 48.1, 72.2};
    public int type;
    public FMState ST;
    public FM3Slot SL3 = new FM3Slot();
    public FMChan[] P_CH;
    public long[] FN_TABLE = new long[2048];
    public long LFOCnt;
    public long LFOIncr;
    public long[] LFO_FREQ = new long[8];
    public int[] LFO_wave = new int[512];
    static final int[] SL_TABLE = new int[]{FMOpn.SC(0.0), FMOpn.SC(1.0), FMOpn.SC(2.0), FMOpn.SC(3.0), FMOpn.SC(4.0), FMOpn.SC(5.0), FMOpn.SC(6.0), FMOpn.SC(7.0), FMOpn.SC(8.0), FMOpn.SC(9.0), FMOpn.SC(10.0), FMOpn.SC(11.0), FMOpn.SC(12.0), FMOpn.SC(13.0), FMOpn.SC(14.0), FMOpn.SC(31.0)};
    private static final int[] MUL_TABLE = new int[]{FMOpn.ML(0.5), FMOpn.ML(1.0), FMOpn.ML(2.0), FMOpn.ML(3.0), FMOpn.ML(4.0), FMOpn.ML(5.0), FMOpn.ML(6.0), FMOpn.ML(7.0), FMOpn.ML(8.0), FMOpn.ML(9.0), FMOpn.ML(10.0), FMOpn.ML(11.0), FMOpn.ML(12.0), FMOpn.ML(13.0), FMOpn.ML(14.0), FMOpn.ML(15.0), FMOpn.ML(0.71), FMOpn.ML(1.41), FMOpn.ML(2.82), FMOpn.ML(4.24), FMOpn.ML(5.65), FMOpn.ML(7.07), FMOpn.ML(8.46), FMOpn.ML(9.89), FMOpn.ML(11.3), FMOpn.ML(12.72), FMOpn.ML(14.1), FMOpn.ML(15.55), FMOpn.ML(16.96), FMOpn.ML(18.37), FMOpn.ML(19.78), FMOpn.ML(21.2), FMOpn.ML(0.78), FMOpn.ML(1.57), FMOpn.ML(3.14), FMOpn.ML(4.71), FMOpn.ML(6.28), FMOpn.ML(7.85), FMOpn.ML(9.42), FMOpn.ML(10.99), FMOpn.ML(12.56), FMOpn.ML(14.13), FMOpn.ML(15.7), FMOpn.ML(17.27), FMOpn.ML(18.84), FMOpn.ML(20.41), FMOpn.ML(21.98), FMOpn.ML(23.55), FMOpn.ML(0.87), FMOpn.ML(1.73), FMOpn.ML(3.46), FMOpn.ML(5.19), FMOpn.ML(6.92), FMOpn.ML(8.65), FMOpn.ML(10.38), FMOpn.ML(12.11), FMOpn.ML(13.84), FMOpn.ML(15.57), FMOpn.ML(17.3), FMOpn.ML(19.03), FMOpn.ML(20.76), FMOpn.ML(22.49), FMOpn.ML(24.22), FMOpn.ML(25.95)};
    private static final int[] OPN_FKTABLE;
    private static final int[] OPN_DTTABLE;
    private static final int[] RATE_0;

    static {
        int[] nArray = new int[16];
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        OPN_FKTABLE = nArray;
        int[] nArray2 = new int[128];
        nArray2[36] = 1;
        nArray2[37] = 1;
        nArray2[38] = 1;
        nArray2[39] = 1;
        nArray2[40] = 1;
        nArray2[41] = 1;
        nArray2[42] = 1;
        nArray2[43] = 1;
        nArray2[44] = 2;
        nArray2[45] = 2;
        nArray2[46] = 2;
        nArray2[47] = 2;
        nArray2[48] = 2;
        nArray2[49] = 3;
        nArray2[50] = 3;
        nArray2[51] = 3;
        nArray2[52] = 4;
        nArray2[53] = 4;
        nArray2[54] = 4;
        nArray2[55] = 5;
        nArray2[56] = 5;
        nArray2[57] = 6;
        nArray2[58] = 6;
        nArray2[59] = 7;
        nArray2[60] = 8;
        nArray2[61] = 8;
        nArray2[62] = 8;
        nArray2[63] = 8;
        nArray2[64] = 1;
        nArray2[65] = 1;
        nArray2[66] = 1;
        nArray2[67] = 1;
        nArray2[68] = 2;
        nArray2[69] = 2;
        nArray2[70] = 2;
        nArray2[71] = 2;
        nArray2[72] = 2;
        nArray2[73] = 3;
        nArray2[74] = 3;
        nArray2[75] = 3;
        nArray2[76] = 4;
        nArray2[77] = 4;
        nArray2[78] = 4;
        nArray2[79] = 5;
        nArray2[80] = 5;
        nArray2[81] = 6;
        nArray2[82] = 6;
        nArray2[83] = 7;
        nArray2[84] = 8;
        nArray2[85] = 8;
        nArray2[86] = 9;
        nArray2[87] = 10;
        nArray2[88] = 11;
        nArray2[89] = 12;
        nArray2[90] = 13;
        nArray2[91] = 14;
        nArray2[92] = 16;
        nArray2[93] = 16;
        nArray2[94] = 16;
        nArray2[95] = 16;
        nArray2[96] = 2;
        nArray2[97] = 2;
        nArray2[98] = 2;
        nArray2[99] = 2;
        nArray2[100] = 2;
        nArray2[101] = 3;
        nArray2[102] = 3;
        nArray2[103] = 3;
        nArray2[104] = 4;
        nArray2[105] = 4;
        nArray2[106] = 4;
        nArray2[107] = 5;
        nArray2[108] = 5;
        nArray2[109] = 6;
        nArray2[110] = 6;
        nArray2[111] = 7;
        nArray2[112] = 8;
        nArray2[113] = 8;
        nArray2[114] = 9;
        nArray2[115] = 10;
        nArray2[116] = 11;
        nArray2[117] = 12;
        nArray2[118] = 13;
        nArray2[119] = 14;
        nArray2[120] = 16;
        nArray2[121] = 17;
        nArray2[122] = 19;
        nArray2[123] = 20;
        nArray2[124] = 22;
        nArray2[125] = 22;
        nArray2[126] = 22;
        nArray2[127] = 22;
        OPN_DTTABLE = nArray2;
        RATE_0 = new int[32];
    }

    private static final int SC(double db) {
        return (int)(db * 8388608.0 + 2.68435456E8);
    }

    private static final int ML(double d) {
        return (int)(d * 2.0);
    }

    public FMOpn(FMIRQHandler ih) {
        this.ST = new FMState(ih);
    }

    public void OPNWriteMode(int r, int v) {
        switch (r) {
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 36: {
                this.ST.TA = this.ST.TA & 3 | v << 2;
                break;
            }
            case 37: {
                this.ST.TA = this.ST.TA & 0x3FC | v & 3;
                break;
            }
            case 38: {
                this.ST.TB = v;
                break;
            }
            case 39: {
                this.ST.FMSetMode(this.ST.index, v);
                break;
            }
            case 40: {
                int c = v & 3;
                if (c == 3) break;
                if ((v & 4) != 0 && (this.type & 8) != 0) {
                    c += 3;
                }
                FMChan CH = this.P_CH[c];
                if (c == 2 && (this.ST.mode & 0x80L) != 0L) break;
                if ((v & 0x10) != 0) {
                    CH.FM_KEYON(0);
                } else {
                    CH.FM_KEYOFF(0);
                }
                if ((v & 0x20) != 0) {
                    CH.FM_KEYON(2);
                } else {
                    CH.FM_KEYOFF(2);
                }
                if ((v & 0x40) != 0) {
                    CH.FM_KEYON(1);
                } else {
                    CH.FM_KEYOFF(1);
                }
                if ((v & 0x80) != 0) {
                    CH.FM_KEYON(3);
                    break;
                }
                CH.FM_KEYOFF(3);
            }
        }
    }

    private void set_det_mul(FMState ST, FMChan CH, FMSlot SLOT, int v) {
        SLOT.mul = MUL_TABLE[v & 0xF];
        SLOT.DT = ST.DT_TABLE[v >> 4 & 7];
        CH.SLOT[0].Incr = -1L;
    }

    private void set_tl(FMChan CH, FMSlot SLOT, int v, boolean csmflag) {
        v &= 0x7F;
        v = v << 7 | v;
        SLOT.TL = v * 4096 >> 14;
        if (!csmflag) {
            SLOT.TLL = SLOT.TL;
        }
    }

    private void set_ar_ksr(FMChan CH, FMSlot SLOT, int v, int[] ar_table) {
        SLOT.KSR = 3 - (v >> 6);
        if ((v &= 0x1F) != 0) {
            SLOT.AR = ar_table;
            SLOT.AR_pointer = v << 1;
        } else {
            SLOT.AR = RATE_0;
            SLOT.AR_pointer = 0;
        }
        SLOT.evsa = SLOT.AR[SLOT.ksr];
        if (SLOT.eg_next == 3) {
            SLOT.evs = SLOT.evsa;
        }
        CH.SLOT[0].Incr = -1L;
    }

    private void set_dr(FMSlot SLOT, int v, int[] dr_table) {
        if ((v &= 0x1F) != 0) {
            SLOT.DR = dr_table;
            SLOT.DR_pointer = v << 1;
        } else {
            SLOT.DR = RATE_0;
            SLOT.DR_pointer = 0;
        }
        SLOT.evsd = SLOT.DR[SLOT.ksr];
        if (SLOT.eg_next == 2) {
            SLOT.evs = SLOT.evsd;
        }
    }

    private void set_sr(FMSlot SLOT, int v, int[] dr_table) {
        if ((v &= 0x1F) != 0) {
            SLOT.SR = dr_table;
            SLOT.SR_pointer = v << 1;
        } else {
            SLOT.SR = RATE_0;
            SLOT.SR_pointer = 0;
        }
        SLOT.evss = SLOT.SR[SLOT.ksr];
        if (SLOT.eg_next == 1) {
            SLOT.evs = SLOT.evss;
        }
    }

    private void set_sl_rr(FMSlot SLOT, int v, int[] dr_table) {
        SLOT.SL = SL_TABLE[v >> 4];
        SLOT.RR_pointer = (v & 0xF) << 2 | 2;
        SLOT.RR = dr_table;
        SLOT.evsr = SLOT.RR[SLOT.ksr];
        if (SLOT.eg_next == 0) {
            SLOT.evs = SLOT.evsr;
        }
    }

    private int OPN_CHAN(int N) {
        return N & 3;
    }

    private int OPN_SLOT(int N) {
        return N >> 2 & 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void OPNWriteReg(int r, int v) {
        int c = this.OPN_CHAN(r);
        if (c == 3) {
            return;
        }
        if (r >= 256) {
            c += 3;
        }
        FMChan CH = this.P_CH[c];
        FMSlot SLOT = CH.SLOT[this.OPN_SLOT(r)];
        block0 : switch (r & 0xF0) {
            case 48: {
                this.set_det_mul(this.ST, CH, SLOT, v);
                return;
            }
            case 64: {
                this.set_tl(CH, SLOT, v, c == 2 && (this.ST.mode & 0x80L) != 0L);
                return;
            }
            case 80: {
                this.set_ar_ksr(CH, SLOT, v, this.ST.AR_TABLE);
                return;
            }
            case 96: {
                this.set_dr(SLOT, v, this.ST.DR_TABLE);
                return;
            }
            case 112: {
                this.set_sr(SLOT, v, this.ST.DR_TABLE);
                return;
            }
            case 128: {
                this.set_sl_rr(SLOT, v, this.ST.DR_TABLE);
                return;
            }
            case 144: {
                SLOT.SEG = v & 0xF;
                return;
            }
            case 160: {
                switch (this.OPN_SLOT(r)) {
                    case 0: {
                        int fn = ((CH.fn_h & 7) << 8) + v;
                        int blk = CH.fn_h >> 3;
                        CH.kcode = blk << 2 | OPN_FKTABLE[fn >> 7];
                        CH.fc = (int)(this.FN_TABLE[fn] >> 7 - blk);
                        CH.SLOT[0].Incr = -1L;
                        return;
                    }
                    case 1: {
                        CH.fn_h = v & 0x3F;
                        return;
                    }
                    case 2: {
                        if (r >= 256) break;
                        int fn = ((this.SL3.fn_h[c] & 7) << 8) + v;
                        int blk = this.SL3.fn_h[c] >> 3;
                        this.SL3.kcode[c] = blk << 2 | OPN_FKTABLE[fn >> 7];
                        this.SL3.fc[c] = this.FN_TABLE[fn] >> 7 - blk;
                        this.P_CH[2].SLOT[0].Incr = -1L;
                        return;
                    }
                    case 3: {
                        if (r >= 256) break;
                        this.SL3.fn_h[c] = v & 0x3F;
                    }
                }
                return;
            }
            case 176: {
                switch (this.OPN_SLOT(r)) {
                    case 0: {
                        int feedback = v >> 3 & 7;
                        CH.ALGO = v & 7;
                        CH.FB = feedback != 0 ? 9 - feedback : 0;
                        YM2203.setup_connection(CH);
                        break block0;
                    }
                    case 1: {
                        if ((this.type & 4) == 0) return;
                        CH.PAN = v >> 6 & 3;
                        YM2203.setup_connection(CH);
                    }
                }
            }
        }
    }

    public void setPris(int pris, int TimerPris, int SSGpris) {
        this.ST.freqbase = this.ST.rate != 0 ? (double)this.ST.clock / (double)this.ST.rate / (double)pris : 0.0;
        this.ST.TimerBase = 1.0 / ((double)this.ST.clock / (double)TimerPris);
        if (SSGpris != 0) {
            YM2203.SSG.AY8910_set_clock(this.ST.index, this.ST.clock * 2 / SSGpris);
        }
        this.ST.init_timetables(OPN_DTTABLE, 399128, 5514396);
        int i = 0;
        while (i < 2048) {
            this.FN_TABLE[i] = (long)((double)i * this.ST.freqbase * 8.0 * 128.0 / 2.0);
            ++i;
        }
    }
}

