/*
 * Decompiled with CFR 0.152.
 */
package jef.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jef.video.Console;

public final class RomLoader {
    static final String FILE_SEPERATOR = "/";
    private final int MAXLIST = 256;
    private int[][] romlist_useram = new int[256][];
    private String[] romlist_names = new String[256];
    private int[] romlist_storeat = new int[256];
    private int[] romlist_length = new int[256];
    private int[] romlist_orglength = new int[256];
    private int[] romlist_crc = new int[256];
    private boolean[] romlist_loaded = new boolean[256];
    private boolean[] romlist_cont = new boolean[256];
    private int[] romlist_skip = new int[256];
    private int[][] romlist_usetmp = new int[256][];
    private boolean[] romlist_invert = new boolean[256];
    private int romlist_index = 0;
    private int load_count = 0;
    private boolean noLoad = false;
    private boolean invert = false;
    private int[] ram;
    private String zip;
    private String parent_zip = null;
    private String sub = "";

    public final void noLoading() {
        this.noLoad = true;
    }

    public final void setMemory(int[] mem) {
        this.ram = mem;
    }

    public final void setInvert(boolean inv) {
        this.invert = inv;
    }

    public final void setZip(String zip) {
        this.zip = "roms/" + zip + ".zip";
    }

    public final void setParentZip(String parent) {
        this.parent_zip = parent == null ? null : "roms/" + parent + ".zip";
    }

    public final void setZip(String zip, String sub) {
        this.zip = "roms/" + zip + ".zip";
        this.sub = String.valueOf(sub) + FILE_SEPERATOR;
    }

    public final void loadROM(String FName, int StoreAt, int Length) {
        this.loadROM(FName, StoreAt, Length, 0);
    }

    public final void loadROM(String FName, int StoreAt, int Length, int crc) {
        this.romlist_useram[this.romlist_index] = this.ram;
        String name = String.valueOf(this.sub) + FName;
        this.romlist_names[this.romlist_index] = name.toLowerCase();
        this.romlist_storeat[this.romlist_index] = StoreAt;
        this.romlist_length[this.romlist_index] = Length;
        this.romlist_orglength[this.romlist_index] = Length;
        this.romlist_crc[this.romlist_index] = crc;
        this.romlist_loaded[this.romlist_index] = false;
        this.romlist_cont[this.romlist_index] = false;
        this.romlist_usetmp[this.romlist_index] = null;
        this.romlist_skip[this.romlist_index] = 1;
        this.romlist_invert[this.romlist_index] = this.invert;
        ++this.romlist_index;
    }

    public final void loadROM(String FName, int StoreAt, int Length, int crc, int skip) {
        this.romlist_useram[this.romlist_index] = this.ram;
        String name = String.valueOf(this.sub) + FName;
        this.romlist_names[this.romlist_index] = name.toLowerCase();
        this.romlist_storeat[this.romlist_index] = StoreAt;
        this.romlist_length[this.romlist_index] = Length;
        this.romlist_orglength[this.romlist_index] = Length;
        this.romlist_crc[this.romlist_index] = crc;
        this.romlist_loaded[this.romlist_index] = false;
        this.romlist_cont[this.romlist_index] = false;
        this.romlist_usetmp[this.romlist_index] = null;
        this.romlist_skip[this.romlist_index] = 1 + skip;
        this.romlist_invert[this.romlist_index] = this.invert;
        ++this.romlist_index;
    }

    public final void continueROM(int StoreAt, int Length) {
        this.romlist_useram[this.romlist_index] = this.ram;
        this.romlist_names[this.romlist_index] = null;
        this.romlist_storeat[this.romlist_index] = StoreAt;
        this.romlist_length[this.romlist_index] = Length;
        this.romlist_orglength[this.romlist_index] = Length;
        this.romlist_crc[this.romlist_index] = 0;
        this.romlist_loaded[this.romlist_index] = true;
        this.romlist_cont[this.romlist_index] = true;
        this.romlist_usetmp[this.romlist_index] = null;
        this.romlist_invert[this.romlist_index] = this.invert;
        int i = this.romlist_index - 1;
        while (this.romlist_cont[i]) {
            --i;
        }
        int n = i;
        this.romlist_length[n] = this.romlist_length[n] + Length;
        ++this.romlist_index;
        ++this.load_count;
    }

    private final void storeMemory() {
        int i = 0;
        while (i < this.romlist_index) {
            int j;
            int ofs;
            if (i + 1 < this.romlist_index && this.romlist_cont[i + 1]) {
                int org = i;
                ofs = this.romlist_storeat[i];
                if (this.romlist_invert[i]) {
                    j = 0;
                    while (j < this.romlist_orglength[i]) {
                        this.romlist_useram[i][ofs++] = (this.romlist_usetmp[i][j] ^ 0xFF) & 0xFF;
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < this.romlist_orglength[i]) {
                        this.romlist_useram[i][ofs++] = this.romlist_usetmp[i][j];
                        ++j;
                    }
                }
                int cur_ofs = this.romlist_orglength[i];
                ++i;
                while (i < this.romlist_index && this.romlist_cont[i]) {
                    ofs = this.romlist_storeat[i];
                    if (this.romlist_invert[org]) {
                        j = 0;
                        while (j < this.romlist_length[i]) {
                            this.romlist_useram[i][ofs++] = (this.romlist_usetmp[org][cur_ofs++] ^ 0xFF) & 0xFF;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.romlist_length[i]) {
                            this.romlist_useram[i][ofs++] = this.romlist_usetmp[org][cur_ofs++];
                            ++j;
                        }
                    }
                    ++i;
                }
                this.romlist_usetmp[org] = null;
                continue;
            }
            ofs = this.romlist_storeat[i];
            int skip = this.romlist_skip[i];
            if (this.romlist_invert[i]) {
                j = 0;
                while (j < this.romlist_length[i]) {
                    this.romlist_useram[i][ofs] = (this.romlist_usetmp[i][j] ^ 0xFF) & 0xFF;
                    ofs += skip;
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.romlist_length[i]) {
                    this.romlist_useram[i][ofs] = this.romlist_usetmp[i][j];
                    ofs += skip;
                    ++j;
                }
            }
            this.romlist_usetmp[i] = null;
            ++i;
        }
    }

    public final void loadZip(URL rootURL) {
        if (this.noLoad) {
            return;
        }
        if (rootURL == null) {
            this.loadFromDisk();
        } else {
            if (this.parent_zip != null) {
                this.loadFromWeb(rootURL, true);
            }
            this.loadFromWeb(rootURL, false);
            this.storeMemory();
        }
        this.romlist_index = 0;
        this.load_count = 0;
    }

    private final void loadFromDisk() {
        try {
            int i = 0;
            while (i < this.romlist_index) {
                System.out.print("Loading " + this.romlist_names[i] + "(" + Integer.toHexString(this.romlist_crc[i]) + ")...");
                DataInputStream in = new DataInputStream(new FileInputStream(this.romlist_names[i]));
                try {
                    int ofs = this.romlist_storeat[i];
                    while (true) {
                        this.romlist_useram[i][ofs++] = in.readUnsignedByte();
                    }
                }
                catch (EOFException e) {
                    System.out.println("");
                    System.out.println("ERROR loading ROM:");
                    System.out.println(e);
                    System.exit(0);
                    in.close();
                    in = null;
                    System.out.println("Ok!");
                    ++i;
                }
            }
        }
        catch (IOException e) {
            System.out.println("");
            System.out.println("ERROR loading ROM:");
            System.out.println(e);
            System.exit(0);
        }
    }

    private final void loadFromWeb(URL baseURL, boolean bParent) {
        ZipInputStream zis;
        InputStream is;
        block30: {
            URL romURL = null;
            is = null;
            zis = null;
            try {
                romURL = bParent ? new URL(baseURL, this.parent_zip) : new URL(baseURL, this.zip);
                is = romURL.openStream();
                break block30;
            }
            catch (Exception e) {
                System.out.println("ERROR loading ROM: error opening stream");
                System.out.println(e);
            }
            while (true) {
                // Infinite loop
            }
        }
        if (is == null) {
            System.out.println("ERROR loading ROM: null InputStream");
            while (true) {
                // Infinite loop
            }
        }
        zis = new ZipInputStream(is);
        ZipEntry ze = null;
        block14: while (true) {
            int i;
            block31: {
                try {
                    ze = zis.getNextEntry();
                    break block31;
                }
                catch (Exception e) {
                    System.out.println("ERROR loading ROM: error getting zip entry");
                    System.out.println(e);
                }
                while (true) {
                    // Infinite loop
                }
            }
            if (ze == null) {
                if (this.load_count != this.romlist_index && !bParent) {
                    i = 0;
                    while (i < this.romlist_index) {
                        if (!this.romlist_loaded[i]) {
                            System.out.println(String.valueOf(this.romlist_names[i]) + "(" + Integer.toHexString(this.romlist_crc[i]) + ") not found !");
                            try {
                                Console.TXT[Console.cTXT] = String.valueOf(this.romlist_names[i]) + "(" + Integer.toHexString(this.romlist_crc[i]) + ") not found !";
                                Console.update();
                                Console.cTXT = (Console.cTXT + 1) % Console.nTXT;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    while (true) {
                        // Infinite loop
                    }
                }
                return;
            }
            String zipName = ze.getName().toLowerCase();
            i = 0;
            while (true) {
                if (i >= this.romlist_index) continue block14;
                if (!this.romlist_loaded[i] && (this.romlist_crc[i] == 0 || Long.toHexString(ze.getCrc()).equals(Integer.toHexString(this.romlist_crc[i])))) {
                    byte[] buffer;
                    int length;
                    block32: {
                        if (this.romlist_crc[i] == 0) {
                            System.out.print("Loading " + this.romlist_names[i] + "(NO GOOD DUMP KNOWN)...");
                        } else {
                            System.out.print("Loading " + this.romlist_names[i] + "(" + Integer.toHexString(this.romlist_crc[i]) + ")...");
                        }
                        try {
                            Console.TXT[Console.cTXT] = "Loading " + this.romlist_names[i] + "...";
                            Console.update();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        length = this.romlist_length[i];
                        buffer = new byte[length];
                        int nbytes = length;
                        int toreadbytes = length;
                        try {
                            while (toreadbytes > 0) {
                                int nreadbytes = zis.read(buffer, nbytes - toreadbytes, toreadbytes);
                                if (nreadbytes != -1) {
                                    toreadbytes -= nreadbytes;
                                    continue;
                                }
                                break block32;
                            }
                            break block32;
                        }
                        catch (Exception ignored) {
                            System.out.println("ERROR loading ROM: invalid ZIP file");
                        }
                        while (true) {
                            // Infinite loop
                        }
                    }
                    this.romlist_usetmp[i] = new int[length];
                    int j = 0;
                    while (j < length) {
                        this.romlist_usetmp[i][j] = buffer[j] + 256 & 0xFF;
                        ++j;
                    }
                    buffer = null;
                    this.romlist_loaded[i] = true;
                    ++this.load_count;
                    System.out.println("Ok!");
                    try {
                        int n = Console.cTXT;
                        Console.TXT[n] = String.valueOf(Console.TXT[n]) + "Ok!";
                        Console.update();
                        Console.cTXT = (Console.cTXT + 1) % Console.nTXT;
                    }
                    catch (Exception exception) {}
                    continue block14;
                }
                ++i;
            }
            break;
        }
    }
}

