#include "type.h"

// Define this if compiling for a BIG ENDIAN system like PPC (do NOT move!)
//#define MSB_FIRST

#ifdef MSB_FIRST
#define SWAP16(val) ({ UINT16 x = val; x = (x << 8) | (x >> 8); x; })
#define SWAP32(val) ({ UINT32 x = val; x = (x << 24) | ((x << 8) & 0xff0000) | ((x >> 8) & 0xff00) | (x >> 24); x; })
#else
#define SWAP16(val) val
#define SWAP32(val) val
#endif

#include "init.h"
#include "mem.h"
#include "opdef.h"
#include "cpu2.h"
#include "gte.h"
#include "bios.h"
#include "hw.h"
#include "compile.h"
#include "win.h"
#include "runtime.h"
#include "cdrom.h"
#include "dis.h"
#include "sdk.h"
#include "sio.h"
#include "rs232.h"
#include "joypad.h"
#include "mdec.h"
#include "coff.h"

#if defined(__WIN32__)
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <conio.h>
#include <memory.h>
#include <malloc.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#ifdef __WATCOMC__
#include <direct.h>
#else
#include <dirent.h>
#endif
#include <sys/stat.h>

#elif defined(AMIGA)
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <memory.h>
#include <malloc.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef O_BINARY
#define O_BINARY 0
#endif

extern int   amiga_cd_unit;
extern char *amiga_cd_device;
extern int   amiga_use_screen;

#elif defined(LINUX)
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <ctype.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef O_BINARY
#define O_BINARY 0
#endif

#define stricmp strcasecmp

#else
#error FPSE cannot be compiled on your system.
#error Add your system in FPSE.H file before compiling.
#endif

// FPSE compiled version (BCD format)
#define FPSE_VERSION    0x0008

// add-on
#define FRAMESKIP   0
#define AUTOSPEED   0

// Flags
#define DISASMFLG       0x0001
#define EMULATE_BIOS    0x0002
#define VERBOSE         0x0004
#define IN_SLOT         0x0008
#define STOP            0x0010
#define SET_ESI         0x0020
#define COMPILE         0x0040
#define CDUSECACHE      0x0080
#define DEBUG           0x0100
#define ACTIONREPLAY    0x0200
#define USESERIAL       0x0400

#define PSX_COUNTRY     0x030000

// Other Flags in FPSE_Flags:
// /////////////////////////////
// Country USA    = 0x010000
// Country Europe = 0x020000
// Country Japan  = 0x030000

#define USE_AMERICAN_PSX  0x010000
#define USE_EUROPE_PSX    0x020000
#define USE_JAPAN_PSX     0x030000

#define disasmflg       (FPSE_Flags & DISASMFLG)
#define emulate_bios    (FPSE_Flags & EMULATE_BIOS)
#define verbose         (FPSE_Flags & VERBOSE)
#define in_slot         (FPSE_Flags & IN_SLOT)
#define stop            (FPSE_Flags & STOP)
#define compile         (FPSE_Flags & COMPILE)
#define cdusecache      (FPSE_Flags & CDUSECACHE)
#define debug           (FPSE_Flags & DEBUG)
#define actionreplay    (FPSE_Flags & ACTIONREPLAY)
#define useserial       (FPSE_Flags & USESERIAL)
#define psx_country     (FPSE_Flags & PSX_COUNTRY)

#define PRINTF  if (verbose) printf

typedef struct {
    char   *BiosName;
    char   *ComName;
    char   *Mcd1Name;
    char   *Mcd2Name;
} FPSECfgType;

void run_debug(void);
void LoadCFG(void);

extern UINT8   *ram;
extern UINT8   *rom;
extern UINT8   *scratchpad;
extern UINT8   *extrom;
extern FPSECfgType FPSEIni;

extern R3000_REG reg;
extern int       Irq_Pulse;
extern int       FPSE_Flags;

// Added in AmigaPPC porting (from SETUP.C file)
extern char *OS_Name;
extern char *OS_PorterName;
extern char *OS_ExtendedMsg;

int OS_CheckOption(char *str);
