#ifndef POLY2_H
#define POLY2_H

typedef struct {
#ifdef MSB_FIRST
    UINT8 code,b,g,r;
#else
    UINT8 r,g,b,code;
#endif
} COLOR;

typedef struct {
    INT32 r,g,b;
} LCOLOR;

typedef struct {
    INT32 x, u, v;
    LCOLOR c;
} EDGE;

typedef struct {
#ifdef MSB_FIRST
    INT16 y,x;
#else
    INT16 x,y;
#endif
} POINT_F; /* flat point */

typedef struct {
    COLOR c;
#ifdef MSB_FIRST
    INT16 y,x;
#else
    INT16 x,y;
#endif
} POINT_G; /* glow point */

typedef struct {
#ifdef MSB_FIRST
    INT16  y,x;
    UINT16 pad;
    UINT8  v,u;
#else
    INT16  x,y;
    UINT8  u,v;
    UINT16 pad;
#endif
} POINT_FT; /* flat textured point */

typedef struct {
     COLOR  c;
#ifdef MSB_FIRST
     INT16  y,x;
     UINT16 pad;
     UINT8  v,u;
#else
     INT16  x,y;
     UINT8  u,v;
     UINT16 pad;
#endif
} POINT_GT; /* grow textured point */

#include "prim2.h"

// Poly function sizes
#define NbF3        4
#define NbF4        5
#define NbFT3       7
#define NbFT4       9
#define NbG3        6
#define NbG4        8
#define NbGT3       9
#define NbGT4       12

// Line functions sizes
#define NbF2        3
#define NbG2        4

// Sprite functions sizes
#define NbSPRT      4
#define NbSPRTx     3

// Fill functions sizes
#define NbFILL      3
#define NbTILEx     2

int gpu_polyF3(PolyF3 *prim);
int gpu_polyF4(PolyF4 *prim);
int gpu_polyG3(PolyG3 *prim);
int gpu_polyG4(PolyG4 *prim);
int gpu_polyFT3(PolyFT3 *prim);
int gpu_polyFT4(PolyFT4 *prim);
int gpu_polyGT3(PolyGT3 *prim);
int gpu_polyGT4(PolyGT4 *prim);

int gpu_lineF2(LineF2 *prim);
int gpu_lineF(LineF3 *prim);
int gpu_lineG2(LineG2 *prim);
int gpu_lineG(LineG3 *prim);

int gpu_sprt(Sprt *prim);
int gpu_sprt8(Sprt *prim);
int gpu_sprt16(Sprt *prim);

int gpu_tile(Tile *prim);
int gpu_tile1(Tile1 *prim);
int gpu_tile8(Tile8 *prim);
int gpu_tile16(Tile16 *prim);

int gpu_fill(Fill *prim);

void DrawInit(void);

void move(int x0,int y0,int x1,int y1,int w,int h);

#endif