#include "fpse.h"

FPSECfgType FPSEIni;

#define ON(a) FPSE_Flags |= a
#define OFF(a) FPSE_Flags &= ~a

void LoadCFG(void)
{
  memset(&FPSEIni,0,sizeof(FPSEIni));

  OFF(EMULATE_BIOS);
  FPSEIni.BiosName = strdup("scph1001.bin");

  OFF(COMPILE);
  OFF(VERBOSE);
  OFF(DISASMFLG);
  OFF(DEBUG);

  ON(CDUSECACHE);

  // Europe
  FPSE_Flags = (FPSE_Flags & 0xFFFCFFFF) | ((1+1) << 16);

  OFF(USESERIAL);
}

// OS Section
char *OS_Name        = "AmigaPPC";
char *OS_PorterName  = "Mathias 'Amidog' Roslund";
char *OS_ExtendedMsg = 
     " -u#          cd unit (def: 2)\n"
     " -x<device>   cd device (def: atapi.device)\n"
     " -f           use screen (def: window)\n";

int OS_CheckOption(char *s)
{
    switch (*s) {
    case 'u': amiga_cd_unit    = atoi(s+1);   break;
    case 'x': amiga_cd_device  = strdup(s+1); break;
    case 'f': amiga_use_screen = 1;           break;
    default:  return FPSE_ERR;
    }

    return FPSE_OK;
}
