#include "fpse.h"

int win_init(void)
{
// devices
    if (CD_Open()   != FPSE_OK) {
        printf("CD-Rom initialization failed.\n");
        return FPSE_ERR;
    }
    if (SPU_Open()  != FPSE_OK) {
        printf("SPU initialization failed.\n");
        return FPSE_ERR;
    }
    if (GPU_Open()  != FPSE_OK) {
        printf("GPU initialization failed.\n");
        return FPSE_ERR;
    }
    if (JOY0_Open() != FPSE_OK) {
        printf("Gameport 0 initialization failed.\n");
        return FPSE_ERR;
    }
    if (JOY1_Open() != FPSE_OK) {
        printf("Gameport 1 initialization failed.\n");
        return FPSE_ERR;
    }

    return FPSE_OK;
}

void win_update(void)
{
    GPU_Update();
}

void win_term(void)
{
    GPU_Close();
    SPU_Close();
    JOY0_Close();
    JOY1_Close();
    CD_Close();
}
