/*
    CDROM ISO plugin
  ================================================================
  This plugin reads 'psx.iso' as if it were a cd. It's based on 
  the Win plugin called CdCtrl
  ================================================================
*/
#include <stdio.h>
#include <string.h>

#include "type.h"
#include "cdiso.h"

#define INT2BCD(a)        (((a)/10)*16+((a)%10))
#define BCD2INT(a)        (((a)>>4)*10+((a)&0xf))
#define MSF2SECT(m,s,f)   ( ( (m)*60 + (s) -2 )*75 + (f) )


#define RAW_SECTOR_SIZE     2352
#define COOKED_SECTOR_SIZE  2048

typedef struct {
        unsigned char reserved;
        unsigned char adr;
        unsigned char trackno;
        unsigned char reserved1;
        unsigned char addr[4];
} TOCENTRY;

typedef struct {
        unsigned char size[2];
        unsigned char first;
        unsigned char last;
        TOCENTRY track[100];
} TOC;

typedef struct {
    UINT8 minute;
    UINT8 second;
    UINT8 frame;
    UINT8 pad;
} CDLoc;

#define VERSION     0x0100  // Version must be in BCD format


static char retbuf[RAW_SECTOR_SIZE];
static int cderror = 0;
char isoimage[256];             // name of the image file name (iso)
FILE *fpiso;                    // file descriptor of the iso image


// return NULL if something was wrong
UINT8 *CD_Read(UINT8 *param)
{
    CDLoc *loc;
    int pos;
    
    loc = (CDLoc *)param;
    pos = MSF2SECT( loc->minute, loc->second, loc->frame );

//    printf("CD_Read(%i, %i, %i, %i)\n", loc->minute, loc->second, loc->frame, loc->pad);

    // go to begining of sector
    fseek(fpiso, pos*RAW_SECTOR_SIZE + 12, SEEK_SET);
    if (fread(retbuf, sizeof(unsigned char), RAW_SECTOR_SIZE, fpiso) == 0)
        cderror = 1;
    else
        cderror = 0;

    // emulate header
    retbuf[0] = INT2BCD(loc->minute);
    retbuf[1] = INT2BCD(loc->second);
    retbuf[2] = INT2BCD(loc->frame);

    return retbuf;
}


// stop playing CDA
int CD_Stop(void)
{
    printf("CD_Stop(): not implemented\n");
    return 0;
}

// Play CDA at given loc
int CD_Play(UINT8 *param)
{
    printf("CD_Play(): not implemented\n");
    return 0;
}

// Return Track specs
// UINT8 result[8]
int CD_GetTD(UINT8 *result,int track)
{
    printf("CD_GetTD(): not implemented\n");

    
    return 0;
}

// Get track number
int CD_GetTN(UINT8 *result)
{
    printf("CD_GetTN(): Not implemented\n");
    
    result[1]=1;
    result[2]=3;

    return 0;
}

// init the CD hardware
int CD_Open(UINT32 *par)
{
    printf("CD Plugin: ISO Plugin (reading \"psx.iso\")\n");
    
    // TODO: use this only if no file is given in configuration
    strcpy(isoimage, "psx.iso");

    // open the image file
    fpiso = fopen(isoimage, "rb");
    if (fpiso==NULL) {
        printf("CD_Open(): Fatal Error: psx.iso not found!\n");
        cderror = 1;
        return FPSE_ERR;
    }

    cderror = 0;
    return FPSE_OK;
}


// shutdown...
void CD_Close(void)
{
    printf("CD_Close()\n");

    if (fpiso == NULL) return;
    CD_Wait();
    fclose(fpiso);
}

// check end operation (with it busmaster is great!)
int CD_Wait(void)
{
//    printf("CD_Wait()\n");
    
    if (cderror)
    {
        cderror = 0;
        return FPSE_ERR;
    }

    return FPSE_OK;
}

// Return the seek position during CDA play
void CD_GetSeek(UINT8 *par)
{
    printf("CD_GetSeek(): not implemented\n");
}


 
