#include <SDL/SDL.h>
#include <string.h>
#include <ctype.h>
#include "gpulocal.h"
#include "keyboard.h"

static SDL_Surface *screen,*scr;
static int cur_width,cur_height;

static int dsp_init();
static void dsp_exit();
static void dsp_open_window(unsigned int w,unsigned int h);
static void dsp_resize(unsigned int w,unsigned int h);
static void dsp_change_title(char *title);
static void dsp_render_frame(UINT32 *image,int start,int endw);
static int dsp_key_pressed();
static UINT16 dsp_get_key();


DisplayStruct Dsp_SDL = {
	dsp_init,
	dsp_exit,
	dsp_open_window,
	dsp_resize,
	dsp_change_title,
	dsp_render_frame,
	dsp_key_pressed,
	dsp_get_key
};

static int dsp_init() {
	if (SDL_Init(SDL_INIT_VIDEO)==-1) return -1;
	return 0;
}

static void dsp_open_window(unsigned int w,unsigned int h) {
	screen = SDL_SetVideoMode(w,h,0,0);
	scr = SDL_CreateRGBSurface(0,w,h,16,BMASK,GMASK,RMASK,AMASK);
	cur_width = w;
	cur_height = h;
}
static void dsp_resize(unsigned int w,unsigned int h) {
	dsp_open_window(w,h);
}

static void dsp_exit() {
	SDL_FreeSurface(screen);
	SDL_FreeSurface(scr);
	SDL_Quit();
}
static void dsp_change_title(char *title) {
	SDL_WM_SetCaption(title,title);
}

static void dsp_render_frame(UINT32 *image,int start,int endw) {
	int y;

	UINT16 *src,*dst;
	src = ((UINT16*)image)+start;
	dst = (UINT16*)scr->pixels;
	for (y=0; y<cur_height; y++) {
	    memcpy(dst,src,cur_width*2);
	    src += endw;
	    dst += cur_width;
	}
	SDL_BlitSurface(scr,NULL,screen,NULL);
	SDL_UpdateRect(screen,0,0,cur_width,cur_height);
}

static SDL_Event E;

static int dsp_key_pressed() {
	SDL_PollEvent(&E);
	if (E.type==SDL_KEYDOWN) return PRESSED_KEY;
	if (E.type==SDL_KEYUP) return RELEASED_KEY;
	return NO_KEY;
}

static UINT16 dsp_get_key() {

	UINT16 key;

	key=E.key.keysym.sym;
	return(key);
/*	switch (key) {
		case SDLK_SPACE:
			return KEY_SPACE;
		case SDLK_UP:
			return KEY_UP;
		case SDLK_DOWN:
			return KEY_DOWN;
		case SDLK_RIGHT:
			return KEY_RIGHT;
		case SDLK_LEFT:
			return KEY_LEFT;
		default:
			if (!isalpha(key))
				return KEY_INVALID;
			return key;
	}
*/
}
