#include <stdio.h>
#include <stdarg.h>

#define SYSLOG_ON_SCREEN    1

#if SYSLOG_ON_SCREEN==0
static FILE *fp;
#endif

void syslog(char *fmt,...)
{
    va_list marker;
    char    tmpbuf[80];

#if SYSLOG_ON_SCREEN==0
    if (fp==NULL)
        fp = fopen("gpulog.txt","wt");
#endif

    va_start(marker,fmt);
    vsprintf(tmpbuf, fmt, marker );
    va_end(marker);

#if SYSLOG_ON_SCREEN==0
    fprintf(fp,"%s\n",tmpbuf);
#else
    printf("%s\n",tmpbuf);
#endif
}