#include "fpse.h"

FPSECfgType FPSEIni;

void LoadCFG(void)
{
    char tmp[256];


    memset(&FPSEIni,0,sizeof(FPSEIni));

    INI_Load("fpse.ini");

    printf("LoadCFG(): Loading params from fpse.ini... ");

    // process the usual params
    if (INI_Read("FPSE", "RomName", tmp) == FPSE_OK && strlen(tmp)) {
        FPSEIni.BiosName = (char *)calloc(strlen(tmp)+10, sizeof(char));
        strcpy(FPSEIni.BiosName, tmp);
    }
    if (INI_Read("FPSE", "EmulateBios", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "on") == 0) FPSE_Flags |= EMULATE_BIOS;
        else if (strcasecmp(tmp, "1") == 0) FPSE_Flags |= EMULATE_BIOS;
        else if (strcasecmp(tmp, "off") == 0) FPSE_Flags &= ~EMULATE_BIOS;
        else if (strcasecmp(tmp, "0") == 0) FPSE_Flags &= ~EMULATE_BIOS;
        else printf("INI_Load(): Unknown param for option \"EmulateBios\" = %s\n", tmp);
    }    
    if (INI_Read("FPSE", "Debugger", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "on") == 0) FPSE_Flags |= DEBUG;
        else if (strcasecmp(tmp, "1") == 0) FPSE_Flags |= DEBUG; 
        else if (strcasecmp(tmp, "off") == 0) FPSE_Flags &= ~DEBUG;
        else if (strcasecmp(tmp, "0") == 0) FPSE_Flags &= ~DEBUG;  
        else printf("INI_Load(): Unknown param for option \"Debugger\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "Verbose", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "on") == 0) FPSE_Flags |= VERBOSE;
        else if (strcasecmp(tmp, "1") == 0) FPSE_Flags |= VERBOSE;
        else if (strcasecmp(tmp, "off") == 0) FPSE_Flags &= ~VERBOSE;
        else if (strcasecmp(tmp, "0") == 0) FPSE_Flags &= ~VERBOSE;
        else printf("INI_Load(): Unknown param for option \"Verbose\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "Disasm", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "on") == 0) FPSE_Flags |= DISASMFLG;
        else if (strcasecmp(tmp, "1") == 0) FPSE_Flags |= DISASMFLG; 
        else if (strcasecmp(tmp, "off") == 0) FPSE_Flags &= ~DISASMFLG;
        else if (strcasecmp(tmp, "0") == 0) FPSE_Flags &= ~DISASMFLG;     
        else printf("INI_Load(): Unknown param for option \"Disasm\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "CDUseCache", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "on") == 0) FPSE_Flags |= CDUSECACHE;
        else if (strcasecmp(tmp, "1") == 0) FPSE_Flags |= CDUSECACHE;
        else if (strcasecmp(tmp, "off") == 0) FPSE_Flags &= ~CDUSECACHE;
        else if (strcasecmp(tmp, "0") == 0) FPSE_Flags &= ~CDUSECACHE;
        else printf("INI_Load(): Unknown param for option \"CDUseCache\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "CpuMode", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "compiler") == 0) FPSE_Flags |= COMPILE;
        else if (strcasecmp(tmp, "interpreter") == 0) FPSE_Flags &= ~COMPILE;
        else printf("INI_Load(): Unknown param for option \"CpuMode\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "UseSerial", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "on") == 0) FPSE_Flags |= USESERIAL;
        else if (strcasecmp(tmp, "1") == 0) FPSE_Flags |= USESERIAL;
        else if (strcasecmp(tmp, "off") == 0) FPSE_Flags &= ~USESERIAL;
        else if (strcasecmp(tmp, "0") == 0) FPSE_Flags &= ~USESERIAL;
        else printf("INI_Load(): Unknown param for option \"UseSerial\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "ComPort", tmp) == FPSE_OK) {
        if (strcasecmp(tmp, "COM1") == 0) FPSEIni.ComName = "/dev/cua0";
        else if (strcasecmp(tmp, "COM2") == 0) FPSEIni.ComName = "/dev/cua1";
        else if (strcasecmp(tmp, "COM3") == 0) FPSEIni.ComName = "/dev/cua2";
        else if (strcasecmp(tmp, "COM4") == 0) FPSEIni.ComName = "/dev/cua3";
        else if (strcasecmp(tmp, "/dev/cua0") == 0) FPSEIni.ComName = "/dev/cua0";
        else if (strcasecmp(tmp, "/dev/cua1") == 0) FPSEIni.ComName = "/dev/cua1";
        else if (strcasecmp(tmp, "/dev/cua2") == 0) FPSEIni.ComName = "/dev/cua2";
        else if (strcasecmp(tmp, "/dev/cua3") == 0) FPSEIni.ComName = "/dev/cua3";
        else printf("INI_Load(): Unknown param for option \"ComPort\" = %s\n", tmp);
    }
    if (INI_Read("FPSE", "MemCard1", tmp) == FPSE_OK && strlen(tmp)) {
          FPSEIni.Mcd1Name = (char *)calloc(strlen(tmp)+10, sizeof(char));
        strcpy(FPSEIni.Mcd1Name, tmp);
    }
    if (INI_Read("FPSE", "MemCard2", tmp) == FPSE_OK && strlen(tmp)) {
          FPSEIni.Mcd2Name = (char *)calloc(strlen(tmp)+10, sizeof(char));
        strcpy(FPSEIni.Mcd2Name, tmp);
    }

 
    printf("Ok\n");
}

// OS Section
char *OS_Name        = "Linux";
char *OS_PorterName  = NULL;
char *OS_ExtendedMsg = NULL;

int OS_CheckOption(char *str)
{
    return FPSE_ERR;
}
