#include "fpse.h"
#include "linuxdef.h"

static FPSELinux FPSELinuxInfo;

int win_init(void)
{

    memset (&FPSELinuxInfo,0,sizeof(FPSELinuxInfo));

    FPSELinuxInfo.SystemRam = ram;
    FPSELinuxInfo.ReadCfg = INI_Read;
    FPSELinuxInfo.WriteCfg = INI_Write;
    FPSELinuxInfo.FlushRec = CompileFlush;
    FPSELinuxInfo.Flags = 0x2;

// devices
    if (CD_Open((UINT32*)&FPSELinuxInfo)   != FPSE_OK) {
        printf("CD-Rom initialization failed.\n");
        return FPSE_ERR;
    }
    if (SPU_Open((UINT32*)&FPSELinuxInfo)  != FPSE_OK) {
        printf("SPU initialization failed.\n");
        return FPSE_ERR;
    }
    if (GPU_Open((UINT32*)&FPSELinuxInfo)  != FPSE_OK) {
        printf("GPU initialization failed.\n");
        return FPSE_ERR;
    }
    if (JOY0_Open((UINT32*)&FPSELinuxInfo) != FPSE_OK) {
        printf("Gameport 0 initialization failed.\n");
        return FPSE_ERR;
    }
    if (JOY1_Open((UINT32*)&FPSELinuxInfo) != FPSE_OK) {
        printf("Gameport 1 initialization failed.\n");
        return FPSE_ERR;
    }

    return FPSE_OK;
}

void win_update(void)
{
    GPU_Update();
}

void win_term(void)
{
    GPU_Close();
    SPU_Close();
    JOY0_Close();
    JOY1_Close();
    CD_Close();
    INI_Save("fpse.ini");
    INI_Free();
}
