#ifndef CPU2_H
#define CPU2_H

typedef struct {
     UINT32    r[32];
     UINT32    pc;
     UINT32    lo,hi;
     UINT32    cpr0[32];
     UINT32    ccr0[32];
     UINT32    cpr2[32];
     UINT32    ccr2[32];
     /* support */
     void *pcbase;
} R3000_REG;

#define   rsno ((code>>21)&31)
#define   rtno ((code>>16)&31)
#define   rdno ((code>>11)&31)

#define   PC   reg.pc
#define   rs   reg.r[rsno]
#define   rt   reg.r[rtno]
#define   rd   reg.r[rdno]
#define   immS ((INT16)code)
#define   immU (code&0xffff)

#define   CPR0 reg.cpr0
#define   CPR2 reg.cpr2
#define   CCR0 reg.ccr0
#define   CCR2 reg.ccr2
#define   SR   CPR0[12]
#define   CAUSE     CPR0[13]
#define   EPC  CPR0[14]

#define   EXCEPTION(code)     PC-=4; Exception(code*4)
#define   rHI             reg.hi
#define   rLO             reg.lo
#define   FETCH(pc)       SWAP32(*(UINT32*)((char*)reg.pcbase+pc))
#define   SETPC(pc)       reg.pcbase=baseaddr(pc)

void Reset(void);
void Exception(int cd);
void Interrupt(void);
void doInst(void);
void setpc(int pc);
void printpc(void);

#endif
