# Makefile for FPSE Win32 version

CC = gcc
LD = gcc
RM = del

DIR_INCLUDE = include
DIR_MICROPR = cpu/ix86
DIR_OSYSTEM = system/win32
DIR_LIBRARY = $(DIR_OSYSTEM)/rsx_131
DIR_OBJECTS = obj

DEFS     = -Zwin32
INCLUDE  = -I$(DIR_INCLUDE) -I$(DIR_OSYSTEM)
DEBUG    = -g -Wall # -Werror
OPTIMIZE = -O2 -fomit-frame-pointer

CFLAGS   = $(DEFS) $(INCLUDE) $(DEBUG) $(OPTIMIZE)

OBJNAMES =  cpu2.o    mem.o     emu.o     hw.o     bios.o    win.o    \
	compile.o runtime.o gte.o     malloc.o cdrom.o   dis.o    \
	sio.o     mdec.o    idctfst.o debug.o  rs232.o   joypad.o \
	setup.o   init.o

LIBNAMES= gpurend.a spurend.a joy0rend.a joy1rend.a cdrend.a

OBJS= $(addprefix $(DIR_OBJECTS)/, $(OBJNAMES))
LIBS= $(addprefix $(DIR_LIBRARY)/, $(LIBNAMES))

all:	fpse.exe

$(DIR_OBJECTS)/compile.o: $(DIR_MICROPR)/compile.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/rs232.o:   $(DIR_OSYSTEM)/rs232.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/init.o:    $(DIR_OSYSTEM)/init.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/setup.o:   $(DIR_OSYSTEM)/setup.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/win.o:     $(DIR_OSYSTEM)/win.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/%.o: %.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

fpse.exe: $(OBJS) makefile
	$(LD) $(CFLAGS) -o fpse.exe $(OBJS) $(LIBS)

dis.exe: dis.c
	$(CC) $(CFLAGS) dis.c -o dis.exe -DMAKEDIS

clean :
	$(RM) *.exe
	$(RM) *.sym
	$(RM) $(DIR_OBJECTS)\*.o
