#include "gpulocal.h"

#define ALL_VRAM 0

void GPU_ScreenShot(char *path)
{
    FILE   *bmpfile;
    char    filename[256];
    UINT16 *vram2;
    UINT8  *vram3;
    UINT8   header[0x36];
    UINT32  size;
    UINT8   line[1024*3];
    UINT8   empty[2]={0,0};
    UINT16  color;
    int     snapshotnr = 0,i,j;

#if ALL_VRAM==0 
    size=gpu.disp.h*gpu.disp.w*3+0x38;
    vram2=vram + (gpu.disp.h+gpu.disp.y-1)*1024 + gpu.disp.x;
#else
    size = 1024*512*3+0x38;
    vram2 = vram + 1024*511;
#endif
    vram3 = (UINT8 *)(vram2)+1;

// fill in proper values for BMP
 
// hardcoded BMP header
    memset(header,0,0x36);
    header[0]='B';
    header[1]='M';
    header[2]=size&0xff;
    header[3]=(size>>8)&0xff;
    header[4]=(size>>16)&0xff;
    header[5]=(size>>24)&0xff;
    header[0x0a]=0x36;
    header[0x0e]=0x28;
#if ALL_VRAM==1
    header[0x12]=1024%256; // gpu.disp.w%256;
    header[0x13]=1024/256; // gpu.disp.w/256;
    header[0x16]=512%256;  // gpu.disp.h%256;
    header[0x17]=512/256;  // gpu.disp.h/256;
#else
    header[0x12] = gpu.disp.w%256;
    header[0x13] = gpu.disp.w/256;
    header[0x16] = gpu.disp.h%256;
    header[0x17] = gpu.disp.h/256;
#endif
    header[0x1a]=0x01;
    header[0x1c]=0x18;
    header[0x26]=0x12;
    header[0x27]=0x0B;
    header[0x2A]=0x12;
    header[0x2B]=0x0B;
 
    for (;;) {
        if (++snapshotnr > 9999) return;
        sprintf(filename,"%ssnap%04d.bmp",path,snapshotnr);
        bmpfile=fopen(filename,"rb");
        if (bmpfile == NULL) break;
        fclose(bmpfile);
    }

// try opening new snapshot file
    if((bmpfile=fopen(filename,"wb"))==NULL)
    {
// could not open for writing !
        return;
    }
 
    fwrite(header,0x36,1,bmpfile);

#if ALL_VRAM==0
    size = gpu.disp.w*3;
    for(i=0;i<gpu.disp.h;i++)
    {
        if (gpu.status & 0x00200000)
        {
            for (j=0; j<size; j+=3)
            {
                line[j+2] = vram3[j+0];
                line[j+1] = vram3[j+1];
                line[j+0] = vram3[j+2];
            }
        } else
        for(j=0;j<gpu.disp.w;j++)
#else
    size = 1024*3;
    for(i=0;i<512;i++)
    {
        if (gpu.status & 0x00200000)
        {
            for (j=0; j<size; j+=3)
            {
                line[j+2] = vram3[j+0];
                line[j+1] = vram3[j+1];
                line[j+0] = vram3[j+2];
            }
        } else
        for(j=0;j<1024;j++)
#endif
        {
                color=vram2[j];
                line[j*3+2]= (color >> 7) & 0xF1;
                line[j*3+1]= (color >> 2) & 0xF1;
                line[j*3+0]= (color << 3) & 0xF1;
        }
        fwrite(line,size,1,bmpfile);
        vram2 -= 1024;
        vram3 -= 2048;
    }

    fwrite(empty,0x2,1,bmpfile);
    fclose(bmpfile);  
}