/* FpseCfg for Linux 
 *
 * call fpsecfg -c to copy the plugins from PLUGINS_DIR to .
 *
 * By LinuzAppz <linuzappz@hotmail>
 *
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "type.h"
#include "linuxdef.h"

#define PLUGINS_DIR		"system/linux/plugin/"
#define VERSION			"0.1"

FPSELinux conf;

int INI_Load(char *nf);
int INI_Save(char *nf);
void INI_Free(void);
unsigned char *INI_Find(char *section, char *name);
int INI_Read(char *Section, char *Entry, char *Value);
int INI_Write(char *Section, char *Entry, char *Value);

void list_plugin(char *plugin,char *type);
void ConfCmd(int cmd, void *arg);

#define PLUGIN_COMMON(str0,str1,str2) \
memset(Value,0,sizeof(Value)); \
printf ("Select one %s Plugin (see %slib%s*):\n",str0,PLUGINS_DIR,str1); \
scanf("%s",Value); \
 \
if (strncmp("lib",Value,3)) { \
    memcpy(tmp,Value,sizeof(Value)); \
    sprintf (Value, "lib%s",tmp); \
} \
 \
if (strstr(".a",Value) == NULL) strcat(Value,".a"); \
 \
if (strncmp (PLUGINS_DIR,Value,strlen(PLUGINS_DIR))) { \
    memcpy(tmp,Value,sizeof(Value)); \
    sprintf (Value,"%s%s",PLUGINS_DIR,tmp); \
} \
list_plugin (Value,str2); \
if (copyem) {\
sprintf (tmp, "cp %s lib%s.a",Value,str1);\
system(tmp);}

int main(int argc,char *argv[])
{
int copyem = 0;
char Value[128],tmp[128];

if (argc > 1) if (!strcmp(argv[1],"-c")) copyem = 1;

INI_Load("fpse.ini");

printf ("FPSEConfigurator for Linux v%s\n\n",VERSION);

/* general options */

memset(Value,0,sizeof(Value));
printf ("Especify BIOS to use:\n");
scanf("%s",Value);
INI_Write("FPSE","RomName",Value);

memset(Value,0,sizeof(Value));
printf ("Use CDCache (on/off):\n");
scanf("%s",Value);
INI_Write("FPSE","CDUseCache",Value);

memset(Value,0,sizeof(Value));
printf ("CpuMode (compiler/interpreter):\n");
scanf("%s",Value);
INI_Write("FPSE","CpuMode",Value);

memset(Value,0,sizeof(Value));
printf ("CDCountry (0/1/2/3 : None/American/Europe/Japan):\n");
scanf("%s",Value);
INI_Write("FPSE","CDCountry",Value);

/* plugins */

conf.ReadCfg = INI_Read;
conf.WriteCfg = INI_Write;
conf.ConfCmd = ConfCmd;

PLUGIN_COMMON("CD-ROM","cd","CD");

PLUGIN_COMMON("GPU","gpu","GPU");

PLUGIN_COMMON("SPU","spu","SPU");

PLUGIN_COMMON("JOY","joy","JOY");

INI_Save("fpse.ini");
INI_Free();

return 0;
}


void ConfCmd(int cmd, void *arg)
{
switch (cmd) {
    case 0: printf ("Plugin Configuration:\n"); printf ("\033[01;32m"); break; /* start/reset */
    case 1: printf ("%s\n",(char *)arg); break; /* print */
    case 0xf: getchar(); getchar(); printf ("\033[0m"); break; /* wait and close */
}
}
