#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "type.h"

unsigned char *config_buf; // buffer were the configuration file is stored
long config_size;          // size of the configuration file

//int FPSE_Flags = 0;

// local functions
int INI_Load(char *nf);
int INI_Save(char *nf);
void INI_Free(void);
unsigned char *INI_Find(char *section, char *name);
int INI_Read(char *Section, char *Entry, char *Value);
int INI_Write(char *Section, char *Entry, char *Value);



// Read the configuration file "fpse.ini"
int INI_Load(char *nf)
{
    FILE *fp;  // file pointer to the configuration file

    fp = fopen(nf, "rt");
    if (fp == NULL) {
        printf("INI_Load(): Error reading configuration file \"%s\"\n", nf);
        return FPSE_ERR;
    }

    fseek(fp, 0, SEEK_END);
    config_size = ftell(fp);
    fseek(fp, 0, SEEK_SET);
   
    // TODO: test this, because it's dangerous to allocate memory inside functions
    config_buf = (unsigned char *)malloc( (config_size + 1024)*sizeof(unsigned char) ); 

    fread(config_buf, sizeof(unsigned char), config_size, fp);
    fclose(fp);


    return FPSE_OK;
}


// Save the config file to disk with name nf
int INI_Save(char *nf)
{
    FILE *fp;

    fp = fopen(nf, "wt");
    if (fp == NULL) {
        printf("INI_Save(): Error writing configuration file \"%s\"\n", nf);
        return FPSE_ERR;
    }

    fwrite(config_buf, sizeof(unsigned char), config_size, fp);
    fclose(fp);
    
    return FPSE_OK;
}


// Release the memory allocated for the configuration file
void INI_Free(void) 
{
    free(config_buf);
}


// Helper function for finding an entry in the configuration file
unsigned char *INI_Find(char *section, char *name)
{
    unsigned char *ptr;
    unsigned char tmp[256];
    int ret, in_section = 0;
    int i;

    if (section == NULL) return NULL;

    ptr = config_buf;

    // search for the section but give up at 100 trys
    for(i=0; i<100; i++) {
        ptr = strchr(ptr, '[');
        if (ptr == NULL) break;
        ret = sscanf(ptr, "[%[^]]s", tmp);  // store the section name in tmp
        if (ret == 0) break;
         
//        printf("tmp = %s\n", tmp);   
        if (strcasecmp(tmp, section) == 0) { // section name matches
            in_section = 1;
            break;
        }
        ptr++;
    } 

    if (!in_section) return NULL;
    ptr += strlen(section)+2; // advance the string of the section + []    
    if (name == NULL) return ptr;

    // search for name until the next '['  but give up at 1000 trys
    for(i=0; i<1000; i++) {
        ptr = strchr(ptr, '\n')+1;         // advance to next line
	if (strchr (ptr,'\n')==NULL) return NULL; // check if eof has been reached
        ret = sscanf(ptr, "%[^=]s", tmp);  // store the section name in tmp ignoring '='
        if (ret == 0) break;
//        printf("ptr = %s\n\n", tmp); 

        if (strcasecmp(tmp, name) == 0) return ptr;  // name matches
    }
  
    return NULL;
}


// Reads a string from the configuration file
// Returns FPSE_ERR if the string is not found in the file
int INI_Read(char *Section, char *Entry, char *Value)
{
    char *ptr;
    int ret;

    ptr = INI_Find(Section, Entry);

    if (ptr == NULL) return FPSE_ERR;
    ptr = strchr(ptr, '=')+1;
    ret = sscanf(ptr, "%s", Value);    
    
    if (ret == 0) {
        Value[0] = 0;
        return FPSE_ERR;
    }

    return FPSE_OK;
}


// Writes a string to the configuration file
// If the entry already exists then it is replaced, otherwise it is created
// By linuzappz <linuzappz@hotmail.com>
int INI_Write(char *Section, char *Entry, char *Value)
{
    unsigned char *ptr,*buf,*tmp;
    int ret,ret0,size;

    buf = (unsigned char *) malloc (config_size+1024);
    if (buf == NULL) { printf ("Out Of Memory\n"); /*win_term();*/ exit(0); }
    memcpy(buf, config_buf, config_size);

    ptr = INI_Find(Section, Entry);
    if (ptr != NULL) {
	ptr = strchr(ptr, '=')+1;
	tmp = strchr(ptr, '\n');
	ret0 = tmp - ptr;
	ret = sprintf(ptr, "%s", Value);
	size = ptr - config_buf;

	memcpy(ptr+ret,buf+(size+ret0),config_size-(size+ret0));
	config_size += ret - ret0;

	memcpy(buf, config_buf, config_size);
	free (config_buf);
	config_buf = (unsigned char *)malloc (config_size+1024); 
	memcpy(config_buf, buf, config_size);

	free(buf);
	return FPSE_OK;
    }

    ptr = INI_Find(Section, NULL);
    if (ptr != NULL) {
	ret = sprintf (++ptr,"%s=%s\n",Entry,Value);
	size = ptr - config_buf;

	memcpy(ptr+ret,buf+size,config_size-size);
	config_size += ret;

	memcpy(buf, config_buf, config_size);
	free (config_buf);
	config_buf = (unsigned char *)malloc (config_size+1024); 
	memcpy(config_buf, buf, config_size);

	free(buf);
	return FPSE_OK;
    }    

    ptr = config_buf+config_size;
    ret = sprintf(ptr,"\n[%s]\n%s=%s\n",Section,Entry,Value);
    config_size += ret;

    memcpy(buf, config_buf, config_size);
    free (config_buf);
    config_buf = (unsigned char *)malloc (config_size+1024); 
    memcpy(config_buf, buf, config_size);

    free(buf);
    return FPSE_OK;
}


//#define TEST_INI
#ifdef TEST_INI
int main(void)
{
    LoadCFG();

    INI_Free();
    return 0;
}
#endif
