/*
 * FPSE linux joystick routines
 *
 * This driver needs that the gpu driver declares two functions:
 *
 * int (*key_pressed)(); // returns NO_KEY, PRESSED_KEY or RELEASED_KEY
 * UINT16 (*get_key)(); // return the key according to "keyboard.h" or NO_KEY
 * 
 * I've tested it and works fine
 *
 * 	linuzappz
 *
 */

#include <stdio.h>

#include "type.h"
#include "keyboard.h"


int (*key_pressed)();
UINT16 (*get_key)();
int joy0_ret = 0;		/* passed to gpu */

void (*GPU_ScreenShot)(char *path);
void (*win_term)(void);

static char *padbuf0 = NULL;
static char *padbuf1 = NULL;

static int keybind[16] = {
    KEY_INSERT,    /* L2 */
    KEY_PAGEUP,    /* R2 */
    KEY_DELETE,    /* L1 */
    KEY_PAGEDOWN,  /* R1 */
    KEY_v,     /* /\ */
    KEY_z,     /*  O */
    KEY_x,     /*  X */
    KEY_c,     /* [] */
    KEY_TAB,       /* SELECT */
    0,
    0,
    KEY_RETURN,    /* START */
    KEY_UP,        /* UP */
    KEY_RIGHT, /* RIGHT */
    KEY_DOWN,  /* DOWN */
    KEY_LEFT       /* LEFT */
};

// This Function is called when emulator starts
int JOY0_Open(UINT32 *joy)
{
  // Nothing to do here
  return FPSE_OK;
}

// This Function is called when emulator is closed
void JOY0_Close()
{
  // Nothing to do here
}

// This function is called when the gamepad should vibrate:
// if (motor != 0) then vibrate(on) else vibrate(off)
void JOY0_Vibrate(int motor)
{
}

// Return status of buttons (see joydrv.h)
void JOY0_Poll()
{
    int i,key,press;
    static int ret;

    press = key_pressed();
    if (press!=NO_KEY) {
	key = get_key();

	if (press == PRESSED_KEY) {
    	    for(i=0;i<16;i++) {
        	if(keybind[i]==key)
            	    { ret|=(1<<i); break; }
    	    }
	    if (i==16)
		switch (key) {
		    case KEY_ESCAPE:	win_term(); exit(0);
		    case KEY_F5:	GPU_ScreenShot(""); break;
		    default:		joy0_ret = key;
		}
	}
	if (press == RELEASED_KEY)
    	    for(i=0;i<16;i++) {
        	if(keybind[i]==key)
            	    ret&=~(1<<i);
    	    }
    }
    padbuf0[3] = (~ret) >> 8;
    padbuf0[4] = (~ret);
}

int JOY0_InitHeader(char *buf)
{
  padbuf0 = buf;
  buf[1] = 0x41;
  buf[2] = 0x5A;
  return 5;
}

// This Function is called when emulator starts
int JOY1_Open(UINT32 *joy)
{
  // Nothing to do here
  return FPSE_OK;
}

// This Function is called when emulator is closed
void JOY1_Close()
{
  // Nothing to do here
}

// This function is called when the gamepad should vibrate:
// if (motor != 0) then vibrate(on) else vibrate(off)
void JOY1_Vibrate(int motor)
{
}

// Return status of buttons (see joydrv.h)
void JOY1_Poll()
{
  padbuf1[3] = 0xFF;
  padbuf1[4] = 0xFF;
}

int JOY1_InitHeader(char *buf)
{
  padbuf1 = buf;
  buf[1] = 0x41;
  buf[2] = 0x5A;
  return 5;
}
