#include <stdio.h>
#include <stdlib.h>

#include "type.h"
#include "linuxdef.h"

#define RAMADDR(addr) ((void*)&ram[(addr)&0x1fffff])

static int spu_sbaddr;
static INT16 spureg[(0x1e00-0x1c00)/2];
static INT16 *spumem;
static UINT8 *ram;
static FPSELinux *FpseInfo;

int SPU_Open(UINT32 *par)
{
    FpseInfo = (FPSELinux *) par;
    ram = FpseInfo->SystemRam;

    spumem = (INT16 *)malloc(512*1024);
    if (spumem == NULL) return FPSE_ERR;

    return FPSE_OK;
}

void SPU_Close()
{
    free(spumem);
}

int SPU_Read(UINT32 adr)
{
    switch(adr){
    default:
        return spureg[(adr-0x1f801c00)/2];
    }
    return 0;
}

void SPU_Write(UINT32 adr, unsigned int data)
{
    spureg[(adr-0x1f801c00)/2] = data;
    switch(adr) {
    case 0x1f801da6: /* spu sbaddr */
        spu_sbaddr = data*4;
        break;
    case 0x1f801da8: /* spu data */
//      if ((spu_reg0&0x30)==0x10) {
            /* non dma mode */
            spumem[spu_sbaddr++]=data;
            return;
//      }
        break;
    }
}

void SPU_DmaExec(UINT32 adr,UINT32 bcr,UINT32 chcr)
{
    int size;

    size = (bcr>>16)*(bcr&0xffff);
    switch(chcr) {
    case 0x01000201:
        memcpy(spumem+spu_sbaddr,RAMADDR(adr),size*4);
        break;
    case 0x01000200:
        memcpy(RAMADDR(adr),spumem+spu_sbaddr,size*4);
        break;
    }
}