#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "fpse.h"

#define GETCHECK(a,b)   ret = INI_Read( "FPSE", a, data);               \
                        if (ret == FPSE_OK) {                           \
                            if (!stricmp(data,"off")) FPSE_Flags &= ~b; \
                                else                                    \
                            if (!stricmp(data,"on")) FPSE_Flags |= b;   \
                        }

static char LoadData[256];
FPSECfgType FPSEIni;

void LoadCFG(void)
{
    char data[256],*p;
    int  ret;

    GetModuleFileName(NULL,data,256);

    p = data;
    while(strchr(p,'\\')) {  // while there are more separators
        p = strchr(p,'\\');   // point to next separator
        p++;                  // point to char after last separator
    }

    strcpy(p,"FPSE.INI");
    INI_Load(data);

    p = LoadData;
    memset(p,0,256);
    memset(&FPSEIni,0,sizeof(FPSEIni));

// Get BIOS Mode
    GETCHECK("EmulateBios", EMULATE_BIOS);
    if (!emulate_bios)
    {
        ret = INI_Read( "FPSE", "RomName", data);
        if (ret == FPSE_OK && strlen(data))
        {
            strcpy(p,data);
            FPSE_Flags &= ~EMULATE_BIOS;
            FPSEIni.BiosName = p;
            p += strlen(p) + 2;
        }
    } else FPSEIni.BiosName = NULL;

// Get Cpu Mode
    ret = INI_Read( "FPSE", "CpuMode", data);
    if (ret == FPSE_OK)
    {
        if (!stricmp(data,"interpreter")) FPSE_Flags &= ~COMPILE;
            else
        if (!stricmp(data,"compiler")) FPSE_Flags |= COMPILE;
    }

// Get Verbose
    GETCHECK("Verbose", VERBOSE)

// Get Disasm
    GETCHECK("Disasm", DISASMFLG)

// Get Debugger Mode
    GETCHECK("Debugger", DEBUG)

// Get CDROM Cache status
    GETCHECK("CDUseCache", CDUSECACHE)

// Get CDROM country
    INI_Read( "FPSE", "CDCountry", data );
    ret = data[0] - '0';
    if (ret < 0 || ret > 2) ret = 0;
    FPSE_Flags = (FPSE_Flags & 0xFFFCFFFF) | ((ret+1) <<16);

// Get Serial status
    GETCHECK("UseSerial", USESERIAL)

// Get Serial port
    ret = INI_Read( "FPSE", "ComPort", data);
    if (ret == FPSE_OK && strlen(data))
    {
        strcpy(p,data);
        FPSEIni.ComName = p;
        p += strlen(p) + 2;
    }

// Get memory card 1
    ret = INI_Read( "FPSE", "MemCard1", data);
    if (ret == FPSE_OK && strlen(data))
    {
        strcpy(p,data);
        FPSEIni.Mcd1Name = p;
        p += strlen(p) + 2;
    }

// Get memory card 2
    ret = INI_Read( "FPSE", "MemCard2", data);
    if (ret == FPSE_OK && strlen(data))
    {
        strcpy(p,data);
        FPSEIni.Mcd2Name = p;
        p += strlen(p) + 2;
    }
}

// OS Section
char *OS_Name        = "Win32";
char *OS_PorterName  = NULL;
char *OS_ExtendedMsg = NULL;

int OS_CheckOption(char *str)
{
    return FPSE_ERR;
}
