/*
    FPSE debugger
    =============

    Written by LDChen
*/

#include "fpse.h"

// Today some commands are not implemented
char *str_hlp = { "r <x> <val> : watch GPR regs and assign new value\n"
                  "c <x>       : watch COP<x>\n"
                  "b <hexadr>  : set breakpoint at hexadr (if no hexadr break is disabled)\n"
                  "g           : go\n"
                  "s           : step\n"
                  "n           : next\n"
                  "<ENTER>     : repeat last command\n"
                  "u <hexadr>  : unassemble at hexadr (if none PC reg is used)\n"
                  "d <hexadr>  : dump data at hexadr (if none PC reg is used)\n"
                  "p <hexadr>  : print portname at hexadr\n"
                  "w <x,hexadr>: write data of type x at hexadr\n"
                  "h           : display this help\n"
                  "q           : quit debugger\n" };

extern int dumpreg;

void *getaddr(UINT32 adr)
{
    if ((adr>=0x80000000 && adr<0x80800000) ||
        (adr>=0xa0000000 && adr<0xa0800000) ||
        (adr>=0x00000000 && adr<0x00800000)) return ram;

    if ((adr>=0xbfc00000 && adr<0xbfc80000) ||
        (adr>=0x1fc00000 && adr<0x1fc80000) ||
        (adr>=0x9fc00000 && adr<0x9fc80000)) return rom;

    if (adr>=0x1f000000 && adr<0x1f020000) return extrom;

    return NULL;
}

void run_debug(void)
{
 char   buf[80];
 UINT32 code;
 int    fine=1,ncmd,address,val;
 int    brkadr = 0,brkp=0;
 char   oldcmd=0,cmd;

 while (fine)
    {
        FPSE_Flags |= VERBOSE | DISASMFLG;
        printf(">");
        gets(buf);
        ncmd = sscanf(buf,"%c %x %x",&cmd,&address,&val);
        if (!cmd) cmd    = oldcmd;
             else oldcmd = cmd;

        switch (cmd) {
        case 'u':
            {
            int x;
            char *y;
            if (ncmd == 1) address = PC;
            y = getaddr(address);
            if (y==NULL) {
                printf("Unavailable\n");
                break;
            }
            dumpreg = 0;
            for (x=0;x<16;x++) {
                code = *(UINT32 *)(y+(address&0x1FFFFF)+x*4);
                disasm(buf,code,address+x*4);
                printf("%08x: %08x %s\n",address+x*4,(int)code,buf);
            }
            dumpreg = 1;
            address += 16*4;
            }
            break;
        case 'd':
            {
            int    x,z;
            UINT8 *y;
            if (ncmd == 1) address = PC;
            y = getaddr(address);
            if (y==NULL) {
                printf("Unavailable\n");
                break;
            }
            dumpreg = 0;
            y += (address & 0x1FFFFF);
            for (z=0;z<8;z++)
            {
                printf("%08x: ",address+z*16);
                for (x=0;x<16;x++)
                    printf("%02x ",*(y+x));
                for (x=0;x<16;x++)
                    if (y[x] >= 32 && y[x] < 128) printf("%c",y[x]);
                                             else printf(".");
                printf("\n");
                y += 16;
            }
            dumpreg = 1;
            address += 16*8;
            }
            break;
        case 'r':
            if (ncmd == 1) {
                watch(-1);
                printf("breakpoint: %sable at %08x\n",(brkp)?"en":"dis",brkadr);
                break;
            }
            if (ncmd == 3) reg.r[address] = val;
            watch(address);
            break;
        case 'c':
            if (ncmd == 1) {
                watchcop(3);
            } else watchcop(address);
            break;
        case 'g':
            {
            int x;
            FPSE_Flags &= ~(VERBOSE | DISASMFLG);
            while(!stop)
             {
                if (update_counter()) Interrupt();
                for (x=0;x<16;x++) {
                    doInst();
                    if (brkp == 1 && PC == brkadr) break;
                }
                if (brkp == 1 && PC == brkadr) break;
            }
            if (stop)
            {
                printf("FATAL ERROR during exe - PC=%08x\n",(int)PC);
                return;
            }
            }
            break;
        case 's':
            if (update_counter()) Interrupt();
            doInst();
            if (stop) {printf("FATAL ERROR during exe\n"); return; }
            break;
        case 'b':
            if (ncmd<2)
                {
                    brkp ^= 1;
                    break;
                }
            brkadr=address;
            brkp = 1;
            break;
        case 'h':
            printf("%s",str_hlp);
            break;
        case 'q':
            fine = 0;
            break;
        default:
            printf("unknow command.\n");
            break;
        }

    }
}
