#include <string.h>

#include "type.h"
#include "poly2.h"
#include "linuxdef.h"
#include "gpu.h"

#ifdef MSB_FIRST
#define SWAP16(val) ({ UINT16 x = val; x = (x << 8) | (x >> 8); x; })
#define SWAP32(val) ({ UINT32 x = val; x = (x << 24) | ((x << 8) & 0xff0000) | ((x >> 8) & 0xff00) | (x >> 24); x; })
#else
#define SWAP16(val) val
#define SWAP32(val) val
#endif

#define PAL         0
#define SYSLOGOUT   0

#define FRAME_W     1024
#define FRAME_H     512

#define SIGN(code,basebit,bit)   (int)( (code)<<(32-basebit-bit) ) >> (32-bit)
#define RAMADR(addr)            ((void*)&ram[addr&0x1fffff])
#define do_prim(prim)           primfunc[*(UINT32*)prim>>24](prim)

#define XMIN    gpu.clip_min.x
#define XMAX    gpu.clip_max.x
#define YMIN    gpu.clip_min.y
#define YMAX    gpu.clip_max.y
#define OFFX    gpu.drawoffset.x
#define OFFY    gpu.drawoffset.y

enum { NOTRANS, MEM2VRAM, VRAM2MEM };

typedef struct {
    int x,y;
} POS;

typedef struct {
    int x,y,w,h;
} AREA;

typedef struct {
    UINT32  status;
    UINT32  info[8];

    POS     drawoffset;
    AREA    screen;
    AREA    disp;
    POS     clip_min;
    POS     clip_max;
    AREA    texwindow;

/* primtive recieve buffer */
    UINT32  primdata[16];
    int     primsize;
    int     primptr;
    int     retval;
    int     tpage;
} GPU_Type;

// Global vars
extern GPU_Type  gpu;
extern INT16    *vram;
extern UINT8    *ram;
extern UINT8     primsizeT[256];
extern int       px,py;
extern int       x_start,y_start,x_end,y_end;
extern UINT8     inTrans,toUpdate;
extern UINT16   *pvram;
extern int     (*primfunc[256])();
FPSELinux	*FpseInfo; 

typedef struct DisplayStruct {
    int (*init)();
    void (*exit)();
    void (*open_window)(unsigned int w,unsigned int h);
    void (*resize)(unsigned int w,unsigned int h);
    void (*change_title)(char *title);
    void (*render_frame)(UINT32 *image, int start, int endw);
    int (*key_pressed)();
    UINT16 (*get_key)();
} DisplayStruct;

#define km_s	512	/* keymap size */
#define RMASK (0x1f)
#define GMASK (0x1f<<5)
#define BMASK (0x1f<<10)
#define AMASK 0
#define INI_CHECK(value,var)	if (!strcasecmp(value,"on")) var = 1; \
				else if (!strcasecmp(value,"off")) var = 0; \
				else if (!strcasecmp(value,"1")) var = 1; \
				else if (!strcasecmp(value,"0")) var = 0; \
				else var = 0

// gpumain.c
int tpage_changed(int tpage);
int clut_changed(int clut);
void vramchange(int x0,int y0,int x1,int y1);
void* get_clutcache(int clut,int size,int color);
void* get_tcache(int tpage);

// win.c
void screen_update();
void *win_createbitmap(int w,int h,int bits);
void win_resize(int w, int h);
void win_destroy(void);
void soft_scale(UINT16 *scr,int sw,int sh,UINT16 *dst,int dw,int dh);

// cache.c
void CacheInit(void);
void CacheDeinit(void);
INT16 *get_texture(UINT32 tpage, UINT32 clut);