#include <windows.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "type.h"
#include "init.h"

#define DATASIZE    1024  // size of destination buffer

// declare global variables
static char INI_Name[256];      // self-explanatory
static char LocalBuf[DATASIZE]; // storage area for data found

static char IniDefault[] = "\0"; // default string if no data or key,
                                 // or section is found.


int INI_Load(char *nf)
{
    int f;

    strcpy(INI_Name,nf);
    f = open(nf,O_RDONLY | O_BINARY);
    if (f==-1) return FPSE_ERR;
    close(f);
    return FPSE_OK;
}

int INI_Save(char *nf)
{
    return FPSE_OK;
}

void INI_Free() {}

int INI_Read(char *Section, char *Entry, char *Value)
{
    GetPrivateProfileString( Section,    // points to section name 
                             Entry,      // points to key name 
                             IniDefault, // points to default string 
                             LocalBuf,   // points to destination buffer 
                             DATASIZE,   // size of destination buffer 
                             INI_Name    // points to ini file name 
                           );
    strcpy(Value,LocalBuf);
    return FPSE_OK;
}

int INI_Write(char *Section, char *Entry, char *Value)
{
    WritePrivateProfileString( Section, // pointer to section name 
                               Entry,   // pointer to key name 
                               Value,   // pointer to string to add 
                               INI_Name // pointer to ini file name 
                             );
    return FPSE_OK;
}
