#include "fpse.h"
#include "poly2.h"

#define PAL         0
#define FRAMESKIP   0
#define SYSLOGOUT   0

#define FRAME_W     1024
#define FRAME_H     512

#define SIGN(code,basebit,bit)   (int)( (code)<<(32-basebit-bit) ) >> (32-bit)
#define RAMADR(addr)            ((void*)&ram[addr&0x1fffff])
#define do_prim(prim)           primfunc[*(UINT32*)prim>>24](prim)

#define XMIN    gpu.clip_min.x
#define XMAX    gpu.clip_max.x
#define YMIN    gpu.clip_min.y
#define YMAX    gpu.clip_max.y
#define OFFX    gpu.drawoffset.x
#define OFFY    gpu.drawoffset.y

enum { NOTRANS, MEM2VRAM, VRAM2MEM };

typedef struct {
    int x,y;
} POS;

typedef struct {
    int x,y,w,h;
} AREA;

typedef struct {
    UINT32  status;
    UINT32  info[8];

    POS     drawoffset;
    AREA    screen;
    AREA    disp;
    POS     clip_min;
    POS     clip_max;
    AREA    texwindow;

/* primtive recieve buffer */
    UINT32  primdata[16];
    int     primsize;
    int     primptr;
    int     retval;
    int     tpage;
} GPU_Type;

// Global vars
extern GPU_Type  gpu;
extern INT16    *vram;
extern UINT8    *ram;
extern UINT8     primsizeT[256];
extern int       px,py;
extern int       x_start,y_start,x_end,y_end;
extern UINT8     inTrans,toUpdate;
extern UINT16   *pvram;
extern int     (*primfunc[256])();

// gpumain.c
int tpage_changed(int tpage);
int clut_changed(int clut);
void vramchange(int x0,int y0,int x1,int y1);
void* get_clutcache(int clut,int size,int color);
void* get_tcache(int tpage);

// win.c
void screen_update();
void *win_createbitmap(int w,int h,int bits);
void win_resize(int w, int h);
void win_destroy(void);

// cache.c
void CacheInit(void);
void CacheDeinit(void);
INT16 *get_texture(UINT32 tpage, UINT32 clut);