#include "fpse.h"

extern int joy0_ret;

static char *padbuf0 = NULL;
static char *padbuf1 = NULL;

// This Function is called when emulator starts
int JOY0_Open(UINT32 *joy)
{
  // Nothing to do here
  return FPSE_OK;
}

// This Function is called when emulator is closed
void JOY0_Close()
{
  // Nothing to do here
}

// This function is called when the gamepad should vibrate:
// if (motor != 0) then vibrate(on) else vibrate(off)
void JOY0_Vibrate(int motor)
{
}

// Return status of buttons (see joydrv.h)
void JOY0_Poll()
{
  padbuf0[3] = joy0_ret >> 8;
  padbuf0[4] = joy0_ret;
}

int JOY0_InitHeader(char *buf)
{
  padbuf0 = buf;
  buf[1] = 0x41;
  buf[2] = 0x5A;
  return 5;
}

// This Function is called when emulator starts
int JOY1_Open(UINT32 *joy)
{
  // Nothing to do here
  return FPSE_OK;
}

// This Function is called when emulator is closed
void JOY1_Close()
{
  // Nothing to do here
}

// This function is called when the gamepad should vibrate:
// if (motor != 0) then vibrate(on) else vibrate(off)
void JOY1_Vibrate(int motor)
{
}

// Return status of buttons (see joydrv.h)
void JOY1_Poll()
{
  padbuf1[3] = 0xFF;
  padbuf1[4] = 0xFF;
}

int JOY1_InitHeader(char *buf)
{
  padbuf1 = buf;
  buf[1] = 0x41;
  buf[2] = 0x5A;
  return 5;
}