#include <stdio.h>
#include <string.h>
#include <dlfcn.h>

#include "type.h"
#include "linuxdef.h"

FPSELinuxAbout info;
FPSELinux conf;

void list_plugin(char *plugin,char *type) {
    void *h = NULL;
    void (*rdi)(UINT32 *par);
    char func[32];

    if ((h = dlopen(plugin, RTLD_NOW | RTLD_GLOBAL )) == NULL) {
	printf ("%s\n",dlerror());
	return;
    }

    sprintf (func,"%s_About",type);
    if ((rdi = dlsym(h, func)) != NULL) {
	rdi((UINT32*)&info);

	printf ("\033[01;34m");
	printf ("Name: \"%s\"\n",info.Name);
	printf ("Version: %d.%d\n",info.VerHi,info.VerLo);
	if (info.TestResult) printf ("\033[01;31m");
	printf ("Plugin will %s\n",info.TestResult == 0 ? "work" : "not work");
	if (info.TestResult) printf ("\033[01;34m");
	printf ("Author: \"%s\"\n",info.Author);
	printf ("Description:\n\"%s\"\n",info.Description);
	printf ("\033[0m");
    }
    else printf ("Error getting %s from %s\n",func,plugin);
    sprintf (func,"%s_Configure",type);
    if ((rdi = dlsym(h, func)) != NULL) {
	rdi((UINT32*)&conf);
    }
    else printf ("Error getting %s from %s\n",func,plugin);

/*    dlclose(h); // why if this is uncommented the program makes a
		     'segmentation fault' */
}
