#include <aalib.h>
#include <string.h>
#include <ctype.h>
#include "gpulocal.h"
#include "keyboard.h"

static aa_context *aa_ctx;
static aa_renderparams *parms;
static int cur_width,cur_height;
static UINT16 keybkey = 0;
static int lastev = -1;	/* as almost every driver of aa_lib has no RELEASED_KEY make it */

static int dsp_init();
static void dsp_exit();
static void dsp_open_window(unsigned int w,unsigned int h);
static void dsp_resize(unsigned int w,unsigned int h);
static void dsp_change_title(char *title);
static void dsp_render_frame(UINT32 *image,int start,int endw);
static int dsp_key_pressed();
static UINT16 dsp_get_key();


DisplayStruct Dsp_AA = {
	dsp_init,
	dsp_exit,
	dsp_open_window,
	dsp_resize,
	dsp_change_title,
	dsp_render_frame,
	dsp_key_pressed,
	dsp_get_key
};

static int dsp_init() {
	aa_ctx = aa_autoinit(&aa_defparams);
	if (aa_ctx == NULL) return -1;
	aa_recommendhikbd("curses"); /* with slang keyboard escape doesn't works */
	if (!aa_autoinitkbd(aa_ctx,0/*AA_SENDRELEASE*/)) { aa_close(aa_ctx); return -1;}
	parms = aa_getrenderparams();
	return 0;
}

static void dsp_open_window(unsigned int w,unsigned int h) {
	cur_width=w;
	cur_height=h;
}

static void dsp_resize(unsigned int w,unsigned int h) {
	dsp_open_window(w,h);
}

static void dsp_exit() {
	aa_uninitkbd(aa_ctx);
	aa_close(aa_ctx);
}
static void dsp_change_title(char *title) {
}

static void dsp_render_frame(UINT32 *image,int start,int endw) {
	int x,y,c;
	UINT16 *vr,sc[aa_imgwidth(aa_ctx)*aa_imgheight(aa_ctx)];	

	vr = (UINT16*)(image+start);

	soft_scale(vr,cur_width,cur_height,sc,aa_imgwidth(aa_ctx),aa_imgheight(aa_ctx));

	vr = sc;

	for (y=0;y<aa_imgheight(aa_ctx);y++)
	    for (x=0;x<aa_imgwidth(aa_ctx);x++)
		{
		c = *(vr++);
		c = ((c&0x18)>>3) | ((c&0x300)>>6) | ((c&0x6000)>>9);
		aa_putpixel(aa_ctx,x,y,c);
		}

	aa_render(aa_ctx,parms,0,0,aa_imgwidth(aa_ctx),aa_imgheight(aa_ctx));
	aa_flush(aa_ctx);
}

static int dsp_key_pressed() {
	int ev;
	static int i;

	if (lastev != -1) {
	    i++;
	    if (i>10) { /* this should be changed */
		i=0;
		switch (lastev) {
		    case AA_UP: keybkey = KEY_UP; break;
	    	    case AA_DOWN: keybkey = KEY_DOWN; break;
		    case AA_LEFT: keybkey = KEY_LEFT; break;
	    	    case AA_RIGHT: keybkey = KEY_RIGHT; break;
		    case AA_ESC: keybkey = KEY_ESCAPE; break;
	    	    case AA_BACKSPACE: keybkey = KEY_BACKSPACE; break;
		    default: keybkey = lastev;
		}
		lastev = -1;
		return RELEASED_KEY;
	    }
	}

	ev = aa_getevent(aa_ctx,0);
	
	if ((ev == AA_NONE) || (ev == AA_UNKNOWN)) return NO_KEY;

	switch (ev) {
	    case AA_UP: keybkey = KEY_UP; break;
	    case AA_DOWN: keybkey = KEY_DOWN; break;
	    case AA_LEFT: keybkey = KEY_LEFT; break;
	    case AA_RIGHT: keybkey = KEY_RIGHT; break;
	    case AA_ESC: keybkey = KEY_ESCAPE; break;
	    case AA_BACKSPACE: keybkey = KEY_BACKSPACE; break;
	    default: keybkey = ev;
	}
	lastev = ev;
	return PRESSED_KEY;
}

static UINT16 dsp_get_key() {
	return keybkey;
}
