#ifndef _GPU_H_
#define _GPU_H_

// Starting functions
int  GPU_Open(UINT32 *gpu);
void GPU_Close(void);

// I/O GPU ports
UINT32 GP0_Read(void);
UINT32 GP1_Read(void);
void   GP0_Write(UINT32 data);
void   GP1_Write(UINT32 code);

// Refresh function
void GPU_Update(void);

// Dma function
void GPU_DmaExec(UINT32 adr,UINT32 bcr,UINT32 chcr);

// ScreenShot
void GPU_ScreenShot(char *path);

// High level functions
int  GPU_Configure(UINT32 *par);
void GPU_About(UINT32 *par);

#endif
