/*
 * FPSE linux window routines
 *
 * STATUS: X11, SVGA, AAlib and SDL works fine.
 *
 * BUGS: Alpha mask is probably wrong. 
 *		 Should do direct draw. Doesn't.
 *	 FullScreen is really slow.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#include "gpulocal.h"
#include "config.h"
#include "keyboard.h"

#ifdef COMPILE_X11
extern DisplayStruct Dsp_X11;
#endif
#ifdef COMPILE_VGA
extern DisplayStruct Dsp_VGA;
#endif
#ifdef COMPILE_AA
extern DisplayStruct Dsp_AA;
#endif
#ifdef COMPILE_SDL
extern DisplayStruct Dsp_SDL;
#endif

DisplayStruct *Displays[] = {
#ifdef COMPILE_SDL
&Dsp_SDL,
#endif
#ifdef COMPILE_X11
&Dsp_X11,
#endif
#ifdef COMPILE_VGA
&Dsp_VGA,
#endif
#ifdef COMPILE_AA
&Dsp_AA,
#endif
NULL // end of displays
};

DisplayStruct Dsp;
static int FullScreen = 0;
#define fullscrW	640
#define fullscrH	480
static int FpsCount = 0;
static int NoRender = 0;

/* Misc variables */
int (*key_pressed)();	/* needed for joystick */
UINT16 (*get_key)();
int joy0_ret;		/* handled by joy0 */

/* CGFX variables */
static char *buffer;
static int CurW;
static int CurH;
static int endW;

static int framecount = 0;
static int frameskip = 0;


void win_resize(int w,int h)
{
//	fprintf(stderr, "DEBUG: win_resize\n");
    if ((CurW == w) && (CurH == h)) return;
    if (!FullScreen) Dsp.resize(w,h);
    else Dsp.resize(fullscrW,fullscrH);
    CurW=w;
    CurH=h;
}

void screen_update()
{
static struct timeval tvi;
struct timeval tvf;
static long nf = 0;
float titi;
char title[256];

if(++framecount>frameskip)
    {
    if (FpsCount) {
	gettimeofday(&tvf,0);
	titi = (tvf.tv_sec-tvi.tv_sec)+(tvf.tv_usec-tvi.tv_usec)/1000000.0;
	if (titi > 1.0)
	    {
	    tvi=tvf;
	    sprintf (title,"FPSE -- %dx%d -- %.1f FPS -- (Skip=%d)",CurW,CurH,nf/titi,frameskip);
	    Dsp.change_title(title);
	    nf=0;
	    }
	nf++;
    }
    if (!NoRender) {
	if (!FullScreen) Dsp.render_frame((UINT32*)buffer,0,endW);
	else {
	    UINT16 tmp[fullscrW*fullscrH];
	    soft_scale((UINT16*)buffer,CurW,CurH,tmp,fullscrW,fullscrH);
	    Dsp.render_frame((UINT32*)tmp,0,fullscrW);
	}
    }
    framecount=0;
    if (joy0_ret) {
	switch (joy0_ret) {
	    case KEY_F6: FullScreen = 1 - FullScreen;
			 if (!FullScreen) Dsp.resize(CurW,CurH);
			 else Dsp.resize(fullscrW,fullscrH);
			 break;
	    case KEY_F7: FpsCount = 1 - FpsCount; Dsp.change_title("FPSE");
			 break;
	    case KEY_F8: NoRender = 1 - NoRender; break;
	    case KEY_KP_PLUS:
	    case KEY_PLUS: frameskip++; break;
	    case KEY_KP_MINUS:
	    case KEY_MINUS: frameskip--; break;
	}
	joy0_ret = 0;
    }
    }
}

void *win_createbitmap(int w,int h,int bits)
{
    int i;
    char Value[64];

    /* Configuration variables from fpse.ini */ 

    if (FpseInfo->ReadCfg("GPULSOFT","FullScreen",Value) == FPSE_OK)
	INI_CHECK(Value,FullScreen);
    else
	FpseInfo->WriteCfg("GPULSOFT","FullScreen","Off");

    if (FpseInfo->ReadCfg("GPULSOFT","FpsCount",Value) == FPSE_OK)
	INI_CHECK(Value,FpsCount);
    else
	FpseInfo->WriteCfg("GPULSOFT","FpsCount","Off");

    if (FpseInfo->ReadCfg("GPULSOFT","FrameSkip",Value) == FPSE_OK)
	frameskip = strtol(Value,(char**)NULL,0);
    else
	FpseInfo->WriteCfg("GPULSOFT","FrameSkip","0");

    /* End of Configurations */

    for (i=0; Displays[i]!=NULL; i++)
        if (!Displays[i]->init()) {
	    Dsp = *Displays[i];
	    buffer = (char *)malloc(w*h*(bits/8));
	    if (buffer == NULL) return NULL;
	    endW = w;
	    Dsp.open_window(640,480);
	    Dsp.change_title("FPSE");
	    key_pressed = Dsp.key_pressed;
	    get_key = Dsp.get_key;
	    return (void *)buffer;
	}
    printf ("no Dsp avail\n");
    return NULL;
}

void win_destroy(void)
{
    Dsp.exit();
}

void soft_scale (UINT16 *src, int sw, int sh,
		 UINT16 *dst, int dw, int dh) {
	int x,y,i;
	float xs,ys,xx,yy;

	xs = (float)dw / sw;
	ys = (float)dh / sh;

	if ((xs==1) & (ys==1)) {
		for (y=0; y<dh; y++) {
		    for (x=0; x<dw; x++) *(dst++) = *(src++);
		    src+=1024-sw;
		}
	    return;
	    }

	yy = 0;
	for (y=0; y<sh; y++) {
	    xx = 0;
	    yy += ys;
	    if (yy >= 1) {
		for (x=0; x<sw; x++) {
		    xx += xs;
		    if (xx >= 1) {
			for (i=0; i<(int)xx; i++) {
			    int j;

			    for (j=0; j<(int)yy; j++) 
			        *(dst+(dw*j)) = *src;
			    dst++;
			}
			src++;
			xx -= (int)xx;
		    }
		    else src++;
		}
		for (i=1; i<(int)yy; i++) {
 		    dst+=dw;
		}
		yy -= (int)yy;
 		src+=1024-sw;
	    }
	    else src+=1024;
	}
}
