#include	<windows.h>
#include	<stdio.h>
#include	<string.h>
#include	<ddraw.h>

#include	"common.h"
#include	"resource.h"
#include	"ini.h"
#include	"xmil.h"
#include	"draw.h"
#include	"ddraws.h"
#include	"menu.h"
#include	"palettes.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"mouses.h"
#include	"dclock.h"

static	RECT	rect200 = {0, 0, SCREEN_WIDTH, SCREEN_HEIGHT};
static	RECT	rectdraw1 = {0, 0, SCREEN_WIDTH, 1};
extern	HWND	hWndMain;

static	LPDIRECTDRAW			pDDraw1 = NULL;
static	LPDIRECTDRAW2			pDDraw = NULL;
static	LPDIRECTDRAWSURFACE		pPrimSurf = NULL;
static	LPDIRECTDRAWSURFACE		pBackSurf = NULL;
static	LPDIRECTDRAWSURFACE		pClockSurf = NULL;
static	LPDIRECTDRAWCLIPPER		pClipper = NULL;
static	LPDIRECTDRAWPALETTE		pPalette = NULL;
static	PALETTEENTRY			winpal[256];
static	BYTE					allflash = 0;

static	BYTE	palchanged = 0;
static	BYTE	setscmd = 0;
		BYTE	SCREENMODE = 0;
		BYTE	drawingmode = 0;

		int				xm_palettes = 0;
		PALETTE_TABLE	xm_palette[256];
		BYTE			screenmap[SCREEN_WIDTH * SCREEN_HEIGHT];
		BYTE			renewalline[SCREEN_HEIGHT+4];
		BYTE			x2mode = X2MODE_WIDTH40;
		WORD			putlines = SCREEN_HEIGHT;
		WORD			xmil_pal16[256];

extern	int				winx, winy;
static	int				winw = 640;
static	int				winh = 400;

__inline void fillrenewalline(DWORD value) {

	int		cnt = SCREEN_HEIGHT / 4;
	DWORD	*p = (DWORD *)renewalline;
	while(cnt--) {
		*p++ |= value;
	}
}

void ddraws_initwindowsize(WORD width, WORD height) {

	RECT	rectWindow, rectClient;
	int		scx, scy;

	GetWindowRect(hWndMain, &rectWindow);
	GetClientRect(hWndMain, &rectClient);
	winw = width + (rectWindow.right - rectWindow.left)
					- (rectClient.right - rectClient.left);
	winh = height + (rectWindow.bottom - rectWindow.top)
					- (rectClient.bottom - rectClient.top);

	scx = GetSystemMetrics(SM_CXSCREEN);
	scy = GetSystemMetrics(SM_CYSCREEN);

	if (scx < winw) {
		INIT_RENEWAL
			winx = (scx - winw) / 2;
	}
	else if (winx < 0) {
		INIT_RENEWAL
			winx = 0;
	}
	else if ((winx + winw) > scx) {
		INIT_RENEWAL
			winx = scx - winw;
	}
	if (scy < winh) {
		INIT_RENEWAL
			winy = (scy - winh) / 2;
	}
	else if (winy < 0) {
		INIT_RENEWAL
			winy = 0;
	}
	else if ((winy + winh) > scy) {
		INIT_RENEWAL
			winy = scy - winh;
	}
}



BYTE ddraws_setscreenmode(BYTE mode) {

	BYTE	ret = FALSE;

	if (mode & SCMD_SETWINDOWED) {
		if (!(SCREENMODE & SCMD_WINDOWED)) {
			setscmd |= SCMD_SETWINDOWED;
			ret = TRUE;
		}
	}
	else if (mode & SCMD_SETFULLSCREEN) {
		if (!(SCREENMODE & SCMD_FULLSCRN)) {
			setscmd &= (~SCMD_SETWINDOWED);
			ret = TRUE;
		}
	}
	if (mode & SCMD_SET256) {
		if (!(SCREENMODE & SCMD_USEPAL)) {
			setscmd |= SCMD_SET256;
			ret = TRUE;
		}
	}
	else if (mode & SCMD_SET65536) {
		if (!(SCREENMODE & SCMD_NONPAL)) {
			setscmd &= (~SCMD_SET256);
			ret = TRUE;
		}
	}
	return(ret);
}


void ddraws_windowstats(void) {

	DWORD	winstyle, winstyleex;
	HMENU	hmenu = GetMenu(hWndMain);

	winstyle = GetWindowLong(hWndMain, GWL_STYLE);
	winstyleex = GetWindowLong(hWndMain, GWL_EXSTYLE);
	if (setscmd & SCMD_SETWINDOWED) {
		winstyle = (winstyle | WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU)
																& ~WS_POPUP;
		winstyleex &= ~WS_EX_TOPMOST;
		SetWindowLong(hWndMain, GWL_STYLE, winstyle);
		SetWindowLong(hWndMain, GWL_EXSTYLE, winstyleex);

		MoveWindow(hWndMain, winx, winy, winw, winh, TRUE);

		CheckMenuItem(hmenu, IDM_WINDOW, MF_CHECKED);
		CheckMenuItem(hmenu, IDM_FULLSCREEN, MF_UNCHECKED);
	}
	else {
		winstyle = (winstyle | WS_POPUP)
						& (~(WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU));
		winstyleex |= WS_EX_TOPMOST;
		SetWindowLong(hWndMain, GWL_STYLE, winstyle);
		SetWindowLong(hWndMain, GWL_EXSTYLE, winstyleex);
		CheckMenuItem(hmenu, IDM_WINDOW, MF_UNCHECKED);
		CheckMenuItem(hmenu, IDM_FULLSCREEN, MF_CHECKED);
	}
}


void ddraws_wincenter(void) {

	INIT_RENEWAL
		winx = (GetSystemMetrics(SM_CXSCREEN) - winw) / 2;
		winy = (GetSystemMetrics(SM_CYSCREEN) - winh) / 2;
	MoveWindow(hWndMain, winx, winy, winw, winh, TRUE);
}


void ddraws_init(void) {

	ZeroMemory(screenmap, sizeof(screenmap));
	ZeroMemory(xm_palette, sizeof(xm_palette));
	xm_palettes = 0;
	allflash = 1;
	fillrenewalline(0x03030303);
	xmenu_setwidth(x2mode);
}

void ddraws_change_palette(void) {

	if (SCREENMODE & SCMD_USEPAL) {
		palchanged = 1;
		fillrenewalline(0x02020202);
	}
	else {
		if ((SCREENMODE & SCMD_COLORMASK) == SCMD_COLOR16) {
			pal_cnv16pal(xmil_pal16, (DWORD *)xm_palette, xm_palettes);
		}
		fillrenewalline(0x03030303);
	}
}


static void palette_init(void) {

	BYTE	i;
	HDC 	hdc = GetDC(hWndMain);

	GetSystemPaletteEntries(hdc, 0, 256, winpal);
	ReleaseDC(hWndMain, hdc);

	for (i=START_PAL; i<(START_PAL + TOTAL_PALS); i++) {
		winpal[i].peFlags = PC_RESERVED | PC_NOCOLLAPSE;
	}
	for (i=0; i<4; i++) {
		winpal[i+START_PAL+TOTAL_PALS].peBlue = dclock_pal[i].p.b;
		winpal[i+START_PAL+TOTAL_PALS].peRed = dclock_pal[i].p.r;
		winpal[i+START_PAL+TOTAL_PALS].peGreen = dclock_pal[i].p.g;
		winpal[i+START_PAL+TOTAL_PALS].peFlags = PC_RESERVED | PC_NOCOLLAPSE;
	}
	reflesh_palette();
	pDDraw->CreatePalette(DDPCAPS_8BIT, winpal, &pPalette, 0);
	pPrimSurf->SetPalette(pPalette);
	palchanged = 0;
}


static void palette_set(void) {

	int		i;

	if ((pPalette != NULL) && (xm_palettes)) {
		for (i=0; i<xm_palettes; i++) {
			winpal[i+START_PAL].peRed = xm_palette[i].p.r;
			winpal[i+START_PAL].peBlue = xm_palette[i].p.b;
			winpal[i+START_PAL].peGreen = xm_palette[i].p.g;
		}
		pPalette->SetEntries(0, START_PAL, xm_palettes, &winpal[START_PAL]);
	}
}


void clearblankarea(void) {

	DDBLTFX		ddbf;
	RECT		fill1rect = {0, 0, FULLSCREEN_WIDTH, FULLSCREEN_POSY};
	RECT		fill2rect = {0, FULLSCREEN_HEIGHT - FULLSCREEN_POSY,
								FULLSCREEN_WIDTH, FULLSCREEN_HEIGHT};

	ZeroMemory(&ddbf, sizeof(ddbf));
	ddbf.dwSize = sizeof(ddbf);
	ddbf.dwFillColor = 0;
	pPrimSurf->Blt(&fill1rect, NULL, NULL, DDBLT_COLORFILL, &ddbf);
	pPrimSurf->Blt(&fill2rect, NULL, NULL, DDBLT_COLORFILL, &ddbf);
	dclock_redraw();
}


int ddraws_InitDirectDraw(void) {

	DDSURFACEDESC	ddsd;
	DDPIXELFORMAT	ddpf;
	int				bitcolor;

	pDDraw1 = NULL;
	pDDraw = NULL;
	pPrimSurf = NULL;
	pBackSurf = NULL;
	pClockSurf = NULL;
	pClipper = NULL;
	pPalette = NULL;
	palchanged = 0;
	SCREENMODE = 0;

	if (DirectDrawCreate(NULL, &pDDraw1, NULL) != DD_OK) {
		return(FAILURE);
	}
	pDDraw1->QueryInterface(IID_IDirectDraw2, (void **)&pDDraw);

	if (setscmd & SCMD_SETWINDOWED) {
		pDDraw->SetCooperativeLevel(hWndMain, DDSCL_NORMAL);

		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

		if (pDDraw->CreateSurface(&ddsd, &pPrimSurf, NULL) != DD_OK) {
			return(FAILURE);
		}

		pDDraw->CreateClipper(0, &pClipper, NULL);
		pClipper->SetHWnd(0, hWndMain);
		pPrimSurf->SetClipper(pClipper);

		ZeroMemory(&ddpf, sizeof(ddpf));
		ddpf.dwSize = sizeof(DDPIXELFORMAT);
		if (DD_OK != pPrimSurf->GetPixelFormat(&ddpf)) {
			return(FAILURE);
		}

		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwWidth = SCREEN_WIDTH;
		ddsd.dwHeight = SCREEN_HEIGHT;

		if (pDDraw->CreateSurface(&ddsd, &pBackSurf, NULL) != DD_OK) {
			return(FAILURE);
		}
		if (ddpf.dwRGBBitCount == 8) {
			SCREENMODE |= SCMD_WINDOW8;
			palette_init();
		}
		else if (ddpf.dwRGBBitCount == 16) {
			SCREENMODE |= SCMD_WINDOW16;
			pal_make16mask(ddpf.dwBBitMask, ddpf.dwRBitMask, ddpf.dwGBitMask);
			reflesh_palette();
		}
		else if (ddpf.dwRGBBitCount == 24) {
			SCREENMODE |= SCMD_WINDOW24;
			reflesh_palette();
		}
		else if (ddpf.dwRGBBitCount == 32) {
			SCREENMODE |= SCMD_WINDOW32;
			reflesh_palette();
		}
		else {
			return(FAILURE);
		}
	}
	else {
		dclock_init();
		pDDraw->SetCooperativeLevel(hWndMain,
					DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT);
		if (setscmd & SCMD_SET256) {
			bitcolor = 8;
		}
		else {
			bitcolor = 16;
		}
		if (pDDraw->SetDisplayMode(FULLSCREEN_WIDTH, FULLSCREEN_HEIGHT,
												bitcolor, 0, 0) != DD_OK) {
			return(FAILURE);
		}
		pDDraw->CreateClipper(0, &pClipper, NULL);
		pClipper->SetHWnd(0, hWndMain);

		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
		if (pDDraw->CreateSurface(&ddsd, &pPrimSurf, NULL) != DD_OK) {
			return(FAILURE);
		}
		clearblankarea();

		ZeroMemory(&ddpf, sizeof(ddpf));
		ddpf.dwSize = sizeof(DDPIXELFORMAT);
		if (pPrimSurf->GetPixelFormat(&ddpf) != DD_OK) {
			return(FAILURE);
		}

		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwWidth = FULLSCREEN_WIDTH;
		ddsd.dwHeight = SCREEN_HEIGHT;
		if (pDDraw->CreateSurface(&ddsd, &pBackSurf, NULL) != DD_OK) {
			return(FAILURE);
		}
		if (bitcolor == 8) {
			SCREENMODE |= SCMD_FSCREEN8;
			palette_init();
			dclock_init8();
		}
		else {
			SCREENMODE |= SCMD_FSCREEN16;
			pal_make16mask(ddpf.dwBBitMask, ddpf.dwRBitMask, ddpf.dwGBitMask);
			ddraws_change_palette();
			reflesh_palette();
			dclock_init16();
		}

		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwWidth = DCLOCK_X;
		ddsd.dwHeight = DCLOCK_Y;
		if (pDDraw->CreateSurface(&ddsd, &pClockSurf, NULL) != DD_OK) {
			pClockSurf = NULL;
		}
		dclock_reset();
	}
	return(SUCCESS);
}


void ddraws_TermDirectDraw(void) {

	if ((SCREENMODE & SCMD_FULLSCRN) && (pDDraw)) {
//		pDDraw->RestoreDisplayMode();
		pDDraw->SetCooperativeLevel(hWndMain, DDSCL_NORMAL);
	}
	RELEASE(pClockSurf);
	RELEASE(pBackSurf);
	RELEASE(pPalette);
	RELEASE(pClipper);
	RELEASE(pPrimSurf);
	RELEASE(pDDraw);
	RELEASE(pDDraw1);
}

void ddraws_change_drawlines(DWORD lines) {

	if (lines > SCREEN_HEIGHT) {
		lines = SCREEN_HEIGHT;
	}
	rect200.bottom = lines;
	allflash = 1;
}

void clearblanklines(DWORD posx, DWORD posy) {

	DDBLTFX		ddbf;
	RECT		fillrect;

	fillrect.left = posx;
	fillrect.top = posy + rect200.bottom;
	fillrect.right = posx + SCREEN_WIDTH;
	fillrect.bottom = posy + SCREEN_HEIGHT;

	ZeroMemory(&ddbf, sizeof(ddbf));
	ddbf.dwSize = sizeof(ddbf);
	ddbf.dwFillColor = 0;
	pPrimSurf->Blt(&fillrect, NULL, NULL, DDBLT_COLORFILL, &ddbf);
}


		// DirectXŊg債Ȃ̂́ÃBfIJ[hɃoO()
void ddraws_draws(void) {

	DDSURFACEDESC	ddsd;

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	if (pBackSurf->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL) != DD_OK) {
		return;
	}

	__asm {
				pushf
				cld
				mov		ax, ds
				push	es
				mov		es, ax
				push	esi
				push	edi

				mov		esi, offset screenmap
				mov		edi, ddsd.lpSurface
				xor		edx, edx
				mov		ebx, offset renewalline
				xor		ecx, ecx

				mov		al, SCREENMODE
				and		al, SCMD_COLORMASK
				je		draw_color32						// 32bit
				dec		al
				je		draw_color24						// 24bit
				dec		al
				je		draw_color16						// 16bit

					cmp		x2mode, 0						// 8bit
					je		draw_color8x1

x2win8bppdrlp1:			btr		word ptr [ebx], 0
						jnc		x2win8bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH/4
x2win8bppdrlp2:			lodsw
						add		ax, 0x0101 * START_PAL
						stosb
						stosw
						mov		al, ah
						stosb
						loop	x2win8bppdrlp2
						pop		edi
						pop		esi
x2win8bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, SCREEN_HEIGHT
						jc		x2win8bppdrlp1
						jmp		draw_color_ed
draw_color8x1:
x1win8bppdrlp1:			btr		word ptr [ebx], 0
						jnc		x1win8bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH/4
x1win8bppdrlp2:			lodsd
						add		eax, (0x01010101 * START_PAL)
						stosd
						loop	x1win8bppdrlp2
						pop		edi
						pop		esi
x1win8bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, SCREEN_HEIGHT
						jc		x1win8bppdrlp1
						jmp		draw_color_ed

draw_color16:		or		al, x2mode
					je		draw_color16x1
					dec		al
					je		draw_color16x2

x4096_16bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x4096_16bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH/2
x4096_16bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		ah, [esi+320]
						mov		ax, word ptr GRPHPAL16bit[eax*2]
						stosw
						stosw
						inc		esi
						loop	x4096_16bppdrlp2
						pop		edi
						pop		esi
x4096_16bppdred:		add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x4096_16bppdrlp1
						jmp		draw_color_ed
draw_color16x2:
x2win16bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x2win16bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH/2
x2win16bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		ax, word ptr xmil_pal16[eax*2]
						stosw
						stosw
						inc		esi
						loop	x2win16bppdrlp2
						pop		edi
						pop		esi
x2win16bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x2win16bppdrlp1
						jmp		draw_color_ed
draw_color16x1:
x1win16bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x1win16bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH
x1win16bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		ax, word ptr xmil_pal16[eax*2]
						stosw
						inc		esi
						loop	x1win16bppdrlp2
						pop		edi
						pop		esi
x1win16bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x1win16bppdrlp1
						jmp		draw_color_ed

draw_color24:		or		al, x2mode
					je		draw_color24x1
					dec		al
					je		draw_color24x2

x4096_24bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x4096_24bppdred
						push	esi
						push	edi
						mov		cx, (SCREEN_WIDTH/2) - 1
x4096_24bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		ah, [esi+320]
						mov		eax, dword ptr GRPHPAL4096[eax*4]
						stosd
						dec		edi
						stosd
						dec		edi
						inc		esi
						loop	x4096_24bppdrlp2
						movzx	eax, byte ptr [esi]
						mov		ah, [esi+320]
						mov		eax, dword ptr GRPHPAL4096[eax*4]
						stosd
						dec		edi
						stosb
						shr		eax, 8
						stosw
						pop		edi
						pop		esi
x4096_24bppdred:		add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x4096_24bppdrlp1
						jmp		draw_color_ed
draw_color24x2:
x2win24bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x2win24bppdred
						push	esi
						push	edi
						mov		cx, (SCREEN_WIDTH/2) - 1
x2win24bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		eax, dword ptr xm_palette[eax*4]
						stosd
						dec		edi
						stosd
						dec		edi
						inc		esi
						loop	x2win24bppdrlp2
						movzx	eax, byte ptr [esi]
						mov		eax, dword ptr xm_palette[eax*4]
						stosd
						dec		edi
						stosb
						shr		eax, 8
						stosw
						pop		edi
						pop		esi
x2win24bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x2win24bppdrlp1
						jmp		draw_color_ed
draw_color24x1:
x1win24bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x1win24bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH - 1
x1win24bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		eax, dword ptr xm_palette[eax*4]
						stosd
						dec		edi
						inc		esi
						loop	x1win24bppdrlp2
						movzx	eax, byte ptr [esi]
						mov		eax, dword ptr xm_palette[eax*4]
						stosb
						shr		eax, 8
						stosw
						pop		edi
						pop		esi
x1win24bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x1win24bppdrlp1
						jmp		draw_color_ed

draw_color32:		or		al, x2mode
					je		draw_color32x1
					dec		al
					je		draw_color32x2

x4096_32bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x4096_32bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH/2
x4096_32bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		ah, [esi+320]
						mov		eax, dword ptr GRPHPAL4096[eax*4]
						stosd
						stosd
						inc		esi
						loop	x4096_32bppdrlp2
						pop		edi
						pop		esi
x4096_32bppdred:		add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x4096_32bppdrlp1
						jmp		draw_color_ed

draw_color32x2:
x2win32bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x2win32bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH/2
x2win32bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		eax, dword ptr xm_palette[eax*4]
						and		eax, 00ffffffh
						stosd
						stosd
						inc		esi
						loop	x2win32bppdrlp2
						pop		edi
						pop		esi
x2win32bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x2win32bppdrlp1
						jmp		draw_color_ed
draw_color32x1:
x1win32bppdrlp1:		btr		word ptr [ebx], 0
						jnc		x1win32bppdred
						push	esi
						push	edi
						mov		cx, SCREEN_WIDTH
x1win32bppdrlp2:		movzx	eax, byte ptr [esi]
						mov		eax, dword ptr xm_palette[eax*4]
						and		eax, 00ffffffh
						stosd
						inc		esi
						loop	x1win32bppdrlp2
						pop		edi
						pop		esi
x1win32bppdred:			add		esi, SCREEN_WIDTH
						add		edi, ddsd.lPitch
						inc		ebx
						inc		dx
						cmp		dx, putlines
						jc		x1win32bppdrlp1

draw_color_ed:	pop		edi
				pop		esi
				pop		es
				popf
	}
	pBackSurf->Unlock(NULL);
}


void ddraws_drawall(void) {

	POINT	pt;
	RECT	rectDst;

	if (SCREENMODE & SCMD_USEPAL) {
		if (palchanged) {
			palchanged = 0;
			palette_set();
		}
	}
	if (pBackSurf != NULL) {
		if (SCREENMODE & SCMD_FULLSCRN) {
			if (pPrimSurf->BltFast(0, FULLSCREEN_POSY, pBackSurf,
							&rect200, DDBLTFAST_WAIT) == DDERR_SURFACELOST) {
				pPrimSurf->Restore();
				pBackSurf->Restore();
			}
			if (allflash) {
				allflash = 0;
				clearblanklines(0, FULLSCREEN_POSY);
			}
		}
		else {
			pt.x = 0;
			pt.y = 0;
			ClientToScreen(hWndMain, &pt);
			SetRect(&rectDst, pt.x, pt.y, pt.x + SCREEN_WIDTH,
								pt.y + rect200.bottom);
			if (pPrimSurf->Blt(&rectDst, pBackSurf, &rect200,
									DDBLT_WAIT, NULL) == DDERR_SURFACELOST) {
				pPrimSurf->Restore();
				pBackSurf->Restore();
			}
			if (allflash) {
				allflash = 0;
				clearblanklines(pt.x, pt.y);
			}
		}
	}
}

BYTE ddraws_restore(void) {

	if (pBackSurf->IsLost() == DDERR_SURFACELOST) {
		pBackSurf->Restore();
		allflash = 1;
		fillrenewalline(0x03030303);
		return(1);
	}
	return(0);
}

void ddraws_palette(void) {

	if (pPalette) {
		pPrimSurf->SetPalette(pPalette);
	}
}


void ddraws_change_xmode(BYTE x2flag) {

	if (x2mode != x2flag) {
		x2mode = x2flag;
		xmenu_setwidth(x2mode);
		fillrenewalline(0x03030303);
	}
}

void ddraws_topwinui(void) {

	mouse_running(MOUSE_STOP);
	if (!(SCREENMODE & SCMD_WINDOWED)) {
#if 1
		pDDraw->FlipToGDISurface();
#endif
		pPrimSurf->SetClipper(pClipper);
	}
}

void ddraws_clearwinui(void) {

	if (!(SCREENMODE & SCMD_WINDOWED)) {
		pPrimSurf->SetClipper(0);
		clearblankarea();
	}
	mouse_running(MOUSE_CONT);
}


BYTE ddraws_draw1(DWORD linepos) {

	DDSURFACEDESC	ddsd;

	if (!(renewalline[linepos] & 2)) {
		return(0);
	}
	renewalline[linepos] ^= 2;

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	rectdraw1.top = linepos;
	rectdraw1.bottom = linepos + 1;

	if (pBackSurf->Lock(&rectdraw1, &ddsd, DDLOCK_WAIT, NULL) != DD_OK) {
		return(0);
	}
	__asm {
				mov		eax, SCREEN_WIDTH
				mul		dword ptr linepos
				lea		ebx, screenmap[eax]
				mov		edx, ddsd.lpSurface

				mov		al, SCREENMODE
				and		al, SCMD_COLORMASK
				je		d1_scrnbit32				// SCMD_COLOR32 == 0
				dec		al
				je		d1_scrnbit24				// SCMD_COLOR24 == 1
				dec		al
				je		d1_scrnbit16				// SCMD_COLOR16 == 2

					cmp		x2mode, 0
					je		d1_scrnbit8x1

						mov		cx, SCREEN_WIDTH/2
x2win8bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		al, byte ptr xm_palette[eax*4+3]
						mov		ah, al
						mov		[edx], ax
						inc		ebx
						add		edx, 2
						dec		cx
						jne		x2win8bppdrlp
						jmp		draw1lock

d1_scrnbit8x1:			mov		cx, SCREEN_WIDTH
x1win8bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		al, byte ptr xm_palette[eax*4+3]
						mov		[edx], al
						inc		ebx
						inc		edx
						dec		cx
						jne		x1win8bppdrlp
						jmp		draw1lock

d1_scrnbit16:		cmp		x2mode, 0
					je		d1_scrnbit16x1

						mov		cx, SCREEN_WIDTH/2
x2win16bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		ax, word ptr xmil_pal16[eax*2]
						mov		[edx], ax
						mov		[edx+2], ax
						inc		ebx
						add		edx, 4
						dec		cx
						jne		x2win16bppdrlp
						jmp		draw1lock

d1_scrnbit16x1:			mov		cx, SCREEN_WIDTH
x1win16bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		ax, word ptr xmil_pal16[eax*2]
						mov		[edx], ax
						inc		ebx
						add		edx, 2
						dec		cx
						jne		x1win16bppdrlp
						jmp		draw1lock

d1_scrnbit24:		cmp		x2mode, 0
					je		d1_scrnbit24x1

						mov		cx, (SCREEN_WIDTH/2) - 1
x2win24bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		eax, dword ptr xm_palette[eax*4]
						mov		[edx], eax
						mov		[edx+3], eax
						inc		ebx
						add		edx, 6
						dec		cx
						jne		x2win24bppdrlp
						movzx	eax, byte ptr [ebx]
						mov		eax, dword ptr xm_palette[eax*4]
						mov		[edx], eax
						mov		[edx+3], al
						shr		eax, 8
						mov		[edx+4], ax
						jmp		draw1lock

d1_scrnbit24x1:			mov		cx, SCREEN_WIDTH - 1
x1win24bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		eax, dword ptr xm_palette[eax*4]
						mov		[edx], eax
						inc		ebx
						add		edx, 3
						dec		cx
						jne		x1win24bppdrlp
						movzx	eax, byte ptr [ebx]
						mov		eax, dword ptr xm_palette[eax*4]
						mov		[edx], al
						shr		eax, 8
						mov		[edx+1], ax
						jmp		draw1lock

d1_scrnbit32:		cmp		x2mode, 0
					je		d1_scrnbit32x1

						mov		cx, SCREEN_WIDTH/2
x2win32bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		eax, dword ptr xm_palette[eax*4]
						and		eax, 00ffffffh
						mov		[edx], eax
						mov		[edx+4], eax
						inc		ebx
						add		edx, 8
						dec		cx
						jne		x2win32bppdrlp
						jmp		draw1lock

d1_scrnbit32x1:			mov		cx, SCREEN_WIDTH
x1win32bppdrlp:			movzx	eax, byte ptr [ebx]
						mov		eax, dword ptr xm_palette[eax*4]
						and		eax, 00ffffffh
						mov		[edx], eax
						inc		ebx
						add		edx, 4
						dec		cx
						jne		x1win32bppdrlp
draw1lock:
		}
	pBackSurf->Unlock(NULL);
	return(1);
}


void ddraws_redraw(void) {

	allflash = 1;
	palchanged = 1;
	fillrenewalline(0x03030303);
	palettes();
	ddraws_draws();
	ddraws_drawall();
}


// -------------------------------------------------------------------- clock

static RECT rectclk = {0, 0, DCLOCK_X, DCLOCK_Y};

void ddraws_dispclock(void) {

	DDSURFACEDESC	dest;

	if ((pClockSurf) && (dclock_disp())) {
		dclock_make();
		ZeroMemory(&dest, sizeof(dest));
		dest.dwSize = sizeof(dest);
		if (pClockSurf->Lock(NULL, &dest, DDLOCK_WAIT, NULL) == DD_OK) {
			if (SCREENMODE & SCMD_USEPAL) {
				dclock_out8(dest.lpSurface, dest.lPitch);
			}
			else {
				dclock_out16(dest.lpSurface, dest.lPitch);
			}
			pClockSurf->Unlock(NULL);
		}
		if (pPrimSurf->BltFast(640 - DCLOCK_X - 4, 480 - DCLOCK_Y - 8,
				pClockSurf, &rectclk, DDBLTFAST_WAIT) == DDERR_SURFACELOST) {
			pPrimSurf->Restore();
			pClockSurf->Restore();
		}
		dclock_cntdown(xmilcfg.DRAW_SKIP);
	}
}

