#include	<windows.h>
#include	"common.h"
#include	"xmil.h"
#include	"draw_sub.h"


// ---------------------------------------------------- 8C ANK LN^

										// esi = font face pointer
										// edi = vrampos
										// edx = text color | reverse flag
										// ecx = loop count (text height)

static LABEL void txt8_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				mov		dh, dl
				shr		cl, 1
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_right4half(void) {			// ׂEShbg

	__asm {
				mov		dh, dl
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_right4x2(void) {				// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				mov		dh, dl
				shr		cl, 1
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_halfx2(void) {				// ׂďc{p

	__asm {
				mov		dh, dl
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_halfx4left(void) {			// ׂĂS{p

	__asm {
				shl		dl, 2
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]		// ŏ̂P
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void txt8_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shl		dl, 2
				shr		cl, 1
				movzx	ebx, fontycnt
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]		// ŏ̂P
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


// ---------------------------------------------------- 8C PCG LN^

										// esi = font face pointer
										// edi = vrampos
										// edx = text color(1/2/4)
										// ecx = loop count (text height)

static LABEL void pcg8_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
				mov		dh, dl
makefaceloop:	and		bl, 7
				mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				mov		dh, dl
				shr		cl, 1
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				or		[edi+SCREEN_WIDTH*2+4], eax
				or		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				or		[edi+SCREEN_WIDTH*2+4], eax
				or		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				shr		cl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				or		[edi+SCREEN_WIDTH*2+4], eax
				or		[edi+SCREEN_WIDTH*3+4], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_right4half(void) {			// ׂEShbg

	__asm {
				mov		dh, dl
				shr		cl, 1

				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_right4x2(void) {				// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				mov		dh, dl
				shr		cl, 1
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				inc		bl
				and		bl, 7
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_halfx2(void) {				// ׂďc{p

	__asm {
				mov		dh, dl
				shr		cl, 1

				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				or		[edi+SCREEN_WIDTH*2+4], eax
				or		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_halfx4left(void) {			// ׂĂS{p

	__asm {
				shl		dl, 2
				shr		cl, 1

				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	shr		dh, 4
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				or		[edi+SCREEN_WIDTH*2+4], eax
				or		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void pcg8_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shl		dl, 2
				shr		cl, 1

				movzx	ebx, fontycnt			// tHgJE^W[
				shr		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]		// ŏ̂P񂾂
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 2
				and		bl, 7
makefaceout:	and		dh, 15
				mov		eax, text_x2_table[edx]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				or		[edi+SCREEN_WIDTH*0+4], eax
				or		[edi+SCREEN_WIDTH*1+4], eax
				or		[edi+SCREEN_WIDTH*2+4], eax
				or		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


// ---------------------------------------------------- 8C LN^

										// esi = font face pointer
										// edi = vrampos
										// edx = text color | reverse flag
										// ecx = loop count (text height)

static LABEL void knj8_nor(void) {					// m[}

	__asm {
				xor		ebx, ebx					// JE^͖߂
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 4
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x2left(void) {				// {p

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 4
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x2right(void) {				// {pE

	__asm {
				xor		ebx, ebx					// JE^͖߂
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 4
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_Yx2(void) {					// c{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x4left(void) {				// S{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_x4right(void) {				// S{pE

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				shl		dl, 2
makefaceloop:	mov		dh, [esi + ebx]
				and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_right4dot(void) {			// EShbg

	__asm {
				xor		ebx, ebx					// JE^͖߂
				mov		dh, dl
makefaceloop:	and		bl, 31
				mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 4
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_right4half(void) {			// ׂEShbg

	__asm {
				mov		dh, dl
				shr		cl, 1

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_right4x2(void) {				// EShbgc{p

	__asm {
				movzx	ebx, fontycnt			// tHgJE^W[
				shl		bl, 1
				mov		dh, dl
makefaceloop:	mov		dl, [esi + ebx]
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				xor		dl, dl
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				add		bl, 2
				and		bl, 31
				add		edi, SCREEN_WIDTH*2
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_halfx2(void) {				// ׂďc{p

	__asm {
				mov		dh, dl
				shr		cl, 1

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dl, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dl, [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, bmp2byte_table[edx*8 + BMP2B_TEXT + 4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_halfx4left(void) {			// ׂĂS{p

	__asm {
				shl		dl, 2
				shr		cl, 1

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	shr		dh, 4
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


static LABEL void knj8_halfx4right(void) {			// ׂĂS{pE

	__asm {
				shl		dl, 2
				shr		cl, 1

				movzx	ebx, fontycnt
				shl		bl, 1
				or		bl, bl
				je		makefaceloop

				mov		dh, [esi + ebx]				// ŏ̂P񂾂c
				xor		bl, bl
				jmp		makefaceout

makefaceloop:	mov		dh, [esi + ebx]
				add		bl, 8
				and		bl, 31
makefaceout:	and		dh, 15
				mov		eax, text_x2_table[edx]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		eax, text_x2_table[edx + 16*4]
				mov		[edi+SCREEN_WIDTH*0+4], eax
				mov		[edi+SCREEN_WIDTH*1+4], eax
				mov		[edi+SCREEN_WIDTH*2+4], eax
				mov		[edi+SCREEN_WIDTH*3+4], eax
				add		edi, SCREEN_WIDTH*4
				loop	makefaceloop
				ret
	}
}


// --------------------------------------------------------------------------

void draw_nop(void) { }

// --------------------------------------------------------------------------


void (*txt8effects[])(void) = {
						txt8_nor,					// m[}
						txt8_halfx2,				// ׂďc{p
						txt8_right4dot,				// EShbg
						txt8_right4half,			// ׂEShbg

						txt8_Yx2,					// c{p
						draw_nop,					// 肦Ȃ
						txt8_right4x2,				// EShbgc{p
						draw_nop,					// 肦Ȃ

						txt8_x2left,				// {p
						txt8_halfx4left,			// ׂĂS{p
						txt8_x2right,				// {pE
						txt8_halfx4right,			// ׂĂS{pE

						txt8_x4left,				// S{p
						draw_nop,					// 肦Ȃ
						txt8_x4right,				// S{pE
						draw_nop					// 肦Ȃ
};

void (*pcg8effects[])(void) = {
						pcg8_nor,					// m[}
						pcg8_halfx2,				// ׂďc{p
						pcg8_right4dot,				// EShbg
						pcg8_right4half,			// ׂEShbg

						pcg8_Yx2,					// c{p
						draw_nop,					// 肦Ȃ
						pcg8_right4x2,				// EShbgc{p
						draw_nop,					// 肦Ȃ

						pcg8_x2left,				// {p
						pcg8_halfx4left,			// ׂĂS{p
						pcg8_x2right,				// {pE
						pcg8_halfx4right,			// ׂĂS{pE

						pcg8_x4left,				// S{p
						draw_nop,					// 肦Ȃ
						pcg8_x4right,				// S{pE
						draw_nop					// 肦Ȃ
};

void (*knj8effects[])(void) = {
						knj8_nor,					// m[}
						knj8_halfx2,				// ׂďc{p
						knj8_right4dot,				// EShbg
						knj8_right4half,			// ׂEShbg

						knj8_Yx2,					// c{p
						draw_nop,					// 
						knj8_right4x2,				// EShbgc{p
						draw_nop,					//

						knj8_x2left,				// {p
						knj8_halfx4left,			// ׂĂS{p
						knj8_x2right,				// {pE
						knj8_halfx4right,			// ׂĂS{pE

						knj8_x4left,				// S{p
						draw_nop,					//
						knj8_x4right,				// S{pE
						draw_nop					//
};
