#include	<windows.h>
#include	<windowsx.h>
#include	<io.h>

#include	"xmil.h"
#include	"dialog.h"
#include	"dosio.h"
#include	"milstr.h"

#define		CFGLEN		(MAX_PATH + 32)

		BYTE	init_flag = 0;
		char	ini_title[] = "Xmillennium";

extern	int		winx;
extern	int		winy;
extern	char	fileselectfolder[MAX_PATH];
extern	char	bmpfilefolder[MAX_PATH];

typedef struct {
	char	item[9];
	BYTE	itemtype;
	WORD	flag;
	void	*value;
	DWORD	arg;
} INI_ITEM;

#define	INI_RO		0x0001
#define	INIAND		0x0002
#define	INIMAX		0x0004
#define	INIA4		0x0008
#define	INIEND		0x8000

#define	INI_STR		0x00
#define	INI_BOOL	0x01
#define	INI_ARG		0x02
#define	INI_BYTE	0x11
#define	INI_WORD	0x12
#define	INI_DWORD	0x14
#define	INI_HEXB	0x21
#define	INI_HEXD	0x24
#define	INI_EX		0x80


static INI_ITEM iniitem[] = {
	{"WindposX", INI_DWORD,	0,		&winx,					0},
	{"WindposY", INI_DWORD, 0,		&winy,					0},
	{"Win_Snap", INI_BOOL,	0,		&xmilcfg.WINSNAP,		0},
	{"backgrnd", INI_BYTE,	INIAND,	&xmilcfg.background,	0x03},
	{"DspClock", INI_BYTE,	INIAND,	&xmilcfg.DISPCLK,		0x03},

	{"StartDir", INI_STR,	INIMAX,	fileselectfolder,		MAX_PATH},
	{"bmap_Dir", INI_STR,	INIMAX,	bmpfilefolder,			MAX_PATH},

	{"IPL_TYPE", INI_BYTE,	INIMAX,	&xmilcfg.ROM_TYPE,		3},
	{"cpu_8MHz", INI_BOOL,	0,		&xmilcfg.CPU8MHz,		0},

	{"Resolute", INI_HEXB,	0,		&xmilcfg.DIP_SW,		0},
	{"SkipLine", INI_BOOL,	0,		&xmilcfg.SKIP_LINE,		0},
	{"s_NOWAIT", INI_BOOL,	0,		&xmilcfg.NOWAIT,		0},
	{"SkpFrame", INI_BYTE,	0,		&xmilcfg.DRAW_SKIP,		0},
	{"LinLIGHT", INI_HEXB,	0,		&xmilcfg.LINEDEPTH,		0},
	{"BlkLIGHT", INI_HEXB,	0,		&xmilcfg.BLKLIGHT,		0},
	{"TxtLIGHT", INI_HEXB,	0,		&xmilcfg.LINETEXT,		0},
	{"Text_Ext", INI_BOOL,	0,		&xmilcfg.TEXTMODE,		0},
	{"Text_400", INI_HEXB,	0,		&xmilcfg.TEXT400L,		0},

	{"OPMsound", INI_BOOL,	0,		&xmilcfg.SOUND_SW,		0},
	{"SampleHz", INI_WORD,	0,		&xmilcfg.samplingrate,	0},
	{"Latencys", INI_WORD,	0,		&xmilcfg.delayms,		0},
	{"SoundPly", INI_BOOL,	0,		&xmilcfg.SOUNDPLY,		0},
	{"D_Sound3", INI_BOOL,	0,		&xmilcfg.DSOUND3,		0},
	{"PUCHInos", INI_BOOL,	0,		&xmilcfg.PUCHI,			0},
	{"Seek_Snd", INI_BOOL,	0,		&xmilcfg.MOTOR,			0},
	{"Seek_Vol", INI_BYTE,	INIMAX,	&xmilcfg.MOTORVOL,		100},

	{"Joystick", INI_BOOL,	0,		&xmilcfg.JOYSTICK,		0},
	{"btnRAPID", INI_BOOL,	0,		&xmilcfg.BTN_RAPID,		0},
	{"btn_MODE", INI_BOOL,	0,		&xmilcfg.BTN_MODE,		0},
	{"MouseInt", INI_BOOL,	0,		&xmilcfg.MOUSE_SW,		0},

	{"clocknow", INI_BYTE,	0,		&xmilcfg.clockx,		0},
	{"clockfnt", INI_BYTE,	0,		&xmilcfg.clockfnt,		0},
	{"clock_up", INI_HEXD,	INI_RO|INIAND,
									&xmilcfg.clockcolor1,	0xffffff},
	{"clock_dn", INI_HEXD,	INI_RO|INIAND,
									&xmilcfg.clockcolor2,	0xffffff},

	{"Z80_SAVE", INI_BOOL,	INI_RO|INIEND,
									&xmilcfg.Z80SAVE,		0},
};

static	char	cfgLICENCE[]	= "Licenced";


static long solveHEX(char *str) {

	return(milstr_solveHEX(str));
}

static char *makeBOOL(BYTE value) {

	if (value) {
		return("true");
	}
	return("false");
}

BYTE solveBOOL(LPSTR str) {

	if ((!milstr_cmpA(str, "TRUE")) || (!milstr_cmpA(str, "ON")) ||
		(!milstr_cmpA(str, "+")) || (!milstr_cmpA(str, "1")) ||
		(!milstr_cmpA(str, "ENABLE"))) {
		return(1);
	}
	return(0);
}

void initload(void) {

	char		initfile[MAX_PATH + 5];
	char		cfgstr[CFGLEN];
	DWORD		i;
	char		*arg[8];
	DWORD		args;
	INI_ITEM	*p;

	init_flag = 0;

	strcpy(initfile, __argv[0]);
	cutExtName(initfile);
	strcat(initfile, ".ini");

	p = iniitem;
	while(1) {
		if (!(p->itemtype & 0xf0)) {
			switch(p->itemtype) {
				case INI_STR:
					GetPrivateProfileString(ini_title, p->item,
										(char *)p->value, (char *)p->value,
										p->arg, initfile);
					break;
				case INI_BOOL:
					GetPrivateProfileString(ini_title, p->item,
										makeBOOL(*((BYTE *)p->value) & 1),
												cfgstr, CFGLEN, initfile);
					*(BYTE *)(p->value) = solveBOOL(cfgstr);
					break;
				case INI_ARG:
					GetPrivateProfileString(ini_title, p->item, "",
												cfgstr, CFGLEN, initfile);
					args = milstr_getarg(cfgstr, arg, p->arg);
					if (args == p->arg) {
						for (i=0; i<args; i++) {
							((BYTE *)p->value)[i] = (BYTE)solveHEX(arg[i]);
							if (p->flag & INIA4) {
								((BYTE *)p->value)[i] &= 0x0f;
							}
						}
					}
					break;
			}
		}
		else if (!(p->itemtype & INI_EX)) {
			switch(p->itemtype) {
				case INI_BYTE:
					*(BYTE *)p->value = (BYTE)GetPrivateProfileInt(
							ini_title, p->item, *(BYTE *)p->value, initfile);
					break;
				case INI_WORD:
					*(WORD *)p->value = (WORD)GetPrivateProfileInt(
							ini_title, p->item, *(WORD *)p->value, initfile);
					break;
				case INI_DWORD:
					*(DWORD *)p->value = (DWORD)GetPrivateProfileInt(
							ini_title, p->item, *(DWORD *)p->value, initfile);
					break;
				case INI_HEXB:
					wsprintf(cfgstr, "%x", *(BYTE *)p->value),
					GetPrivateProfileString(ini_title, p->item,
										cfgstr, cfgstr, CFGLEN, initfile);
					*(BYTE *)p->value = (BYTE)solveHEX(cfgstr);
					break;
				case INI_HEXD:
					wsprintf(cfgstr, "%x", *(DWORD *)p->value),
					GetPrivateProfileString(ini_title, p->item,
										cfgstr, cfgstr, CFGLEN, initfile);
					*(DWORD *)p->value = solveHEX(cfgstr);
					break;
			}
			if (p->flag & INIMAX) {
				switch((p->itemtype) & 0x0f) {
					case 1:
						if (*(BYTE *)p->value > (BYTE)p->arg) {
							*(BYTE *)p->value = (BYTE)p->arg;
						}
						break;
					case 2:
						if (*(WORD *)p->value > (WORD)p->arg) {
							*(WORD *)p->value = (WORD)p->arg;
						}
						break;
					case 4:
						if (*(DWORD *)p->value > (DWORD)p->arg) {
							*(DWORD *)p->value = (DWORD)p->arg;
						}
						break;
				}
			}
			if (p->flag & INIAND) {
				switch((p->itemtype) & 0x0f) {
					case 1:
						*(BYTE *)p->value &= (BYTE)p->arg;
						break;
					case 2:
						*(WORD *)p->value &= (WORD)p->arg;
						break;
					case 4:
						*(DWORD *)p->value &= (DWORD)p->arg;
						break;
				}
			}
		}
		if (p->flag & INIEND) {
			break;
		}
		p++;
	}

	if (GetPrivateProfileString(ini_title, cfgLICENCE, "",
				&licenced[LICENCED_POS], LICENCED_LENG, initfile)) {
		if (kanji1st(licenced, LICENCED_POS + LICENCED_LENG - 2)) {
			licenced[LICENCED_POS + LICENCED_LENG - 2] = '\0';
		}
	}
}

void initsave(void) {

	char		initfile[MAX_PATH + 5];
	char		cfgstr[CFGLEN];
	DWORD		i;
	INI_ITEM	*p;

	if (!init_flag) {
		return;
	}
	strcpy(initfile, __argv[0]);
	cutExtName(initfile);
	strcat(initfile, ".ini");

	p = iniitem;
	while(1) {
		if (p->flag & INI_RO) {
		}
		else if (!(p->itemtype & INI_EX)) {
			switch(p->itemtype) {
				case INI_STR:
					WritePrivateProfileString(ini_title, p->item,
												(char *)p->value, initfile);
					break;
				case INI_BOOL:
					WritePrivateProfileString(ini_title, p->item,
								makeBOOL(*((BYTE *)p->value) & 1), initfile);
					break;
				case INI_ARG:
					for (i=0; i<p->arg; i++) {
						wsprintf(&cfgstr[i*3], "%02x ",
													((BYTE *)p->value)[i]);
					}
					cfgstr[i*3-1] = '\0';
					WritePrivateProfileString(ini_title, p->item,
															cfgstr, initfile);
					break;
				case INI_BYTE:
					wsprintf(cfgstr, "%u", *(BYTE *)p->value);
					WritePrivateProfileString(ini_title, p->item,
														cfgstr, initfile);
					break;
				case INI_WORD:
					wsprintf(cfgstr, "%u", *(WORD *)p->value);
					WritePrivateProfileString(ini_title, p->item,
														cfgstr, initfile);
					break;
				case INI_DWORD:
					wsprintf(cfgstr, "%u", *(DWORD *)p->value);
					WritePrivateProfileString(ini_title, p->item,
														cfgstr, initfile);
					break;
				case INI_HEXB:
					wsprintf(cfgstr, "%x", *(BYTE *)p->value);
					WritePrivateProfileString(ini_title, p->item,
														cfgstr, initfile);
					break;
				case INI_HEXD:
					wsprintf(cfgstr, "%x", *(DWORD *)p->value);
					WritePrivateProfileString(ini_title, p->item,
														cfgstr, initfile);
					break;
			}
		}
		if (p->flag & INIEND) {
			break;
		}
		p++;
	}
}
