#include	<windows.h>
#include	<windowsx.h>
#include	<string.h>
#include	"resource.h"
#include	"xmil.h"
#include	"ini.h"
#include	"dosio.h"
#include	"fdd_d88.h"

extern	HWND	hWndMain;
extern	HWND	hInst;
extern	char	fileselectfolder[MAX_PATH];

#define	DISKLABELLEN	16

static	int		make2hd = 0;
static	char	disklabel[DISKLABELLEN+2];


static LPSTR newdiskselect(void) {

		OPENFILENAME	ofn;
		BOOL			r;
static	char			pathname[MAX_PATH+16];
static	char			filename[MAX_PATH];

	ZeroMemory(&ofn, sizeof(OPENFILENAME));

	strcpy(pathname, fileselectfolder);
	cutFileName(pathname);
	strcat(pathname, "newdisk.d88");
	strcpy(filename, "");

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWndMain;
	ofn.lpstrFilter = "D88 image files (*.D88;*.88D)\0"				\
											"*.d88;*.88d\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = pathname;
	ofn.lpstrFileTitle = filename;
	ofn.nMaxFile = MAX_PATH;
	ofn.nMaxFileTitle = sizeof(filename);
	ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
	ofn.lpstrDefExt = "d88";
	ofn.lpstrTitle = "VK D88C[W";

	r = GetSaveFileName(&ofn);

	if (!r) {
		return(NULL);
	}
	INIT_RENEWAL
		strcpy(fileselectfolder, pathname);
	return(pathname);
}



LRESULT CALLBACK NewdiskDlgProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp) {

	switch (msg) {
		case WM_INITDIALOG:
			if (make2hd) {
				Button_SetCheck(GetDlgItem(hWnd, IDC_MAKE2HD), TRUE);
			}
			else {
				Button_SetCheck(GetDlgItem(hWnd, IDC_MAKE2D), TRUE);
			}
			return(FALSE);
		case WM_COMMAND:
			switch (LOWORD(wp)) {
				case IDOK:
					Edit_GetText(GetDlgItem(hWnd, IDC_DISKLABEL),
											disklabel, DISKLABELLEN+1);
					disklabel[DISKLABELLEN] = '\0';
					if (kanji1st(disklabel, DISKLABELLEN - 1)) {
						disklabel[DISKLABELLEN-1] = '\0';
					}
					make2hd = Button_GetCheck(GetDlgItem(hWnd, IDC_MAKE2HD));
					EndDialog(hWnd, IDOK);
					break;
				case IDCANCEL:
					EndDialog(hWnd, IDCANCEL);
					break;
				default:
					return(FALSE);
			}
			break;
		case WM_CLOSE:
			PostMessage(hWnd, WM_COMMAND, IDCANCEL, 0);
			break;
		default:
			return(FALSE);
	}
	return(TRUE);
}



void newdisk(HWND hWnd) {

	D88_HEADER	d88head;
	FILEH		fh;
	LPSTR		filename;

	filename = newdiskselect();
	if (filename == NULL) {
		return;
	}
	if (DialogBox(hInst, MAKEINTRESOURCE(IDD_NEWDISK),
					hWnd, (DLGPROC)NewdiskDlgProc) != IDOK) {
		return;
	}

	ZeroMemory(&d88head, sizeof(D88_HEADER));
	d88head.fd_size = sizeof(D88_HEADER);
	strcpy((char *)d88head.fd_name, disklabel);

	if (make2hd) {
		d88head.fd_type = 0x20;
	}
	if ((fh = file_create(filename)) != (FILEH)-1) {
		file_write(fh, &d88head, sizeof(D88_HEADER));
		file_close(fh);
	}
}
